/*
 * Decompiled with CFR 0.152.
 */
package peli;

import java.awt.Point;
import java.util.Random;
import org.lwjgl.Sys;
import peli.Atom;
import peli.Brain;
import peli.Entity;
import peli.Idea;
import peli.Model;

public class Enemy
extends Entity {
    private Point destination;
    private int timer;
    private int type;
    private int points;
    int shot_freq;
    Random rand;
    private boolean done;
    private Brain brain;
    Idea currentOrder;
    private int targeted;

    public void setTimer(int t) {
        this.timer = t;
    }

    public void setBrain(Brain b) {
        this.brain = b;
    }

    public int getIntType() {
        return this.type;
    }

    Enemy(double x, double y, int timer, Brain brain, Model w, int type, Atom[][] t) {
        this.rep = t;
        this.targeted = 0;
        this.tuleeSivusta = false;
        this.deadlyToPlayer = true;
        this.deadlyToEnemies = false;
        this.willBeDrawn = false;
        this.checkCollisions = false;
        this.isBullet = false;
        this.rand = new Random();
        this.brain = brain;
        this.done = false;
        this.world = w;
        this.current = 0;
        this.xborder = w.getXsize();
        this.yborder = w.getYsize();
        this.state = "Dormant";
        this.currentOrder = new Idea();
        this.rand = new Random();
        this.timer = timer;
        this.type = type;
        ((Entity)this).type = "Enemy";
        this.shields = 1000;
        this.shot_freq = 9990;
        ((Entity)this).points = 30;
        this.speed = 0.5f;
        this.shields = 1000;
        this.massMultiplier = 2;
        this.massDampening = 0.95f;
        if (type == 33) {
            this.massDampening = 0.75f;
        }
        if (type == 2) {
            ((Entity)this).points = 10;
            this.speed = 0.8f;
            this.massMultiplier = 3;
            this.shields = 2000;
            this.massDampening = 0.9f;
        }
        if (type == 3) {
            ((Entity)this).points = 15;
            this.speed = 0.6f;
            this.massMultiplier = 4;
        }
        if (type == 4) {
            ((Entity)this).points = 20;
            this.speed = 0.6f;
            this.shields = 2000;
            this.massMultiplier = 3;
        }
        this.middle = new Point((int)x, (int)y);
        this.xx = x;
        this.yy = y;
        this.delta = 0L;
        this.lastTime = Sys.getTime();
    }

    public int getTypeInt() {
        return this.type;
    }

    public void beingTargeted(int targettingIncrement) {
        if (this.targeted < 100) {
            this.targeted += targettingIncrement;
        }
        if (targettingIncrement == 0) {
            this.targeted = 101;
        }
    }

    public void releaseTarget() {
        this.targeted = 0;
    }

    public int getTargeted() {
        return this.targeted;
    }

    public void setType(int t) {
        this.type = t;
    }

    public Brain getBrain() {
        return this.brain;
    }

    public int getPoints() {
        return ((Entity)this).points;
    }

    public Point getDestination() {
        return this.destination;
    }

    public void setDestinationToMiddle() {
        this.destination = (Point)this.middle.clone();
    }

    @Override
    public void Live() {
        this.delta = Sys.getTime() - this.lastTime;
        if (this.state == "Destroyed") {
            this.coolDown();
            this.disperseAtoms();
            return;
        }
        if (this.shields <= 0) {
            this.state = "About to be destroyed";
            this.checkCollisions = false;
            this.Explode();
            return;
        }
        if ((this.state == "Fading in" || this.state == "Waiting" || this.state == "Fading out" || this.state == "Dormant") && this.delta > (long)this.timer) {
            this.done = true;
        }
        if (this.done) {
            this.done = false;
            this.currentOrder = this.brain.getNewOrder();
            this.checkCollisions = true;
            this.willBeDrawn = true;
            if (this.tuleeSivusta && this.middle.x < this.xborder - 20) {
                this.tuleeSivusta = false;
            }
            if (this.currentOrder.type == "Change speed") {
                this.state = "Changing speed";
                this.speed = ((Float)this.currentOrder.value).floatValue();
                this.done = true;
            }
            if (this.currentOrder.type == "Shoot") {
                this.state = "Shooting";
                this.world.addEnemyBullet(this.middle.x, this.middle.y, 2);
                this.done = true;
            }
            if (this.currentOrder.type == "First move" || this.currentOrder.type == "Move") {
                this.state = "Moving";
                this.destination.x += ((Point)this.currentOrder.value).x;
                this.destination.y += ((Point)this.currentOrder.value).y;
                this.refreshVectors();
            }
            if (this.currentOrder.type == "Stop") {
                this.state = "Stopped";
                this.destination.x = 0;
                this.destination.y = 0;
            }
            if (this.currentOrder.type == "Wait") {
                this.timer = (Integer)this.currentOrder.value;
                this.state = "Waiting";
                this.lastTime = Sys.getTime();
                this.delta = 0L;
            }
            if (this.currentOrder.type == "Escape") {
                this.willBeDrawn = false;
                this.alive = false;
                this.world.levelNotClear = true;
            }
            if (this.currentOrder.type == "Fade in") {
                this.timer = (Integer)this.currentOrder.value;
                this.state = "Fading in";
                this.checkCollisions = false;
                this.lastTime = Sys.getTime();
                this.delta = 0L;
            }
            if (this.currentOrder.type == "Fade out") {
                this.checkCollisions = false;
                this.timer = (Integer)this.currentOrder.value;
                this.state = "Fading out";
                this.lastTime = Sys.getTime();
                this.delta = 0L;
            }
        }
        if (this.state == "Waiting" && this.delta > (long)this.timer) {
            this.done = true;
        }
        if (this.state == "Hit" && this.delta > 50L) {
            if (this.currentOrder.type == "Move" || this.currentOrder.type == "First move") {
                this.state = "Moving";
            }
            if (this.currentOrder.type == "Wait") {
                this.state = "Waiting";
            }
        }
        if (this.state == "Moving") {
            this.moveIt();
            if (this.rand.nextInt(10000) > this.shot_freq && this.middle.x > 0 && this.middle.x < this.xborder) {
                this.world.addEnemyBullet(this.middle.x, this.middle.y, this.type);
            }
            this.lastTime = Sys.getTime();
        }
    }

    private void disperseAtoms() {
        if (this.delta < 5000L) {
            Atom[] atomArray = this.rep[this.current];
            int n = atomArray.length;
            int n2 = 0;
            while (n2 < n) {
                Atom a = atomArray[n2];
                a.x_coord += a.getXVector();
                a.y_coord += a.getYVector();
                a.setXVector(a.getXVector() * this.massDampening);
                a.setYVector(a.getYVector() * this.massDampening);
                ++n2;
            }
        } else {
            this.alive = false;
        }
    }

    public void refreshVectors() {
        this.xVector = this.destination.x - this.middle.x;
        this.yVector = this.destination.y - this.middle.y;
        this.length = (float)Math.sqrt(this.xVector * this.xVector + this.yVector * this.yVector);
        this.xUnitVector = this.xVector / this.length;
        this.yUnitVector = this.yVector / this.length;
    }

    @Override
    public void moveIt() {
        super.moveIt();
        if (this.middle.x >= this.xborder && this.xVector > 0.0f) {
            this.middle.x -= this.xborder;
            this.xx = this.middle.x;
            this.destination.x -= this.xborder;
        }
        if (this.middle.x <= 0 && this.xVector < 0.0f) {
            this.middle.x += this.xborder;
            this.xx = this.middle.x;
            this.destination.x += this.xborder;
        }
        if (this.middle.y >= this.yborder) {
            this.middle.y -= this.yborder;
            this.yy = this.middle.y;
            this.destination.y -= this.yborder;
        }
        if (this.destination.distance(this.xx, this.yy) < 2.0) {
            this.refreshVectors();
            if ((double)this.middle.x == this.destination.getX() && (double)this.middle.y == this.destination.getY()) {
                this.done = true;
            }
        }
    }

    public boolean typeMatches(int t) {
        return t == this.type;
    }

    public void setPoints(int points2) {
        ((Entity)this).points = points2;
    }
}

