/*
 * Decompiled with CFR 0.152.
 */
package peli;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Random;
import org.lwjgl.Sys;
import peli.Atom;
import peli.Model;

public class Entity {
    protected Atom[][] rep;
    protected int[][] repInt;
    protected String type;
    protected float speed;
    protected int shields;
    protected boolean alive = true;
    protected Point middle;
    protected long delta;
    protected long lastTime;
    protected int points;
    protected float xVector;
    protected float yVector;
    protected String state;
    protected long timer;
    protected float xUnitVector;
    protected float yUnitVector;
    protected float length;
    protected double xx;
    protected double yy;
    protected boolean hasFired;
    protected Model world;
    protected int xsize;
    protected int ysize;
    protected int zoomlevel;
    boolean deadlyToPlayer;
    boolean deadlyToEnemies;
    boolean willBeDrawn;
    boolean checkCollisions;
    boolean isBullet;
    boolean tuleeSivusta;
    boolean pause;
    protected float massDampening;
    protected int xborder;
    protected int yborder;
    protected int current;
    protected int massMultiplier;
    public int explosionType;

    Entity(ArrayList<ArrayList<Atom>> t) {
        this.rep = new Atom[t.size()][t.get(0).size()];
        int p = 0;
        for (ArrayList<Atom> a : t) {
            a.toArray(this.rep[p]);
            ++p;
        }
    }

    public void setMassDampening(float md) {
        this.massDampening = md;
    }

    public float getMassDampening() {
        return this.massDampening;
    }

    Entity() {
    }

    public ArrayList<Atom> makeRepresentation(int[][] r) {
        ArrayList<Atom> palautus = new ArrayList<Atom>();
        int k = 0;
        while (k < r.length) {
            int j = 0;
            while (j < r[k].length) {
                if (r[k][j] != 0) {
                    palautus.add(new Atom(j, k, r[k][j]));
                }
                ++j;
            }
            ++k;
        }
        return palautus;
    }

    public boolean didItHit(float x, float y) {
        Atom[] atomArray = this.rep[this.current];
        int n = atomArray.length;
        int n2 = 0;
        while (n2 < n) {
            Atom a = atomArray[n2];
            int xxx = this.xsize * 2;
            int yyy = this.ysize * 2;
            if (a.x_coord + (float)this.middle.x > (float)this.xsize) {
                xxx = (int)(a.x_coord + (float)this.middle.x - (float)this.xsize);
            }
            if (a.y_coord + (float)this.middle.y > (float)this.ysize) {
                yyy = (int)(a.y_coord + (float)this.middle.y - (float)this.ysize);
            }
            if (a.x_coord + (float)this.middle.x < 0.0f) {
                xxx = (int)(a.x_coord + (float)this.middle.x + (float)this.xsize);
            }
            if (a.y_coord + (float)this.middle.y < 0.0f) {
                yyy = (int)(a.y_coord + (float)this.middle.y + (float)this.ysize);
            }
            if ((float)xxx == x && (float)yyy == y) {
                return true;
            }
            if (a.x_coord + (float)this.middle.x == x && a.y_coord + (float)this.middle.y == y) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void youWereHit(Entity e, boolean firstHit) {
        if (firstHit && this.shields > 0) {
            int apu = e.shields;
            e.shields -= this.shields;
            this.shields -= apu;
        }
        this.state = "Hit";
        if (this.isBullet) {
            if (this.type == "Missile1" || this.type == "Missile2") {
                this.shields = 0;
            }
            if (this.shields <= 0) {
                this.alive = false;
            }
            return;
        }
        if (this.shields <= 0) {
            this.state = "About to be destroyed";
            this.checkCollisions = false;
        }
    }

    public void fixMiddle() {
        float minX = 100.0f;
        float minY = 100.0f;
        int xxx = this.getRealMiddle().x;
        int yyy = this.getRealMiddle().y;
        int o = 0;
        while (o < this.rep.length) {
            Atom a;
            Atom[] atomArray = this.rep[o];
            int n = atomArray.length;
            int n2 = 0;
            while (n2 < n) {
                a = atomArray[n2];
                if (minX > a.x_coord) {
                    minX = a.x_coord;
                }
                if (minY > a.y_coord) {
                    minY = a.y_coord;
                }
                ++n2;
            }
            xxx = (int)((float)xxx + minX);
            yyy = (int)((float)yyy + minY);
            atomArray = this.rep[o];
            n = atomArray.length;
            n2 = 0;
            while (n2 < n) {
                a = atomArray[n2];
                a.x_coord -= (float)xxx;
                a.y_coord -= (float)yyy;
                ++n2;
            }
            ++o;
        }
        xxx = this.middle.x - xxx;
        yyy = this.middle.y - yyy;
        this.middle = new Point(xxx, yyy);
        this.xx = this.middle.x;
        this.yy = this.middle.y;
    }

    public void setFired() {
        this.hasFired = true;
    }

    public Point getRealMiddle() {
        int xIsoin = 0;
        int yIsoin = 0;
        Atom[] atomArray = this.rep[this.current];
        int n = atomArray.length;
        int n2 = 0;
        while (n2 < n) {
            Atom a = atomArray[n2];
            if (a.x_coord > (float)xIsoin) {
                xIsoin = (int)a.x_coord;
            }
            if (a.y_coord > (float)yIsoin) {
                yIsoin = (int)a.y_coord;
            }
            ++n2;
        }
        return new Point(xIsoin / 2, yIsoin / 2);
    }

    public int howManyNonZeros(int[][] r) {
        int palautus = 0;
        int[][] nArray = r;
        int n = r.length;
        int n2 = 0;
        while (n2 < n) {
            int[] k;
            int[] nArray2 = k = nArray[n2];
            int n3 = k.length;
            int n4 = 0;
            while (n4 < n3) {
                int p = nArray2[n4];
                if (p != 0) {
                    ++palautus;
                }
                ++n4;
            }
            ++n2;
        }
        return palautus;
    }

    public void togglePause() {
        if (this.pause) {
            this.pause = false;
            this.lastTime = Sys.getTime() - this.delta;
        } else {
            this.pause = true;
        }
    }

    public void Explode() {
        Random rand = new Random();
        Atom[] atomArray = this.rep[this.current];
        int n = atomArray.length;
        int n2 = 0;
        while (n2 < n) {
            Atom a = atomArray[n2];
            a.temperature = 3200 / (1 + (int)Math.sqrt(a.x_coord * a.x_coord + a.y_coord * a.y_coord));
            float radius = rand.nextFloat() * 2.0f + 1.2f;
            a.setXVector(a.x_coord / radius);
            a.setYVector(a.y_coord / radius);
            ++n2;
        }
    }

    public void coolDown() {
        Atom[] atomArray = this.rep[this.current];
        int n = atomArray.length;
        int n2 = 0;
        while (n2 < n) {
            Atom a = atomArray[n2];
            if (a.temperature > 6) {
                a.temperature -= 5;
            }
            ++n2;
        }
    }

    public Atom[] getRep() {
        return this.rep[this.current];
    }

    public void setRep(Atom[] a) {
        this.rep[this.current] = a;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String s) {
        this.state = s;
    }

    public double getSpeed() {
        return this.speed;
    }

    public boolean isAlive() {
        return this.alive;
    }

    public void moveIt() {
        if (this.type == "Player1" || this.type == "Player2") {
            this.xx += (double)this.xVector;
            this.yy += (double)this.yVector;
        } else {
            this.xx += (double)(this.xUnitVector * this.speed);
            this.yy += (double)(this.yUnitVector * this.speed);
        }
        this.middle.setLocation(this.xx, this.yy);
    }

    public void Live() {
        if (!this.alive) {
            return;
        }
        this.delta = Sys.getTime() - this.lastTime;
        this.lastTime = Sys.getTime();
    }

    public int getShields() {
        return this.shields;
    }

    public String getType() {
        return this.type;
    }

    public long getTimer() {
        return this.timer;
    }

    public void setTimer(long l) {
        this.timer = l;
    }
}

