/*
 * Decompiled with CFR 0.152.
 */
package peli;

import java.util.ArrayList;
import java.util.Random;
import peli.CampaignPlayer;
import peli.Order;
import peli.Planet;
import peli.Universe;

public class Fleet {
    protected float xx;
    protected float yy;
    protected CampaignPlayer owner;
    protected Planet current;
    protected Planet targetPlanet;
    protected Fleet targetFleet;
    protected String mode;
    protected int strength;
    protected String orders;
    boolean retreat;
    boolean inOrbit = true;
    boolean inFlight = false;
    Universe maailma;
    private float radius = 0.0f;
    Random r;
    private boolean colonize;
    private boolean intercept;
    private boolean attack;
    private boolean returnBase;
    private Order currentOrder = new Order();
    private int ticks = 0;
    int number;
    private boolean wait = false;
    private boolean isVisible;

    Fleet(Planet p, CampaignPlayer c, Universe u) {
        this.r = new Random();
        this.maailma = u;
        this.owner = c;
        this.strength = 1;
        this.current = p;
        this.xx = p.getXPlace();
        this.yy = p.getYPlace();
        this.retreat = false;
        this.targetPlanet = null;
        this.current.setFleetInOrbit(this);
        this.current = p;
        if (c.nimi == "Player1") {
            this.isVisible = true;
        }
    }

    public int getStrength() {
        return this.strength;
    }

    public boolean areTheyClose(float x1, float y1, float x2, float y2, int threshold) {
        return (double)threshold > Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
    }

    private Planet getClosestPlanet(ArrayList<Planet> plist) {
        Planet closest = null;
        for (Planet p : plist) {
            if (closest == null) {
                closest = p;
            }
            if (!(this.distance(p.xx, p.yy, this.xx, this.yy) < this.distance(closest.xx, closest.yy, this.xx, this.yy))) continue;
            closest = p;
        }
        return closest;
    }

    private Fleet getClosestFleet(ArrayList<Fleet> flist) {
        Fleet closest = null;
        for (Fleet f : flist) {
            if (closest == null) {
                closest = f;
            }
            if (!(this.distance(f.xx, f.yy, this.xx, this.yy) < this.distance(closest.xx, closest.yy, this.xx, this.yy))) continue;
            closest = f;
        }
        return closest;
    }

    private Planet getNewbase() {
        if (this.current != null) {
            return this.current;
        }
        return this.getClosestPlanet(this.maailma.getPlanetsByOwner(this.owner.nimi));
    }

    public void AttackFleet(Fleet target) {
        if (this.current != null) {
            this.leaveOrbit();
        }
        if (target != null) {
            if (this.areTheyClose(this.xx, this.yy, target.xx, target.yy, 1)) {
                this.maailma.battleItOut(this, target);
                if (this.strength > 0 && target.current != null) {
                    this.Colonize(target.current);
                }
                this.currentOrder.setOrder("Done");
            } else {
                this.fleetGetCloserTo(target.xx, target.yy);
            }
        }
        if (target == null) {
            this.currentOrder.setOrder("Done");
        }
    }

    public void liveIt() {
        if (this.strength == 0) {
            return;
        }
        if (this.wait) {
            this.wait = false;
            return;
        }
        if (this.owner.nimi != "Player1" && this.current == null) {
            this.isVisible = false;
            for (Planet p : this.maailma.getPlanetsByOwner("Player1")) {
                if (!this.areTheyClose(this.xx, this.yy, p.xx, p.yy, p.getRadarCoverage())) continue;
                this.isVisible = true;
                break;
            }
        }
        if (this.current == null) {
            for (Fleet f : this.maailma.getOthersFleets(this.owner)) {
                if (!this.areTheyClose(this.xx, this.yy, f.xx, f.yy, 1)) continue;
                this.maailma.battleItOut(this, f);
            }
        }
        if (this.currentOrder.getOrder() == "Done") {
            this.currentOrder = this.getNewOrder();
        }
        if (this.currentOrder.getOrder() == "Stay put" || this.currentOrder.getOrder() == "") {
            ++this.ticks;
        }
        if (this.ticks > 500) {
            this.currentOrder.setOrder("Done");
            this.ticks = 0;
        }
        if (this.currentOrder.getOrder() == "Colonize") {
            this.Colonize((Planet)this.currentOrder.getSubject());
        }
        if (this.currentOrder.getOrder() == "Attack fleet") {
            this.AttackFleet((Fleet)this.currentOrder.getSubject());
        }
        if (this.currentOrder.getOrder() == "Return to base") {
            this.returnToBase((Planet)this.currentOrder.getSubject());
        }
        if (this.currentOrder.getOrder() == "Merge with fleet") {
            this.mergeWithFleet((Fleet)this.currentOrder.getSubject());
        }
        if (this.currentOrder.getOrder() == "Go to planet") {
            this.goToPlanet((Planet)this.currentOrder.getSubject());
        }
    }

    private void goToPlanet(Planet target) {
        if (this.current != null) {
            this.leaveOrbit();
        }
        if (target != null) {
            if (this.areTheyClose(this.xx, this.yy, target.xx, target.yy, 1)) {
                if (target.fleetInOrbit != null && target.fleetInOrbit.owner != this.owner) {
                    this.maailma.battleItOut(this, target.fleetInOrbit);
                    if (this.strength == 0) {
                        return;
                    }
                }
                this.arriveToOrbit(target);
                this.currentOrder.setOrder("Done");
            } else {
                this.fleetGetCloserTo(target.xx, target.yy);
            }
        }
    }

    private void mergeWithFleet(Fleet target) {
        if (this.current != null) {
            this.leaveOrbit();
        }
        if (target.strength == 0) {
            target = null;
        }
        if (target != null && target.owner == this.owner) {
            if (this.areTheyClose(this.xx, this.yy, target.xx, target.yy, 1)) {
                target.strength += this.strength;
                this.strength = 0;
                return;
            }
            if (this.areTheyClose(this.xx, this.yy, target.xx, target.yy, 20)) {
                target.notifyMerging();
            }
            this.fleetGetCloserTo(target.xx, target.yy);
        }
        if (target == null || target == this) {
            this.currentOrder.setOrder("Done");
        }
    }

    private void notifyMerging() {
        if (this.currentOrder.getOrder() != "Merge with fleet") {
            this.wait = true;
        }
    }

    public Planet getCurrent() {
        return this.current;
    }

    private Order getNewOrder() {
        ArrayList<Planet> apu = new ArrayList<Planet>();
        Order palautus = new Order();
        palautus.setOrder("Stay put", null);
        int strengthSub = 0;
        strengthSub = this.current != null ? this.strength - (int)this.current.getPreferredNumberOfFleets() : this.strength;
        if (this.current != null && this.current.owner == this.owner && this.strength <= this.owner.minFleetStrength + this.maailma.planets.size() / 5) {
            return palautus;
        }
        if (this.current != null) {
            for (Planet p : this.maailma.getPlanetsByOwner(this.owner.nimi)) {
                if (p.getFleetInOrbit() != null && !((double)(p.actualProduction / (float)p.productionPotential) < 0.2) && (!((double)(p.getFleetInOrbit().strength + 1) < p.getPreferredNumberOfFleets()) || this.maailma.getPlanetsByOwner("None").size() != 0) || p == this.current) continue;
                apu.add(p);
            }
            if (apu.size() > 0 && (this.r.nextBoolean() || this.r.nextBoolean())) {
                palautus.setOrder("Go to planet", this.getClosestPlanet(apu));
            }
        }
        if (palautus.getOrder() == "Stay put" && this.maailma.getPlanetsByOwner("None").size() != 0) {
            Planet closestPlanet = this.getClosestPlanet(this.maailma.getPlanetsByOwner("None"));
            if (closestPlanet != null) {
                palautus.setOrder("Colonize", closestPlanet);
            }
            if (closestPlanet == null) {
                apu.clear();
                for (Planet p : this.maailma.getPlanets()) {
                    if ((p.fleetInOrbit != null || p.owner == this.owner) && (p.fleetInOrbit != this || p.owner == this.owner)) continue;
                    apu.add(p);
                }
                if (apu.size() > 0) {
                    palautus.setOrder("Colonize", this.getClosestPlanet(apu));
                }
            }
        }
        if (palautus.getOrder() == "Stay put") {
            ArrayList<Fleet> apuf = new ArrayList<Fleet>();
            for (Fleet f : this.maailma.getFleets()) {
                if (this.owner.nimi == "Player1" && !f.isVisible()) continue;
                if ((double)f.strength * 0.9 < (double)strengthSub && f.owner != this.owner) {
                    apuf.add(f);
                }
                if (apuf.size() <= 0) continue;
                palautus.setOrder("Attack fleet", this.getClosestFleet(apuf));
            }
            if (palautus.getOrder() == "Stay put") {
                apu.clear();
                for (Planet p : this.maailma.getPlanets()) {
                    if (p.owner == this.owner || p.fleetInOrbit != null && !((double)p.fleetInOrbit.strength * 1.1 < (double)strengthSub)) continue;
                    apu.add(p);
                }
                if (apu.size() > 0) {
                    palautus.setOrder("Colonize", this.getClosestPlanet(apu));
                }
            }
        }
        if (palautus.getOrder() == "Stay put" && this.current == null) {
            palautus.setOrder("Return to base", this.getNewbase());
        }
        return palautus;
    }

    private void returnToBase(Planet target) {
        if (this.current != null) {
            this.leaveOrbit();
        }
        if (target.owner == this.owner) {
            if (this.areTheyClose(this.xx, this.yy, target.xx, target.yy, 1)) {
                this.arriveToOrbit(target);
                this.currentOrder.setOrder("Done");
                return;
            }
            this.fleetGetCloserTo(target.xx, target.yy);
        }
    }

    private double distance(float x1, float y1, float x2, float y2) {
        return Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
    }

    private void fleetGetCloserTo(float x, float y) {
        double length = Math.sqrt((x - this.xx) * (x - this.xx) + (y - this.yy) * (y - this.yy));
        double unitX = (double)(x - this.xx) / length;
        double unitY = (double)(y - this.yy) / length;
        this.xx = (float)((double)this.xx + unitX * (double)this.owner.fleetSpeed);
        this.yy = (float)((double)this.yy + unitY * (double)this.owner.fleetSpeed);
    }

    private void leaveOrbit() {
        int apu = (int)this.current.getPreferredNumberOfFleets();
        if (this.strength > apu) {
            this.maailma.makeNewFleet(this.current);
            this.strength -= apu;
        } else {
            this.current.currentFleetLeftOrbit();
        }
        this.current = null;
        this.maailma.fleetInTransit = true;
    }

    private void arriveToOrbit(Planet p) {
        if (p == this.maailma.getPlayerOrbitingPlanet() && this.owner.nimi != "Player1") {
            this.maailma.initiateAttackMode(this);
            return;
        }
        if ((double)(p.actualProduction / (float)p.productionPotential) < 0.2 && this.owner.nimi == p.owner.nimi) {
            this.addToPlanetsProduction(p);
        }
        if (p.getFleetInOrbit() != null) {
            if (p.getFleetInOrbit().owner == this.owner) {
                p.getFleetInOrbit().strength += this.strength;
                this.strength = 0;
                return;
            }
            this.maailma.battleItOut(this, p.getFleetInOrbit());
            if (this.strength == 0) {
                return;
            }
        }
        this.current = p;
        this.xx = p.xx;
        this.yy = p.yy;
        this.current.fleetInOrbit = this;
    }

    public void setTarget(Planet p) {
        this.targetPlanet = p;
    }

    public void setTargetFleet(Fleet f) {
        this.targetFleet = f;
    }

    public Fleet getTargetFleet() {
        return this.targetFleet;
    }

    public void setMode(String m) {
        this.mode = m;
    }

    public void addToStrength(int a) {
        this.strength += a;
    }

    public void addToPlanetsProduction(Planet target) {
        target.actualProduction += 0.05f * (float)this.strength;
        this.strength /= 5;
    }

    public void Colonize(Planet target) {
        if (this.current != null) {
            this.leaveOrbit();
        }
        if (this.areTheyClose(this.xx, this.yy, target.xx, target.yy, 1)) {
            if (target.owner != null && target.owner != this.owner && target.getFleetInOrbit() != null) {
                this.maailma.battleItOut(this, target.getFleetInOrbit());
                if (this.strength == 0) {
                    return;
                }
            }
            this.arriveToOrbit(target);
            this.addToPlanetsProduction(target);
            target.setPreferredNumberOfFleets(10.0);
            this.currentOrder.setOrder("Done");
            target.setOwner(this.owner);
            target.mode = 1;
            target.setDepot(true);
        } else {
            this.fleetGetCloserTo(target.xx, target.yy);
        }
    }

    public void lessenStrength() {
        --this.strength;
    }

    public String getCurrentName() {
        if (this.current != null) {
            return this.current.getName();
        }
        return "No Current";
    }

    public String getMode() {
        if (this.colonize) {
            return "Colonize";
        }
        if (this.intercept) {
            return "Intercept";
        }
        if (this.attack) {
            return "Attack";
        }
        if (this.returnBase) {
            return "Return to Base";
        }
        return "No Mode";
    }

    public String getTargetPlanet() {
        if (this.targetPlanet != null) {
            return this.targetPlanet.getName();
        }
        return "No Target Planet";
    }

    public Order getCurrentOrder() {
        return this.currentOrder;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }
}

