/*
 * Decompiled with CFR 0.152.
 */
package peli;

import java.awt.Point;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import java.util.Scanner;
import org.lwjgl.Sys;
import org.newdawn.slick.opengl.Texture;
import org.newdawn.slick.opengl.TextureLoader;
import org.newdawn.slick.util.Log;
import org.newdawn.slick.util.ResourceLoader;
import peli.Atom;
import peli.Brain;
import peli.Bullet;
import peli.Enemy;
import peli.Entity;
import peli.Level;
import peli.Missile;
import peli.Player;
import peli.Wave;

public class Model {
    private ArrayList<ArrayList<Atom>> players;
    private ArrayList<ArrayList<Atom>> enemy;
    private ArrayList<Enemy> enemyBluePrints = new ArrayList();
    private ArrayList<Enemy> enemiesList = new ArrayList();
    private ArrayList<Entity> additions;
    private ArrayList<Wave> waves;
    ArrayList<Entity> allEntities;
    private ArrayList<Atom> residue;
    private Player player1;
    private Player player2;
    private int numberOfEnemies;
    private int level;
    private String state;
    private Level taso;
    private long lastTime;
    private long delta;
    long time;
    private boolean entityEnd = false;
    private boolean waveEnd = false;
    private String mode;
    private Random rand;
    private String creature = new String();
    int rivi;
    private int xsize;
    private int ysize;
    private int zoomlevel;
    private boolean pause = false;
    public boolean levelNotClear;
    double laskuri = 0.0;
    long deltat = 0L;
    private boolean waveBegin;
    private int waveEnemy;
    private int waveMinLevel;
    private int waveInitialAmount;
    private float waveIncreaseAmount;
    private int waveSkipLevelsDivisable;
    private int waveMaxLevel;
    private int waveType;
    private boolean wavesBegin;
    private boolean wavesEnd;
    private boolean entitiesBegin;
    private boolean entitiesEnd;
    private boolean entityBegin;
    private ArrayList<Integer> waveEnemies;

    Model(int x, int y, int zoom) {
        this.rand = new Random();
        this.additions = new ArrayList();
        this.allEntities = new ArrayList();
        this.residue = new ArrayList();
        this.waveEnemies = new ArrayList();
        this.xsize = x / zoom;
        this.ysize = y / zoom;
        this.zoomlevel = zoom;
        this.acquireAssets();
        ArrayList<Integer> enemiesWithWaves = new ArrayList<Integer>();
        int apu = 0;
        while (apu < this.enemyBluePrints.size()) {
            enemiesWithWaves.add(this.enemyBluePrints.get(apu).getIntType());
            ++apu;
        }
        enemiesWithWaves.trimToSize();
        for (Wave w : this.waves) {
            int[] nArray = w.enemys;
            int n = w.enemys.length;
            int n2 = 0;
            while (n2 < n) {
                int t = nArray[n2];
                enemiesWithWaves.remove((Object)t);
                ++n2;
            }
        }
        if (enemiesWithWaves.size() > 0) {
            int[] k = new int[enemiesWithWaves.size()];
            int apu2 = 0;
            while (apu2 < enemiesWithWaves.size()) {
                k[apu2] = (Integer)enemiesWithWaves.get(apu2);
                ++apu2;
            }
            Wave defaultWave = new Wave(k, 1, 0, 6, 1.0f, 5, this);
            this.waves.add(defaultWave);
        }
        this.mode = new String();
        this.state = "Playing";
        this.lastTime = Sys.getTime();
    }

    public ArrayList<Enemy> getEnemies() {
        return this.enemiesList;
    }

    public ArrayList<Atom> getResidue() {
        return this.residue;
    }

    public int getLevel() {
        return this.level;
    }

    public Player getPlayer(int p) {
        if (p == 1) {
            return this.player1;
        }
        return this.player2;
    }

    public int getNumberOfEnemies() {
        return this.numberOfEnemies;
    }

    public void togglePause() {
        this.pause = !this.pause;
        for (Entity e : this.allEntities) {
            e.togglePause();
        }
    }

    public ArrayList<Entity> getAll() {
        return this.allEntities;
    }

    public String getMode() {
        return this.mode;
    }

    public void addToResidue(Atom a) {
        this.residue.add(a);
    }

    public void newGame(String mode, int str) {
        this.mode = mode;
        this.pause = false;
        this.allEntities.clear();
        this.enemiesList.clear();
        this.additions.clear();
        this.level = 1;
        this.taso = new Level(this.waves);
        if (mode == "Game" || mode == "twoPlayer") {
            this.player1 = this.createNewPlayer(1);
        }
        if (mode == "Special") {
            this.allEntities.addAll(this.taso.getSpecial(str));
            this.numberOfEnemies = 10;
        }
        if (mode == "ninjaMode") {
            this.player1 = this.createNewPlayer(2);
        }
        if (mode == "twoPlayer") {
            this.player2 = this.createNewPlayer(0);
        }
        if (mode == "Campaign") {
            this.allEntities.addAll(this.taso.getEnemiesAmount(str));
            this.numberOfEnemies = str;
        }
        if (mode == "Game" || mode == "twoPlayer" || mode == "ninjaMode") {
            this.numberOfEnemies = this.taso.getEnemies(this.level).size();
            this.allEntities.addAll(this.taso.getEnemies(this.level));
        }
        this.state = "Playing";
        this.lastTime = Sys.getTime();
    }

    public Enemy addMassToExplosion(Entity e) {
        Random r = new Random();
        Atom[][] al = new Atom[1][e.getRep().length * e.massMultiplier];
        int laskuri = 0;
        int j = 0;
        while (j < e.massMultiplier) {
            Atom[] atomArray = e.rep[e.current];
            int n = atomArray.length;
            int n2 = 0;
            while (n2 < n) {
                Atom a = atomArray[n2];
                al[0][laskuri] = new Atom(a.x_coord + r.nextFloat(), a.y_coord + r.nextFloat(), a.material, a.xVector, a.yVector, a.temperature);
                ++laskuri;
                ++n2;
            }
            ++j;
        }
        Enemy addition = new Enemy(e.middle.x, e.middle.y, 0, null, this, 33, al);
        addition.setState("Destroyed");
        addition.Explode();
        addition.delta = e.delta;
        return addition;
    }

    public void decreaseEnemyCount() {
        --this.numberOfEnemies;
    }

    public void setPlayer(int p, Player pl) {
        if (p == 1) {
            this.player1 = pl;
        } else {
            this.player2 = pl;
        }
    }

    public void Live() {
        if (this.pause) {
            return;
        }
        this.delta = Sys.getTime() - this.lastTime;
        if (this.state == "Playing") {
            this.checkAllCollisions();
            int p = 0;
            while (p < this.residue.size()) {
                if (this.residue.get((int)p).temperature == 0) {
                    this.residue.remove(p);
                    --p;
                } else {
                    this.residue.get((int)p).temperature -= 5;
                }
                ++p;
            }
            for (Entity b : this.allEntities) {
                b.Live();
                if (b.state != "About to be destroyed") continue;
                this.additions.add(this.addMassToExplosion(b));
                ++this.numberOfEnemies;
                b.setState("Destroyed");
            }
            if (this.additions.size() > 0) {
                this.allEntities.addAll(this.additions);
                this.additions.clear();
            }
            this.lastTime = Sys.getTime();
        }
        if (!(this.mode != "Campaign" || this.numberOfEnemies != 0 && this.player1.alive)) {
            this.state = "Campaign Over";
        }
        if (!(this.mode != "Special" || this.state != "Playing" || this.numberOfEnemies != 0 && this.player1.alive)) {
            this.player1.checkForMedals(1);
            this.state = "Special end";
            this.lastTime = Sys.getTime();
        }
        if (this.numberOfEnemies == 0 && this.state == "Playing") {
            this.state = "Between levels";
            this.player1.checkForMedals(0);
            if (this.mode == "twoPlayer") {
                this.player2.checkForMedals(0);
            }
        }
        if (this.state == "Between levels") {
            this.player1.Live();
            if (this.mode == "twoPlayer") {
                this.player2.Live();
            }
        }
        if (this.state == "Special end") {
            this.player1.Live();
            if (this.delta > 7000L) {
                this.state = "Special Over";
            }
        }
        if (this.state == "Between levels" && this.delta > 5000L) {
            this.levelNotClear = false;
            this.state = "Playing";
            ++this.level;
            this.numberOfEnemies = this.taso.getEnemies(this.level).size();
            this.allEntities.addAll(this.taso.getEnemies(this.level));
            this.lastTime = Sys.getTime();
        }
        if (this.state == "Game Over") {
            if (this.player1.alive) {
                this.state = "Playing";
            }
            if (this.mode == "twoPlayer" && this.player2.alive) {
                this.state = "Playing";
            }
        }
    }

    public void startPlay() {
        this.level = 1;
        this.state = "Playing";
    }

    public String getState() {
        return this.state;
    }

    public void setState(String s) {
        this.state = s;
    }

    public void addEnemyBullet(int x, int y, int t) {
        Bullet eb;
        Point m = this.mode == "ninjaMode" ? new Point(this.rand.nextInt(20) - 10 + x, this.rand.nextInt(20) - 10 + y) : this.choosePlayer().middle;
        if (t == 1) {
            eb = new Bullet(x, y, "Enemy Bullet2", m, this.xsize, this.ysize);
            this.additions.add(eb);
        }
        if (t == 2) {
            eb = new Bullet(x, y, "Enemy Bullet1", m, this.xsize, this.ysize);
            this.additions.add(eb);
        }
        if (t == 3) {
            int px = this.choosePlayer().middle.x;
            int py = this.choosePlayer().middle.y;
            int j = 0;
            while (j < 8 - t) {
                Bullet eb2 = new Bullet(x, y, "Enemy Bullet1", new Point(px * j, py * j), this.xsize, this.ysize);
                this.additions.add(eb2);
                ++j;
            }
        }
        if (t == 6) {
            Bullet eb3 = new Bullet(x, y, "Enemy Bullet3", m, this.xsize, this.ysize);
            this.additions.add(eb3);
        }
    }

    private Player choosePlayer() {
        if (this.player2 != null && this.delta % 2L == 0L && this.player2.alive) {
            return this.player2;
        }
        return this.player1;
    }

    public void addBullet(int b, Player p) {
        Bullet bullet;
        if (b == 1) {
            bullet = p.type == "Player1" ? new Bullet(p.middle.x - 3, p.middle.y, "Bullet1", new Point(p.middle.x, 0), this.xsize, this.ysize) : new Bullet(p.middle.x - 3, p.middle.y, "Bullet3", new Point(p.middle.x, 0), this.xsize, this.ysize);
            this.additions.add(bullet);
        }
        if (b == 2) {
            bullet = p.type == "Player1" ? new Bullet(p.middle.x - 1, p.middle.y, "Bullet2", new Point(p.middle.x, 0), this.xsize, this.ysize) : new Bullet(p.middle.x - 1, p.middle.y, "Bullet4", new Point(p.middle.x, 0), this.xsize, this.ysize);
            this.additions.add(bullet);
        }
    }

    public void checkAllCollisions() {
        int k = 0;
        while (k < this.allEntities.size()) {
            Entity e = this.allEntities.get(k);
            if (!e.isAlive() && e.type != "Player1" && e.type != "Player2") {
                if (e.type == "Enemy" || e.type == "Havittaja") {
                    --this.numberOfEnemies;
                    this.enemiesList.remove(e);
                }
                if (e.type == "Missile1" || e.type == "Missile2") {
                    this.removeTargetStatus(e);
                }
                this.allEntities.remove(e);
                --k;
            } else {
                int j = k + 1;
                while (j < this.allEntities.size()) {
                    Entity ee = this.allEntities.get(j);
                    if (this.allIsWell(e, ee)) {
                        Atom[] atomArray = ee.getRep();
                        int n = atomArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Atom a = atomArray[n2];
                            if (a.material == 0) break;
                            if (e.didItHit(a.getX() + (float)ee.middle.x, a.getY() + (float)ee.middle.y)) {
                                e.youWereHit(ee, true);
                                ee.youWereHit(e, false);
                                if (e.shields <= 0 && ee.deadlyToEnemies) {
                                    if (ee.isBullet) {
                                        this.updatePoints(((Bullet)ee).player, e.points);
                                    } else {
                                        this.updatePoints(((Player)ee).getPlayerInt(), e.points);
                                    }
                                }
                                if (ee.shields <= 0 && e.deadlyToEnemies) {
                                    if (e.isBullet) {
                                        this.updatePoints(((Bullet)e).player, ee.points);
                                    } else {
                                        this.updatePoints(((Player)e).getPlayerInt(), e.points);
                                    }
                                }
                                if (e.type == "Bullet1" || ee.type == "Bullet1") {
                                    this.player1.addShot2Amount();
                                    ++this.player1.howManyHits;
                                }
                                if (e.type != "Bullet3" && ee.type != "Bullet3") break;
                                this.player2.addShot2Amount();
                                ++this.player2.howManyHits;
                                break;
                            }
                            ++n2;
                        }
                    }
                    ++j;
                }
            }
            ++k;
        }
    }

    public boolean allIsWell(Entity e, Entity ee) {
        if (e.state == "Destroyed" || e.state == "Dormant" || ee.state == "Destroyed" || ee.state == "Dormant") {
            return false;
        }
        if (ee.middle.distance(e.middle) > 30.0) {
            return false;
        }
        if (ee.deadlyToEnemies && e.deadlyToEnemies) {
            return false;
        }
        if (ee.deadlyToPlayer && e.deadlyToPlayer) {
            return false;
        }
        if (ee.isBullet && ee.deadlyToPlayer && e.isBullet && e.deadlyToEnemies) {
            return false;
        }
        if (e.isBullet && e.deadlyToPlayer && ee.isBullet && ee.deadlyToEnemies) {
            return false;
        }
        return e.checkCollisions && ee.checkCollisions;
    }

    public int getXsize() {
        return this.xsize;
    }

    public int getYsize() {
        return this.ysize;
    }

    public int getZoomLevel() {
        return this.zoomlevel;
    }

    public void acquireAssets() {
        try {
            Scanner scanner = new Scanner(new FileReader("assets"));
            this.rivi = 0;
            this.waves = new ArrayList();
            this.players = new ArrayList();
            this.players.add(new ArrayList());
            this.players.add(new ArrayList());
            this.players.add(new ArrayList());
            this.players.add(new ArrayList());
            this.enemy = new ArrayList();
            this.enemy.add(new ArrayList());
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (!line.equals("Assets begin")) continue;
                line = scanner.nextLine();
                while (!line.equals("Assets end")) {
                    this.processAssets(line);
                    line = scanner.nextLine();
                    if (this.creature != "Player1" && this.entityEnd) {
                        Atom[][] a = new Atom[1][this.enemy.get(0).size()];
                        int p = 0;
                        while (p < this.enemy.get(0).size()) {
                            a[0][p] = this.enemy.get(0).get(p);
                            ++p;
                        }
                        Enemy e = new Enemy(0.0, 0.0, 0, this.getBrain(this.creature), this, Integer.parseInt(this.creature), a);
                        this.enemyBluePrints.add(e);
                        this.entityEnd = false;
                        this.enemy.clear();
                        this.enemy.add(new ArrayList());
                    }
                    if (!this.waveEnd) continue;
                    this.waveEnemies.trimToSize();
                    int[] e = new int[this.waveEnemies.size()];
                    int p = 0;
                    while (p < this.waveEnemies.size()) {
                        e[p] = this.waveEnemies.get(p);
                        ++p;
                    }
                    this.waves.add(new Wave(e, this.waveMinLevel, this.waveMaxLevel, this.waveInitialAmount, this.waveIncreaseAmount, this.waveSkipLevelsDivisable, this));
                    this.waveEnd = false;
                }
                this.rivi = 0;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private Brain getBrain(String creature2) {
        return new Brain();
    }

    public void processAssets(String s) {
        if (s.matches("")) {
            return;
        }
        if (s.matches("^## Enemy.*") || s.matches("^## Player1.*")) {
            this.entityBegin = true;
            if (s.substring(3).matches("Player1")) {
                this.creature = "Player1";
            } else {
                this.creature = s.substring(9);
                this.rivi = 0;
            }
            return;
        }
        if (s.matches("^## Wave.*")) {
            this.waveEnemies.clear();
            this.waveBegin = true;
            this.waveType = Integer.parseInt(s.substring(8));
            return;
        }
        if (s.matches("end")) {
            this.entityEnd = true;
            this.entityBegin = false;
            return;
        }
        if (s.matches("Wave end")) {
            this.waveEnd = true;
            this.waveBegin = false;
            return;
        }
        if (this.waveBegin) {
            if (s.matches("enemies.*")) {
                this.waveEnemies.add(Integer.parseInt(s.substring(10)));
            }
            if (s.matches("minLevel.*")) {
                this.waveMinLevel = Integer.parseInt(s.substring(11));
            }
            if (s.matches("maxLevel.*")) {
                this.waveMaxLevel = Integer.parseInt(s.substring(11));
            }
            if (s.matches("initialAmount.*")) {
                this.waveInitialAmount = Integer.parseInt(s.substring(16));
            }
            if (s.matches("increaseAmount.*")) {
                this.waveIncreaseAmount = Float.parseFloat(s.substring(17));
            }
            if (s.matches("skipLevelsDivisable.*")) {
                this.waveSkipLevelsDivisable = Integer.parseInt(s.substring(22));
            }
        }
        if (this.entityBegin) {
            if (s.matches(".*.png")) {
                this.enemy = this.acquirePNGAssets(s);
                this.entityBegin = false;
            } else {
                int frame = 0;
                int maxXsize = 0;
                int k = 0;
                while (k < s.length()) {
                    if (s.substring(k, k + 1).matches(",")) {
                        ++frame;
                        ++k;
                        if (maxXsize == 0) {
                            maxXsize = k;
                        }
                    }
                    int p = new Integer(s.substring(k, k + 1));
                    byte[] v = new byte[]{127, -1, -89};
                    if (p > 0) {
                        if (this.creature.matches("Player1")) {
                            this.players.get(frame).add(new Atom(k - maxXsize * frame, this.rivi, p, v));
                        } else {
                            this.enemy.get(frame).add(new Atom(k - maxXsize * frame, this.rivi, p));
                        }
                    }
                    ++k;
                }
                ++this.rivi;
            }
        }
    }

    private ArrayList<ArrayList<Atom>> acquirePNGAssets(String s) {
        ArrayList<ArrayList<Atom>> palautus = new ArrayList<ArrayList<Atom>>();
        ArrayList<Atom> atoms = new ArrayList<Atom>();
        try {
            Log.setVerbose(false);
            Texture texture = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream(s));
            byte[] b = texture.getTextureData();
            int x = 0;
            int y = 0;
            int p = 0;
            while (p < b.length) {
                if (y == texture.getImageHeight()) break;
                if (x == texture.getImageWidth()) {
                    p += (texture.getTextureWidth() - texture.getImageWidth()) * 4;
                    x = 0;
                    ++y;
                }
                ++x;
                if (b[p] != 0) {
                    byte[] f = new byte[]{b[p] < 0 ? (byte)(b[p] + 128) : (byte)(b[p] - 128), b[p + 1] < 0 ? (byte)(b[p + 1] + 128) : (byte)(b[p + 1] - 128), b[p + 2] < 0 ? (byte)(b[p + 2] + 128) : (byte)(b[p + 2] - 128)};
                    Atom a = new Atom(x, y, 1, f);
                    if (b[p] == -1) {
                        a = new Atom(x, y, 1, f);
                    }
                    if (b[p + 1] == -55) {
                        a = new Atom(x, y, 2, f);
                    }
                    if (b[p] == -1 && b[p + 1] == 127 && b[p + 2] == 39) {
                        a = new Atom(x, y, 2, f);
                    }
                    if (b[p] == 99) {
                        a = new Atom(x, y, 3, f);
                    }
                    if (b[p] == -19 && b[p + 1] == 28 && b[p + 2] == 36) {
                        a = new Atom(x, y, 5, f);
                    }
                    if (b[p] == -61 && b[p + 1] == -61 && b[p + 2] == -61) {
                        a = new Atom(x, y, 7, f);
                    }
                    atoms.add(a);
                }
                p += 4;
            }
            palautus.add(atoms);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return palautus;
    }

    public ArrayList<ArrayList<Atom>> copyArrayList(ArrayList<ArrayList<Atom>> al, int mode) {
        ArrayList<ArrayList<Atom>> palautus = new ArrayList<ArrayList<Atom>>();
        for (ArrayList<Atom> a : al) {
            ArrayList<Atom> apu = new ArrayList<Atom>();
            for (Atom am : a) {
                if (mode == 0) {
                    apu.add(new Atom((int)am.x_coord, (int)am.y_coord, 6, am.color));
                }
                if (mode == 2) {
                    apu.add(new Atom((int)am.x_coord, (int)am.y_coord, 1, am.color));
                }
                if (mode != 1) continue;
                apu.add(new Atom((int)am.x_coord, (int)am.y_coord, am.material, am.color));
            }
            palautus.add(apu);
        }
        return palautus;
    }

    public void updatePoints(int player, int points) {
        if (player == 1) {
            this.player1.AddScore(points);
        } else {
            this.player2.AddScore(points);
        }
    }

    public Entity pickTarget(Player p) {
        for (Enemy e : this.getEnemies()) {
            if (e.state == "Destroyed" || e.getTargeted() != 100 || e.state == "Dormant") continue;
            e.beingTargeted(0);
            return e;
        }
        return null;
    }

    public int createMissile(Player player, int number) {
        int k = 0;
        while (k < number) {
            Entity e = this.pickTarget(player);
            if (e == null) {
                return k * 1000;
            }
            this.additions.add(new Missile(player, e, this));
            ++k;
        }
        return number * 1000;
    }

    public void removeTargetStatus(Entity entity) {
        if (((Missile)entity).getTarget().type != "Player1" && ((Missile)entity).getTarget().type != "Player2") {
            ((Enemy)((Missile)entity).getTarget()).releaseTarget();
        }
    }

    public Atom[] getEnemyRepresentation(int type) {
        for (Enemy e : this.enemyBluePrints) {
            if (!e.typeMatches(type)) continue;
            return e.getRep();
        }
        return null;
    }

    public Enemy getCopyOfEnemy(int t, int x, int y, int timer, Brain b) {
        Enemy palautus = null;
        for (Enemy e : this.enemyBluePrints) {
            if (!e.typeMatches(t)) continue;
            int currentIndex = 0;
            int currentArray = 0;
            Atom[][] uusi = new Atom[e.rep.length][e.rep[0].length];
            Atom[][] atomArray = e.rep;
            int n = e.rep.length;
            int n2 = 0;
            while (n2 < n) {
                Atom[] aa;
                Atom[] atomArray2 = aa = atomArray[n2];
                int n3 = aa.length;
                int n4 = 0;
                while (n4 < n3) {
                    Atom a = atomArray2[n4];
                    uusi[currentIndex][currentArray] = new Atom(a.x_coord, a.y_coord, a.material, a.getColor());
                    ++currentArray;
                    ++n4;
                }
                currentArray = 0;
                ++currentIndex;
                ++n2;
            }
            palautus = new Enemy(x, y, timer, b, this, t, uusi);
            palautus.setMassDampening(e.getMassDampening());
            palautus.tuleeSivusta = e.tuleeSivusta;
            palautus.speed = e.speed;
            palautus.setPoints(e.getPoints());
            palautus.massMultiplier = e.massMultiplier;
            palautus.shields = e.shields;
            palautus.fixMiddle();
            palautus.setDestinationToMiddle();
            this.enemiesList.add(palautus);
        }
        return palautus;
    }

    public Player createNewPlayer(int i) {
        Player palautus = i == 1 ? new Player(this.xsize / 2 - 20, this.ysize - 30, this, this.copyArrayList(this.players, 1), false) : (i == 2 ? new Player(this.xsize / 2 - 20, this.ysize - 30, this, this.copyArrayList(this.players, 0), false) : new Player(this.xsize / 2 - 20, this.ysize - 30, this, this.copyArrayList(this.players, 2), true));
        this.allEntities.add(palautus);
        return palautus;
    }

    public int[] getTypesOfEnemies() {
        int[] palautus = new int[this.enemyBluePrints.size()];
        int p = 0;
        for (Enemy e : this.enemyBluePrints) {
            palautus[p] = e.getTypeInt();
            ++p;
        }
        return palautus;
    }

    public ArrayList<String> getLevelEndInText() {
        ArrayList<String> palautus = new ArrayList<String>();
        palautus.add("Level " + (this.level + 1));
        palautus.add("Get Ready!");
        palautus.addAll(this.getPlayer(1).getNewMedals());
        return palautus;
    }
}

