/*
 * Decompiled with CFR 0.152.
 */
package peli;

import java.util.ArrayList;
import java.util.Random;
import peli.CampaignPlayer;
import peli.Fleet;
import peli.Universe;

public class Planet {
    protected int productionPotential = 100;
    protected float actualProduction;
    protected CampaignPlayer owner;
    protected int mode;
    private double preferredNumberOfFleets;
    protected Fleet fleetInOrbit;
    protected boolean underAttack;
    protected Planet currentTarget;
    protected int xx;
    protected int yy;
    protected String nimi;
    protected Universe maailma;
    protected int fleets;
    protected Random r = new Random();
    protected boolean depot;
    protected boolean isVisible;
    private int radarCoverage;
    protected double preferredFleetFactorial;
    private int ticks;

    public int getRadarCoverage() {
        return this.radarCoverage;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }

    public boolean isDepot() {
        return this.depot;
    }

    public void setDepot(boolean depot) {
        this.depot = depot;
    }

    Planet(int x, int y, String name, Universe u, CampaignPlayer c) {
        this.owner = c;
        this.xx = x;
        this.yy = y;
        this.mode = 0;
        this.nimi = name;
        this.maailma = u;
        this.preferredNumberOfFleets = 10.0;
        this.radarCoverage = 200;
        if (c.nimi == "Player1") {
            this.depot = true;
        }
        this.ticks = 0;
    }

    public double getPreferredNumberOfFleets() {
        return this.preferredNumberOfFleets;
    }

    public void setPreferredNumberOfFleets(double preferredNumberOfFleets) {
        this.preferredNumberOfFleets = preferredNumberOfFleets;
    }

    public Fleet getFleetInOrbit() {
        return this.fleetInOrbit;
    }

    public void currentFleetLeftOrbit() {
        this.fleetInOrbit = null;
    }

    public void setFleetInOrbit(Fleet f) {
        this.fleetInOrbit = f;
        this.fleetInOrbit.xx = this.xx;
        this.fleetInOrbit.yy = this.yy;
        f.inOrbit = true;
    }

    public void setActualProduction(float p) {
        this.actualProduction = p;
    }

    public void setOwner(CampaignPlayer c) {
        this.owner = c;
        if (c.nimi != "None") {
            this.mode = 1;
            this.actualProduction = 1.0f;
        }
        if (c.nimi == "Player1") {
            this.isVisible = true;
        }
        this.maailma.checkPlanetVisibility();
        this.maailma.checkPlanetFleetAmount();
    }

    public String getName() {
        return this.nimi;
    }

    public boolean areTheyClose(float x1, float y1, float x2, float y2, int threshold) {
        return (double)threshold > Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
    }

    public void checkVisibility() {
        for (Planet p : this.maailma.getPlanetsByOwner("Player1")) {
            if (!this.areTheyClose(p.xx, p.yy, this.xx, this.yy, p.getRadarCoverage())) continue;
            this.isVisible = true;
            return;
        }
    }

    public void Live() {
        if (this.owner.nimi == "None") {
            return;
        }
        ++this.ticks;
        if (this.ticks > 5) {
            this.preferredNumberOfFleets = this.preferredFleetFactorial * (double)this.maailma.getStrengthForAllFleets(this.owner);
            this.ticks = 0;
        }
        if (this.fleetInOrbit != null && this.fleetInOrbit.strength == 0) {
            this.fleetInOrbit = null;
        }
        if (this.mode == 0) {
            return;
        }
        if (this.mode == 1) {
            this.actualProduction += this.actualProduction / (float)this.owner.getProductionEfficency() + (float)(this.productionPotential / 2000);
            if (this.actualProduction >= (float)this.productionPotential || this.r.nextInt((int)this.actualProduction / 10 + 1) > this.productionPotential) {
                this.mode = 2;
                if (this.owner.nimi == "Player1") {
                    this.depot = true;
                }
            }
        }
        if (this.mode == 2) {
            if (!this.maailma.isPlayerInOrbit(this) || this.owner.nimi == "Player1") {
                this.addToFleets();
            }
            if (this.actualProduction < (float)this.productionPotential && (double)this.r.nextInt((int)this.actualProduction) > 0.8 * (double)this.productionPotential) {
                this.mode = 1;
            }
        }
    }

    private ArrayList<Planet> scanForTargets() {
        return this.maailma.getPlanets();
    }

    private void addToFleets() {
        if (this.fleetInOrbit == null) {
            this.fleetInOrbit = new Fleet(this, this.owner, this.maailma);
            this.fleetInOrbit.number = this.maailma.getNextFleetNumber();
            this.maailma.fleets.add(this.fleetInOrbit);
            this.fleetInOrbit.setVisible(this.isVisible);
        }
        if ((float)this.r.nextInt(28000) < this.actualProduction) {
            this.fleetInOrbit.addToStrength(1);
        }
    }

    public CampaignPlayer getOwner() {
        return this.owner;
    }

    public int getXPlace() {
        return this.xx;
    }

    public int getYPlace() {
        return this.yy;
    }

    public String getActualProductionInText() {
        if (this.actualProduction / (float)this.productionPotential == 0.0f) {
            return "";
        }
        if ((double)(this.actualProduction / (float)this.productionPotential) < 0.2) {
            return "Very Low";
        }
        if ((double)(this.actualProduction / (float)this.productionPotential) < 0.4) {
            return "Low";
        }
        if ((double)(this.actualProduction / (float)this.productionPotential) < 0.6) {
            return "Medium";
        }
        if ((double)(this.actualProduction / (float)this.productionPotential) < 0.7) {
            return "Good";
        }
        if ((double)(this.actualProduction / (float)this.productionPotential) < 0.9) {
            return "Very Good";
        }
        return "Full";
    }

    public int getActualProductionInPercentage() {
        return (int)(this.actualProduction / (float)this.productionPotential * 100.0f);
    }

    public String getProductionInText() {
        if (this.mode == 0) {
            return "";
        }
        if (this.mode == 1) {
            return "Factories";
        }
        return "Fleets";
    }
}

