/*
 * Decompiled with CFR 0.152.
 */
package peli;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Random;
import org.lwjgl.Sys;
import peli.Atom;
import peli.Enemy;
import peli.Entity;
import peli.Model;

public class Player
extends Entity {
    private boolean left;
    private boolean right;
    private boolean up;
    private boolean down;
    private boolean shot;
    private boolean shot2;
    private float amountOfFuel = 350.0f;
    protected boolean fire;
    protected int batteries;
    private ArrayList<String> medals;
    private ArrayList<String> newMedals;
    private String medalString;
    private int numberOfWarheads;
    private int targettingSpeed;
    int howManyFired;
    int howManyHits;
    private int shot2amount;
    private int thrusterRecharge;
    private int weaponRecharge;
    private boolean weaponCharge;
    private boolean thrusterCharge;
    private int shieldRecharge;
    private boolean tacticalDisplay;
    private int location;
    private int score;
    private int ticks = 0;
    private boolean missile;
    public int extraMissile = 0;
    int acquiredTargets;

    public Player(int x, int y, Model w, ArrayList<ArrayList<Atom>> t, boolean twoPlayer) {
        super(t);
        this.current = 0;
        this.world = w;
        this.speed = 0.01f;
        this.xVector = 0.0f;
        this.yVector = 0.0f;
        this.targettingSpeed = 1;
        this.xsize = this.world.getXsize();
        this.ysize = this.world.getYsize();
        this.zoomlevel = this.world.getZoomLevel();
        this.xborder = this.xsize;
        this.yborder = this.ysize;
        this.shot2amount = 50;
        this.howManyHits = 0;
        this.howManyFired = 0;
        this.medals = new ArrayList();
        this.newMedals = new ArrayList();
        this.medalString = new String();
        this.tacticalDisplay = false;
        this.tuleeSivusta = false;
        this.deadlyToPlayer = false;
        this.deadlyToEnemies = true;
        this.willBeDrawn = true;
        this.checkCollisions = true;
        this.isBullet = false;
        this.missile = false;
        this.middle = new Point(x, y);
        this.xx = x;
        this.yy = y;
        this.numberOfWarheads = 5000;
        this.type = !twoPlayer ? "Player1" : "Player2";
        this.lastTime = Sys.getTime();
        this.fire = true;
        this.batteries = 0;
        this.shields = 15;
        this.thrusterCharge = false;
        this.weaponCharge = false;
        this.down = false;
        this.up = false;
        this.right = false;
        this.left = false;
        this.state = "Playing";
        this.thrusterRecharge = 1;
        this.weaponRecharge = 1;
        this.fixMiddle();
    }

    public float getAmountOfFuel() {
        return this.amountOfFuel;
    }

    public void setAmountOfFuel(float amountOfFuel) {
        this.amountOfFuel = amountOfFuel;
    }

    public void setRight() {
        this.right = true;
    }

    public boolean getTacticalDisplay() {
        return this.tacticalDisplay;
    }

    public void flipTacticalDisplay() {
        this.tacticalDisplay = !this.tacticalDisplay;
    }

    public void setTacticalDisplay(boolean td) {
        this.tacticalDisplay = td;
        if (!td) {
            for (Enemy e : this.world.getEnemies()) {
                e.releaseTarget();
            }
        }
    }

    private void disperseAtoms() {
        if (this.delta < 5000L) {
            Random r = new Random();
            Atom[] atomArray = this.rep[this.current];
            int n = atomArray.length;
            int n2 = 0;
            while (n2 < n) {
                Atom a = atomArray[n2];
                if (r.nextBoolean()) {
                    a.setX(a.getX() + (float)r.nextInt(2));
                } else {
                    a.setX(a.getX() - (float)r.nextInt(2));
                }
                if (r.nextBoolean()) {
                    a.setY(a.getY() + (float)r.nextInt(2));
                } else {
                    a.setY(a.getY() - (float)r.nextInt(2));
                }
                ++n2;
            }
        } else {
            this.alive = false;
            this.world.setState("Game Over");
        }
    }

    @Override
    public void Live() {
        if (!this.alive) {
            return;
        }
        this.delta = Sys.getTime() - this.lastTime;
        this.ticks = (int)((long)this.ticks + this.delta);
        if (this.ticks > 200) {
            this.ticks = 0;
            ++this.current;
            if (this.current == this.rep.length) {
                this.current = 0;
            }
        }
        if (this.state == "Destroyed") {
            this.disperseAtoms();
            return;
        }
        if (this.tacticalDisplay) {
            this.acquiredTargets = 0;
            for (Enemy e : this.world.getEnemies()) {
                if (this.acquiredTargets >= this.numberOfWarheads / 1000 + this.extraMissile || e.state != "Moving" || e.shields > 4000) continue;
                e.beingTargeted(this.targettingSpeed);
                ++this.acquiredTargets;
                if (e.getTargeted() < 100) break;
            }
        }
        if (this.state == "Hit") {
            this.state = "Playing";
        }
        if (this.missile) {
            this.numberOfWarheads -= this.world.createMissile(this, this.numberOfWarheads / 1000);
            this.missile = false;
        }
        if (this.left && this.xVector > -10.0f) {
            this.xVector -= this.speed * 2.0f;
        }
        if (this.right && this.xVector < 10.0f) {
            this.xVector += this.speed * 2.0f;
        }
        if (this.up && this.yVector > -10.0f) {
            this.yVector -= this.speed * 2.0f;
        }
        if (this.down && this.yVector < 10.0f) {
            this.yVector += this.speed * 2.0f;
        }
        if (!this.left && !this.right) {
            if (this.xVector > 0.0f) {
                this.xVector -= this.speed * (float)this.zoomlevel;
                if ((double)this.xVector < 0.02) {
                    this.xVector = 0.0f;
                }
            }
            if (this.xVector < 0.0f) {
                this.xVector += this.speed * (float)this.zoomlevel;
                if ((double)this.xVector > -0.02) {
                    this.xVector = 0.0f;
                }
            }
        }
        if (!this.up && !this.down) {
            if (this.yVector > 0.0f) {
                this.yVector -= this.speed;
                if ((double)this.yVector < 0.02) {
                    this.yVector = 0.0f;
                }
            }
            if (this.yVector < 0.0f) {
                this.yVector += this.speed;
                if ((double)this.yVector > -0.02) {
                    this.yVector = 0.0f;
                }
            }
        }
        this.down = false;
        this.up = false;
        this.right = false;
        this.left = false;
        this.Chargings();
        this.chargeBattery();
        super.moveIt();
        if (this.middle.getX() >= (double)this.xborder) {
            this.middle.x -= this.xborder;
            this.xx -= (double)this.xborder;
        }
        if (this.middle.getX() <= 0.0) {
            this.middle.x += this.xborder;
            this.xx += (double)this.xborder;
        }
        if (this.middle.getY() >= (double)this.yborder) {
            this.middle.y -= this.yborder;
            this.yy -= (double)this.yborder;
        }
        if (this.middle.getY() <= 0.0) {
            this.middle.y += this.yborder;
            this.yy += (double)this.yborder;
        }
        this.lastTime = Sys.getTime();
    }

    public int getShieldRecharge() {
        return this.shieldRecharge;
    }

    @Override
    public double getSpeed() {
        return this.speed;
    }

    public void setShoot() {
        this.shot = true;
    }

    public int getWeaponRecharge() {
        return this.weaponRecharge;
    }

    public int thrusterRecharge() {
        return this.thrusterRecharge;
    }

    public void addShot2Amount() {
        ++this.shot2amount;
    }

    public void chargeBattery() {
        ++this.numberOfWarheads;
        if (this.batteries <= 30) {
            this.batteries += this.weaponRecharge;
        }
        if (this.shot && this.batteries > 30) {
            this.batteries = 0;
            this.world.addBullet(1, this);
            ++this.howManyFired;
        }
        if (this.shot2 && this.shot2amount > 0 && this.batteries > 30) {
            --this.shot2amount;
            this.batteries = 0;
            this.world.addBullet(2, this);
        }
        if (this.shot) {
            this.shot = false;
        }
        if (this.shot2) {
            this.shot2 = false;
        }
        this.shields += this.shieldRecharge;
        if (this.shields > 6000) {
            this.shields = 6000;
        }
        if (this.shields <= 0) {
            this.thrusterRecharge = 1;
        }
    }

    public int getBatteries() {
        return this.batteries;
    }

    @Override
    public int getShields() {
        return this.shields;
    }

    public void emptyBatteries() {
        this.batteries = 0;
    }

    public void setUp() {
        this.up = true;
    }

    public void setShoot2() {
        this.shot2 = true;
    }

    public void setDown() {
        this.down = true;
    }

    public void setLeft() {
        this.left = true;
    }

    public int getShot2Amount() {
        return this.shot2amount;
    }

    public void Chargings() {
        if (this.weaponCharge) {
            ++this.weaponRecharge;
        }
        if (this.weaponRecharge > 3) {
            this.weaponRecharge = 1;
        }
        if (this.thrusterCharge) {
            ++this.thrusterRecharge;
        }
        if (this.thrusterRecharge > 3) {
            this.thrusterRecharge = 1;
        }
        this.shieldRecharge = 4 - (this.thrusterRecharge + this.weaponRecharge);
        this.thrusterCharge = false;
        this.weaponCharge = false;
        if (this.thrusterRecharge == 1) {
            this.speed = 0.006f;
        }
        if (this.thrusterRecharge == 2) {
            this.speed = 0.014f;
        }
        if (this.thrusterRecharge == 3) {
            this.speed = 0.03f;
        }
    }

    public void adjustWeaponCharge() {
        this.weaponCharge = true;
    }

    public void adjustThrusterCharge() {
        this.thrusterCharge = true;
    }

    public int getThrusterRecharge() {
        return this.thrusterRecharge;
    }

    public int getScore() {
        return this.score;
    }

    public void AddScore(int points) {
        this.score += points;
    }

    public void checkForMedals(int t) {
        this.newMedals.clear();
        if (t == 0) {
            if (this.howManyFired > 0) {
                if ((float)this.howManyHits / (float)this.howManyFired >= 0.9f && (float)this.howManyHits / (float)this.howManyFired <= 1.0f) {
                    this.newMedals.add("Awesome Accuracy!");
                    this.AddMedal("Awesome Accuracy!");
                }
                if ((float)this.howManyHits / (float)this.howManyFired > 1.0f) {
                    this.newMedals.add("Impossible Accuracy!");
                    this.AddMedal("Impossible Accuracy!");
                }
            }
            if (this.world.getLevel() % 5 == 0 && !this.world.levelNotClear) {
                this.newMedals.add("Bonus Clearance");
                this.AddMedal("Bonus Clearance");
            }
            this.medalString = new String();
            for (String s : this.medals) {
                if (s == "Awesome Accuracy!") {
                    this.medalString = String.valueOf(this.medalString) + "!";
                }
                if (s == "Bonus Clearance") {
                    this.medalString = String.valueOf(this.medalString) + "#";
                }
                if (s != "Impossible Accuracy!") continue;
                this.medalString = String.valueOf(this.medalString) + "$";
            }
            this.howManyHits = 0;
            this.howManyFired = 0;
        }
        if (t == 1) {
            if (this.location == 1) {
                this.newMedals.add("Improved targetting computer");
                this.AddMedal("Improved targetting computer");
                this.targettingSpeed = 2;
            }
            if (this.location == 2) {
                this.newMedals.add("More efficient production");
                this.AddMedal("More efficient production");
            }
        }
    }

    private void AddMedal(String string) {
        if (!this.medals.isEmpty()) {
            int k = 0;
            while (k < this.medals.size()) {
                if (this.medals.get(k) == string) {
                    this.medals.add(k, string);
                    return;
                }
                ++k;
            }
        }
        this.medals.add(string);
    }

    public ArrayList<String> getMedals() {
        return this.medals;
    }

    public String getMedalString() {
        return this.medalString;
    }

    public ArrayList<String> getMedalsDigest() {
        ArrayList<String> palautus = new ArrayList<String>();
        String pal = new String();
        if (this.medals.size() > 0) {
            String medal = this.medals.get(0);
            int k = 0;
            for (String s : this.medals) {
                if (s == medal) {
                    ++k;
                }
                if (s == medal) continue;
                pal = String.valueOf(medal) + " * " + k;
                palautus.add(pal);
                medal = s;
                k = 1;
            }
            pal = k > 1 ? String.valueOf(medal) + " * " + k : medal;
            palautus.add(pal);
        }
        return palautus;
    }

    public int getNumberOfWarheads() {
        return this.numberOfWarheads;
    }

    public ArrayList<String> getNewMedals() {
        return this.newMedals;
    }

    public void setShootMissile() {
        this.missile = true;
    }

    public String getComponentMake(int i) {
        if (i == 1) {
            return "Renham Industries Thrusters markII";
        }
        if (i == 2) {
            return "Weyland Ind. Twin Cannons";
        }
        if (i == 3) {
            return "Acme All Power Generator";
        }
        if (i == 4) {
            return "Punk Buster Howitzer";
        }
        return "No component";
    }

    public int getPlayerInt() {
        if (this.type == "Player1") {
            return 1;
        }
        return 2;
    }

    public int getTargettingSpeed() {
        return this.targettingSpeed;
    }

    public void setTargettingSpeed(int targettingSpeed) {
        this.targettingSpeed = targettingSpeed;
    }

    public int getLocation() {
        return this.location;
    }

    public void setLocation(int location) {
        this.location = location;
    }

    public String getShieldsInText() {
        String palautus = "Shld: " + this.shields / 60;
        return palautus;
    }

    public String getShot2AmountInText() {
        if (this.shot2amount > 1000) {
            return "Powershots: >1k";
        }
        return "Powershots :" + this.shot2amount;
    }

    public String getWeaponRechargeInText() {
        if (this.weaponRecharge == 1) {
            return "Wpn: Low";
        }
        if (this.weaponRecharge == 2) {
            return "Wpn: Med";
        }
        if (this.weaponRecharge == 3) {
            return "Wpn: Hi";
        }
        return null;
    }

    public String getThrusterRechargeInText() {
        if (this.thrusterRecharge == 1) {
            return "Spd: Low";
        }
        if (this.thrusterRecharge == 2) {
            return "Spd: Med";
        }
        if (this.thrusterRecharge == 3) {
            return "Spd: Hi";
        }
        return null;
    }
}

