/*
 * Decompiled with CFR 0.152.
 */
package peli;

import java.util.ArrayList;
import java.util.Random;
import java.util.TreeSet;
import peli.CampaignPlayer;
import peli.Fleet;
import peli.Model;
import peli.Planet;
import peli.Player;
import peli.StellarLocation;

public class Universe {
    protected ArrayList<Planet> planets;
    protected ArrayList<StellarLocation> locations;
    protected ArrayList<Fleet> fleets;
    protected ArrayList<CampaignPlayer> campaignPlayers;
    protected int xSize;
    protected int ySize;
    protected String mode;
    protected Model kentta;
    protected Fleet targetFleet = null;
    protected Planet targetPlanet = null;
    protected float playerX;
    protected float playerY;
    protected float playerXvector = 0.0f;
    protected float playerYvector = 0.0f;
    protected Planet homeBase;
    protected boolean pause = false;
    boolean fleetInTransit = false;
    private Player p;
    private boolean playerInOrbit = true;
    private int fleetNumber = 0;
    private boolean engage;
    CampaignPlayer player1;
    CampaignPlayer none;
    Random r;
    private double radius;
    private StellarLocation targetLocation = null;

    public double getRadius() {
        return this.radius;
    }

    public StellarLocation getTargetLocation() {
        return this.targetLocation;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public String getMode() {
        return this.mode;
    }

    public boolean isPlayerInOrbit(Planet p) {
        return this.areTheyClose(this.playerX, this.playerY, p.xx, p.yy, 1.0f);
    }

    public void setPlayer(Player pl) {
        this.p = pl;
    }

    public Player getPlayer() {
        return this.p;
    }

    Universe(Model w) {
        this.kentta = w;
        this.mode = "Campaign";
        this.planets = new ArrayList();
        this.fleets = new ArrayList();
        this.locations = new ArrayList();
        this.campaignPlayers = new ArrayList();
        this.r = new Random();
        this.player1 = new CampaignPlayer("Player1", 20, 10, 0.4f, 5000);
        this.none = new CampaignPlayer("None", 0, 0, 0.0f, 0);
        this.campaignPlayers.add(this.none);
        this.campaignPlayers.add(this.player1);
    }

    public void createUniverse(int[] planetList) {
        this.locations.add(new StellarLocation(100, 100, "Testi", 1));
        this.locations.add(new StellarLocation(200, 100, "Testi2", 2));
        int j = 0;
        while (j < planetList.length - 3) {
            this.campaignPlayers.add(new CampaignPlayer("Enemy" + j, 10, 10, 0.3f, 5000));
            ++j;
        }
        int allPlanets = 0;
        int[] nArray = planetList;
        int n = planetList.length;
        int n2 = 0;
        while (n2 < n) {
            int a = nArray[n2];
            allPlanets += a;
            ++n2;
        }
        int x = (int)Math.sqrt((allPlanets + 1) * 2);
        int y = x + 1;
        int xkoko = this.kentta.getXsize() * this.kentta.getZoomLevel();
        int ykoko = this.kentta.getYsize() * this.kentta.getZoomLevel();
        int j2 = 0;
        while (j2 < x) {
            int k = 0;
            while (k < y) {
                Planet newPlanet = new Planet(xkoko / (x + 1) * j2 + this.r.nextInt(20) + 30, xkoko / (y + 1) * k - this.r.nextInt(20) + 30, "Planet #" + j2 + k, this, this.none);
                newPlanet.setOwner(this.none);
                this.planets.add(newPlanet);
                ++k;
            }
            ++j2;
        }
        while (this.planets.size() > allPlanets) {
            this.planets.remove(this.r.nextInt(this.planets.size()));
        }
        int planet = 0;
        int owner = -1;
        int[] nArray2 = planetList;
        int n3 = planetList.length;
        int n4 = 0;
        while (n4 < n3) {
            int p = nArray2[n4];
            if (++owner != 0) {
                while (p > 0) {
                    planet = this.r.nextInt(this.planets.size());
                    if (this.planets.get((int)planet).owner != this.none) continue;
                    this.planets.get(planet).setOwner(this.campaignPlayers.get(owner));
                    this.planets.get((int)planet).actualProduction = 100.0f;
                    --p;
                }
            }
            ++n4;
        }
        this.playerX = this.getPlanetsByOwner((String)this.player1.nimi).get((int)0).xx;
        this.playerY = this.getPlanetsByOwner((String)this.player1.nimi).get((int)0).yy;
        this.homeBase = this.targetPlanet = this.getPlanetsByOwner(this.player1.nimi).get(0);
        this.checkPlanetVisibility();
    }

    private CampaignPlayer getOwnerByName(String string) {
        for (CampaignPlayer c : this.campaignPlayers) {
            if (c.nimi != string) continue;
            return c;
        }
        return null;
    }

    public int getNextFleetNumber() {
        return ++this.fleetNumber;
    }

    public int getPlanets(String which) {
        int palautus = 0;
        for (Planet p : this.planets) {
            if (!p.owner.nimi.matches(which)) continue;
            ++palautus;
        }
        return palautus;
    }

    public int getStrengthForAllFleets(CampaignPlayer c) {
        int palautus = 0;
        for (Fleet f : this.getFleets()) {
            if (f.owner != c) continue;
            palautus += f.getStrength();
        }
        return palautus;
    }

    public void checkPlanetFleetAmount() {
        for (CampaignPlayer c : this.campaignPlayers) {
            if (c == this.none) continue;
            this.checkPlanetFleetAmount(c);
        }
    }

    public void checkPlanetFleetAmount(CampaignPlayer c) {
        double preferredNumberOfFleets = 10.0;
        TreeSet<Double> values = new TreeSet<Double>();
        for (Planet p : this.getPlanetsByOwner(c.nimi)) {
            int apu = this.getStrengthForAllFleets(p.owner) / this.getPlanets(p.owner.nimi);
            preferredNumberOfFleets = 10.0;
            double apu2 = 1.0;
            for (Planet pl : this.getPlanets()) {
                if (pl.owner.nimi == "None" || pl.owner == p.owner) continue;
                apu2 *= 1.0 + 1.0 / Math.sqrt((p.xx - pl.xx) * (p.xx - pl.xx) + (p.yy - pl.yy) * (p.yy - pl.yy));
            }
            preferredNumberOfFleets = (apu2 - 1.0) * (double)apu * 10.0 + 10.0;
            values.add(new Double(preferredNumberOfFleets));
            p.setPreferredNumberOfFleets(preferredNumberOfFleets);
        }
        int laskuri = 0;
        int tt = 1;
        int kerroinlaskuri = 0;
        for (Double d : values) {
            ++laskuri;
            for (Planet p : this.getPlanetsByOwner(c.nimi)) {
                if (p.getPreferredNumberOfFleets() != d.doubleValue()) continue;
                p.preferredFleetFactorial = tt;
                kerroinlaskuri += tt;
            }
            if (!((float)laskuri >= (float)this.getPlanets(c.nimi) / 3.0f)) continue;
            laskuri = 0;
            ++tt;
        }
        for (Planet p : this.getPlanetsByOwner(c.nimi)) {
            p.preferredFleetFactorial /= (double)kerroinlaskuri;
        }
    }

    public void checkPlanetVisibility() {
        for (Planet p : this.getPlanets()) {
            if (p.owner.nimi == "Player1" || p.owner.nimi == "None") continue;
            p.setVisible(false);
            if (p.fleetInOrbit != null) {
                p.fleetInOrbit.setVisible(false);
            }
            for (Planet pl : this.getPlanetsByOwner("Player1")) {
                if (pl.owner == p.owner || p.owner.nimi == "None" || !this.areTheyClose(p.xx, p.yy, pl.xx, pl.yy, pl.getRadarCoverage())) continue;
                p.setVisible(true);
                if (p.fleetInOrbit == null) continue;
                p.fleetInOrbit.setVisible(true);
            }
        }
    }

    public void Live() {
        if (this.pause || this.mode == "Campaign Won!" || this.mode == "Campaign Lost!") {
            return;
        }
        this.fleetInTransit = false;
        for (Fleet f : this.fleets) {
            if (f.inOrbit) continue;
            this.fleetInTransit = true;
            break;
        }
        int j = 0;
        while (j < this.fleets.size()) {
            Fleet f = this.fleets.get(j);
            if (f.strength == 0 && f != null) {
                this.fleets.remove(j);
                --j;
            }
            f.liveIt();
            ++j;
        }
        for (Planet p : this.planets) {
            p.Live();
        }
        this.playerLive();
        if (this.getPlanets("Player1") == 0) {
            this.mode = "Campaign Lost!";
        }
        if (this.getPlanets("Player1") + this.getPlanets("None") == this.planets.size()) {
            this.mode = "Campaign Won!";
        }
    }

    public boolean areTheyClose(float x1, float y1, float x2, float y2, float threshold) {
        float xerotus = x1 - x2;
        float yerotus = y1 - y2;
        if (xerotus > threshold || yerotus > threshold) {
            return false;
        }
        return (double)threshold > Math.sqrt(xerotus * xerotus + yerotus * yerotus);
    }

    public void togglePause() {
        this.pause = !this.pause;
    }

    public void initiateSpecialMode() {
        if (!this.p.alive) {
            return;
        }
        this.kentta.newGame("Special", 1);
        this.mode = "Special";
    }

    public void initiateAttackMode(Fleet targ) {
        if (!this.p.alive) {
            return;
        }
        this.targetFleet = targ;
        this.mode = "Attack";
        if (targ.current != null) {
            this.homeBase = targ.current;
            this.playerInOrbit = true;
        }
        this.kentta.newGame("Campaign", targ.strength);
    }

    private void playerLive() {
        if (!this.p.alive) {
            return;
        }
        for (Fleet f : this.getOthersFleets(this.player1)) {
            if (!this.areTheyClose(f.xx, f.yy, this.playerX, this.playerY, 1.0f)) continue;
            this.initiateAttackMode(f);
        }
        if (this.targetFleet != null && this.engage) {
            if (this.areTheyClose(this.targetFleet.xx, this.targetFleet.yy, this.playerX, this.playerY, 1.0f)) {
                this.initiateAttackMode(this.targetFleet);
            } else {
                this.playerGetCloserTo(this.targetFleet.xx, this.targetFleet.yy);
            }
        }
        if (this.targetLocation != null && this.engage) {
            if (this.areTheyClose(this.targetLocation.xx, this.targetLocation.yy, this.playerX, this.playerY, 1.0f)) {
                this.arriveAtTarget(this.targetLocation);
            } else {
                this.playerGetCloserTo(this.targetLocation.xx, this.targetLocation.yy);
            }
        }
        if (this.targetPlanet != null && this.engage) {
            if (this.areTheyClose(this.targetPlanet.xx, this.targetPlanet.yy, this.playerX, this.playerY, 1.0f) && !this.playerInOrbit) {
                this.playerInOrbit = true;
                this.homeBase = this.targetPlanet;
                this.playerX = this.homeBase.xx;
                this.playerY = this.homeBase.yy;
                this.engage = false;
                if (this.targetPlanet.getFleetInOrbit() != null && this.targetPlanet.getFleetInOrbit().owner.nimi != "Player1") {
                    this.initiateAttackMode(this.targetPlanet.getFleetInOrbit());
                }
                this.targetPlanet = null;
            } else {
                this.playerGetCloserTo(this.targetPlanet.xx, this.targetPlanet.yy);
            }
        }
        if (this.playerInOrbit) {
            if (this.homeBase.isDepot()) {
                this.p.setAmountOfFuel(350.0f);
            }
            this.radius += 0.025;
            if (this.radius >= 6.28) {
                this.radius = 0.0;
            }
        }
    }

    private void arriveAtTarget(StellarLocation targetLocation2) {
        this.p.setLocation(targetLocation2.type);
        this.targetPlanet = this.homeBase;
        this.initiateSpecialMode();
        targetLocation2.setVisited(true);
    }

    public boolean isPlayerInOrbit() {
        return this.playerInOrbit;
    }

    private void playerGetCloserTo(float x, float y) {
        this.playerInOrbit = false;
        if (this.p.getAmountOfFuel() < 1.0f) {
            return;
        }
        double length = Math.sqrt((x - this.playerX) * (x - this.playerX) + (y - this.playerY) * (y - this.playerY));
        double unitX = (double)(x - this.playerX) / length;
        double unitY = (double)(y - this.playerY) / length;
        this.playerX = (float)((double)this.playerX + unitX * 1.0);
        this.playerY = (float)((double)this.playerY + unitY * 1.0);
        this.p.setAmountOfFuel(this.p.getAmountOfFuel() - (float)(unitX * unitX + unitY * unitY));
    }

    public ArrayList<Planet> getPlanets() {
        return this.planets;
    }

    public ArrayList<StellarLocation> getLocations() {
        return this.locations;
    }

    public Planet getPlayerOrbitingPlanet() {
        if (this.targetPlanet == this.homeBase && this.playerInOrbit) {
            return this.homeBase;
        }
        return null;
    }

    public void afterMath(boolean playerAlive, int remainingForce) {
        if (playerAlive) {
            this.mode = "Campaign";
            if (this.targetFleet != null) {
                this.targetFleet.strength = remainingForce;
                this.targetFleet = null;
            }
            if (this.targetLocation != null && remainingForce == 0) {
                this.targetLocation.setVisited(true);
                this.targetLocation = null;
                for (String s : this.p.getMedals()) {
                    if (s != "More efficient production") continue;
                    this.player1.setProductionEfficency(this.player1.getProductionEfficency() - 1000);
                }
            }
        } else {
            this.mode = "Game Over";
            this.targetPlanet = null;
            this.homeBase = null;
            this.targetFleet.strength = remainingForce;
            this.targetFleet = null;
        }
    }

    public Fleet battleItOut(Fleet eka, Fleet toka) {
        int es = eka.getStrength();
        int ts = toka.getStrength();
        while (es > 0 && ts > 0) {
            if (this.r.nextInt(es + ts) < ts) {
                --es;
                continue;
            }
            --ts;
        }
        eka.strength = es;
        toka.strength = ts;
        if (es == 0 && ts > 0) {
            return toka;
        }
        if (ts == 0 && es > 0) {
            return eka;
        }
        return eka;
    }

    public void setCurrentTarget(Fleet target) {
        this.targetFleet = target;
    }

    public void clickedCoordinates(int x, int y, boolean engage) {
        for (Planet p : this.planets) {
            if (p.xx - 10 >= x || p.xx + 10 <= x || p.yy - 10 >= y || p.yy + 10 <= y || !this.areTheyClose(p.xx, p.yy, this.playerX, this.playerY, this.p.getAmountOfFuel())) continue;
            this.targetPlanet = p;
            this.targetFleet = null;
            this.targetLocation = null;
            this.playerInOrbit = !engage;
            this.engage = engage;
            return;
        }
        for (Fleet f : this.fleets) {
            if (!(f.xx - 10.0f < (float)x) || !(f.xx + 10.0f > (float)x) || !(f.yy - 10.0f < (float)y) || !(f.yy + 10.0f > (float)y) || !this.areTheyClose(f.xx, f.yy, this.playerX, this.playerY, this.p.getAmountOfFuel()) || f.owner.nimi == "Player1") continue;
            this.targetPlanet = null;
            this.targetLocation = null;
            this.setCurrentTarget(f);
            this.playerInOrbit = !engage;
            this.engage = engage;
            return;
        }
        for (StellarLocation l : this.locations) {
            if (l.xx - 10 >= x || l.xx + 10 <= x || l.yy - 10 >= y || l.yy + 10 <= y || l.isVisited() || !this.areTheyClose(l.xx, l.yy, this.playerX, this.playerY, this.p.getAmountOfFuel())) continue;
            this.targetPlanet = null;
            this.targetFleet = null;
            this.targetLocation = l;
            this.playerInOrbit = !engage;
            this.engage = engage;
            return;
        }
    }

    public ArrayList<Fleet> getFleets() {
        return this.fleets;
    }

    public ArrayList<Planet> getPlanetsByOwner(String owner) {
        ArrayList<Planet> palautus = new ArrayList<Planet>();
        for (Planet p : this.planets) {
            if (!p.owner.nimi.matches(owner)) continue;
            palautus.add(p);
        }
        return palautus;
    }

    public Planet getPlanet(float xx, float yy) {
        for (Planet p : this.planets) {
            if (!this.areTheyClose(p.xx, p.yy, xx, yy, 1.0f)) continue;
            return p;
        }
        return null;
    }

    public void makeNewFleet(Planet current) {
        Fleet f = new Fleet(current, current.owner, this);
        f.strength = (int)current.getPreferredNumberOfFleets();
        f.number = this.getNextFleetNumber();
        f.setVisible(current.isVisible);
        this.fleets.add(f);
    }

    public ArrayList<Fleet> getOthersFleets(CampaignPlayer c) {
        ArrayList<Fleet> palautus = new ArrayList<Fleet>();
        for (Fleet f : this.fleets) {
            if (f.owner == c) continue;
            palautus.add(f);
        }
        return palautus;
    }

    public int getFullPlanets(String string) {
        int palautus = 0;
        for (Planet p : this.getPlanetsByOwner(string)) {
            if (p.getActualProductionInPercentage() != 100) continue;
            ++palautus;
        }
        return palautus;
    }
}

