/*
 * Decompiled with CFR 0.152.
 */
package peli;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Random;
import peli.Brain;
import peli.Enemy;
import peli.Entity;
import peli.Idea;
import peli.Model;

public class Wave {
    protected ArrayList<Entity> enemies;
    protected ArrayList<Enemy> enemyReps;
    protected ArrayList<String> enemyNames;
    protected int level;
    protected Model world;
    protected int type;
    int xborder;
    int yborder;
    protected Random r;
    protected int timeBetween;
    protected int[] enemys;
    protected int minLevel;
    protected int maxLevel;
    protected int initialAmount;
    protected float increaseAmount;
    protected int skipLevelsDivisable;

    Wave(Model w, int type) {
        this.r = new Random();
        this.world = w;
        this.type = type;
        this.enemies = new ArrayList();
        this.xborder = this.world.getXsize();
        this.yborder = this.world.getYsize();
        this.level = 1;
    }

    Wave(int[] enemys, int minLevel, int maxLevel, int initialAmount, float increaseAmount, int skipLevelsDivisable, Model w) {
        this.enemies = new ArrayList();
        this.enemys = enemys;
        this.minLevel = minLevel;
        this.maxLevel = maxLevel;
        this.initialAmount = initialAmount;
        this.increaseAmount = increaseAmount;
        this.skipLevelsDivisable = skipLevelsDivisable;
        this.world = w;
        this.xborder = this.world.getXsize();
        this.yborder = this.world.getYsize();
        this.r = new Random();
    }

    public Brain populateBrains(int type) {
        int xRelCoord = this.xborder / 100;
        int yRelCoord = this.yborder / 100;
        Brain palautus = new Brain();
        palautus.addOrder(new Idea("Random", null));
        palautus.addOrder(new Idea("First move", new Point(0, 100)));
        if (type == 2) {
            palautus.orders.clear();
            palautus.addOrder(new Idea("Change speed", Float.valueOf(0.4f)));
            palautus.addOrder(new Idea("First move", new Point(0, 50)));
            palautus.addOrder(new Idea("Change speed", Float.valueOf(0.3f)));
            palautus.addOrder(new Idea("First move", new Point(0, 30)));
            palautus.addOrder(new Idea("Change speed", Float.valueOf(0.2f)));
            palautus.addOrder(new Idea("First move", new Point(0, 15)));
            palautus.addOrder(new Idea("Change speed", Float.valueOf(0.1f)));
            palautus.addOrder(new Idea("First move", new Point(0, 5)));
            palautus.addOrder(new Idea("Change speed", Float.valueOf(0.0f)));
            palautus.addOrder(new Idea("Shoot", null));
            palautus.addOrder(new Idea("Wait", new Integer(2000)));
            palautus.addOrder(new Idea("Change speed", Float.valueOf(0.1f)));
            palautus.addOrder(new Idea("First move", new Point(0, 5)));
            palautus.addOrder(new Idea("Change speed", Float.valueOf(0.2f)));
            palautus.addOrder(new Idea("First move", new Point(0, 15)));
            palautus.addOrder(new Idea("Change speed", Float.valueOf(0.3f)));
            palautus.addOrder(new Idea("First move", new Point(0, 30)));
            palautus.addOrder(new Idea("Change speed", Float.valueOf(0.4f)));
            palautus.addOrder(new Idea("First move", new Point(0, 50)));
            palautus.addOrder(new Idea("Change speed", Float.valueOf(0.5f)));
        }
        if (type == 3) {
            palautus.orders.clear();
            palautus.addOrder(new Idea("First move", new Point(0, yRelCoord * 10)));
            palautus.addOrder(new Idea("First move", new Point(xRelCoord * 1, yRelCoord * 4)));
            palautus.addOrder(new Idea("First move", new Point(xRelCoord * 1, yRelCoord * 3)));
            palautus.addOrder(new Idea("First move", new Point(xRelCoord * 2, yRelCoord * 2)));
            palautus.addOrder(new Idea("First move", new Point(xRelCoord * 3, yRelCoord)));
            palautus.addOrder(new Idea("First move", new Point(xRelCoord * 3, yRelCoord)));
            palautus.addOrder(new Idea("First move", new Point(xRelCoord * 3, -yRelCoord)));
            palautus.addOrder(new Idea("First move", new Point(xRelCoord * 2, -yRelCoord * 2)));
            palautus.addOrder(new Idea("First move", new Point(xRelCoord, -yRelCoord * 3)));
            palautus.addOrder(new Idea("First move", new Point(0, -yRelCoord * 3)));
            palautus.addOrder(new Idea("First move", new Point(-xRelCoord, -yRelCoord * 3)));
            palautus.addOrder(new Idea("First move", new Point(-xRelCoord * 2, -yRelCoord * 2)));
            palautus.addOrder(new Idea("First move", new Point(-xRelCoord * 3, -yRelCoord)));
            palautus.addOrder(new Idea("First move", new Point(-xRelCoord * 3, 0)));
            palautus.addOrder(new Idea("First move", new Point(-xRelCoord * 3, yRelCoord)));
            palautus.addOrder(new Idea("First move", new Point(-xRelCoord * 2, yRelCoord * 2)));
            palautus.addOrder(new Idea("First move", new Point(-xRelCoord, yRelCoord * 3)));
            palautus.addOrder(new Idea("First move", new Point(-xRelCoord, yRelCoord * 3)));
            palautus.addOrder(new Idea("First move", new Point(0, yRelCoord * 3)));
        }
        if (type == 4) {
            palautus.orders.clear();
            palautus.addOrder(new Idea("Random", null));
            palautus.addOrder(new Idea("First move", new Point(5, 100)));
            palautus.addOrder(new Idea("First move", new Point(5, 100)));
            palautus.addOrder(new Idea("First move", new Point(-5, 100)));
            palautus.addOrder(new Idea("First move", new Point(-5, 100)));
        }
        if (type == 5) {
            palautus.orders.clear();
            palautus.addOrder(new Idea("First move", new Point(-10, 50)));
            palautus.addOrder(new Idea("First move", new Point(10, 50)));
        }
        if (type == 6) {
            palautus.orders.clear();
            palautus.addOrder(new Idea("First move", new Point(0, 100)));
            palautus.addOrder(new Idea("First move", new Point(100, 0)));
        }
        if (type == 7) {
            palautus.orders.clear();
            palautus.addOrder(new Idea("First move", new Point(-xRelCoord * 100, 0)));
        }
        if (type == 10) {
            palautus.orders.clear();
            palautus.addOrder(new Idea("Fade in", new Integer(3000)));
            palautus.addOrder(new Idea("Wait", new Integer(5000)));
            palautus.addOrder(new Idea("Fade out", new Integer(3000)));
            palautus.addOrder(new Idea("Escape", null));
        }
        return palautus;
    }

    public ArrayList<Entity> getEnemies(int t, int time) {
        ArrayList<Entity> palautus = new ArrayList<Entity>();
        if (t > 0) {
            int k = 0;
            while (k < t) {
                int[] nArray = this.enemys;
                int n = this.enemys.length;
                int n2 = 0;
                while (n2 < n) {
                    int e = nArray[n2];
                    if (k < t) {
                        palautus.add(this.returnEnemy(this.r.nextInt(160) + 20, -10, ++k * 500, this.populateBrains(e), this.world, e));
                    }
                    ++n2;
                }
            }
        }
        return palautus;
    }

    public Enemy returnEnemy(int x, int y, int timer, Brain b, Model w, int type) {
        int timerAdd = 0;
        Enemy palautus = this.world.getCopyOfEnemy(type, x, y, timer + timerAdd, b);
        if (w.getMode() == "ninjaMode") {
            palautus.shot_freq = 10000 - w.getLevel();
        }
        return palautus;
    }

    public void populateEnemies(int level) {
        this.level = level;
        this.timeBetween = 6000 - level * 20;
        if (this.world.getMode() == "ninjaMode") {
            this.timeBetween = 5000 - level * 20;
        }
        this.enemies.clear();
        int p = 1;
        int[] nArray = this.enemys;
        int n = this.enemys.length;
        int n2 = 0;
        while (n2 < n) {
            int e = nArray[n2];
            if (level >= this.minLevel && (level < this.maxLevel || this.maxLevel == 0)) {
                int j = 1;
                while ((float)j < (float)this.initialAmount + this.increaseAmount * (float)level) {
                    this.enemies.add(this.returnEnemy(this.r.nextInt(this.xborder - 20) + 10, -10, j * 500 * p, this.populateBrains(e), this.world, e));
                    ++j;
                }
            }
            ++n2;
        }
    }
}

