/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import java.util.ArrayList;
import org.lwjgl.opengl.GL11;
import org.newdawn.slick.Color;
import org.newdawn.slick.TrueTypeFont;

public class DrawingTools {
    private int xsize;

    public DrawingTools(int xsize) {
        this.xsize = xsize;
    }

    public static void drawCircle(int x, int y, float r) {
        GL11.glPointSize(r);
        GL11.glEnable(2832);
        GL11.glBegin(0);
        GL11.glVertex2f((float)x + 0.5f, (float)y + 0.5f);
        GL11.glEnd();
        GL11.glDisable(2832);
    }

    public static void drawPixel(float x1, float y1) {
        GL11.glVertex2f(x1 + 100.5f, y1 + 0.5f);
    }

    public static void drawRectangle(float x1, float y1, float x2, float y2) {
        GL11.glVertex2f(x1, y1);
        GL11.glVertex2f(x2, y1);
        GL11.glVertex2f(x1, y2);
        GL11.glVertex2f(x2, y1);
        GL11.glVertex2f(x1, y2);
        GL11.glVertex2f(x2, y2);
    }

    public void drawTextArray(TrueTypeFont f, ArrayList<String> ss, int x, int y, Color c, boolean justified) {
        GL11.glEnable(3042);
        GL11.glBlendFunc(770, 771);
        int j = 0;
        for (String k : ss) {
            ++j;
            if (justified) {
                this.drawJustifiedText(f, y + j * f.getHeight(), k, c);
                continue;
            }
            DrawingTools.drawText(f, x, y + j * f.getHeight(), k, c);
        }
        GL11.glDisable(3042);
    }

    public void drawJustifiedText(TrueTypeFont f, int y, String s, Color c) {
        f.drawString((this.xsize - f.getWidth(s)) / 2, y, s, c);
    }

    public static void drawText(TrueTypeFont f, float x, float y, String s, Color c) {
        f.drawString(x, y, s, c);
    }
}

