/*
 * Decompiled with CFR 0.152.
 */
package campaign;

import campaign.Planet;
import campaign.Universe;
import java.util.ArrayList;
import java.util.Random;

public class CampaignPlayer {
    public static int ATTACK = 1;
    public static int BUILDFLEETS = 2;
    public static int IMPROVE = 3;
    public static int COLONIZE = 4;
    public int neededResourcesForShipYard = 1000000;
    public int neededResourcesForFleets = 10000;
    public int neededResourcesForPlanetaryDefences = 20000;
    public int neededResourcesForDepot = 2000;
    public int neededResourcesForTerraforming = 1000;
    public int neededResourcesForFactories = 2000;
    public String nimi;
    public int colonizationThreshold;
    public int minFleetStrength;
    public float fleetSpeed;
    private int productionEfficency;
    private int maxNumberOfFleets;
    private int totalNumberOfFleets;
    private int totalAmountOfFuel;
    private int totalAmountOfResources;
    private int totalAmountOfActualProduction;
    public float a;
    public float b;
    public float c;
    private int Mode;
    private Universe maailma;
    private ArrayList<Planet> targets;
    private Random r;
    private float fleetsToProductionThreshold;

    public int getTotalNumberOfFleets() {
        return this.totalNumberOfFleets;
    }

    public int getTotalAmountOfFuel() {
        return this.totalAmountOfFuel;
    }

    public int getTotalAmountOfResources() {
        return this.totalAmountOfResources;
    }

    public CampaignPlayer() {
    }

    public ArrayList<Planet> getTargets() {
        return this.targets;
    }

    public CampaignPlayer(String s, int ct, int mfs, float fs, int prdEff, Universe u) {
        this.r = new Random();
        this.targets = new ArrayList();
        this.nimi = s;
        this.colonizationThreshold = ct;
        this.minFleetStrength = 5;
        this.fleetSpeed = fs;
        this.minFleetStrength = mfs;
        this.productionEfficency = prdEff;
        Random r = new Random();
        this.a = ((float)r.nextInt(50) + 50.0f) / 100.0f;
        this.b = ((float)r.nextInt(50) + 50.0f) / 100.0f;
        this.c = ((float)r.nextInt(50) + 50.0f) / 100.0f;
        this.fleetsToProductionThreshold = 0.8f;
        if (s == "Player1") {
            this.a = 0.0f;
            this.b = 0.0f;
            this.c = 0.99f;
        }
        if (s == "None") {
            this.a = 0.5f;
            this.b = 0.5f;
            this.c = 0.5f;
        }
        this.maailma = u;
    }

    public void Live() {
        if (this.nimi == "None" || this.maailma.getPlanets(this.nimi) == 0) {
            return;
        }
        int underDeveloped = 1;
        this.maxNumberOfFleets = 0;
        this.totalNumberOfFleets = 0;
        this.totalAmountOfActualProduction = 0;
        this.totalAmountOfFuel = 0;
        this.totalAmountOfResources = 0;
        for (Planet p : this.maailma.getPlanetsByOwner(this.nimi)) {
            if (p.getActualProductionInPercentage() < 50 && p.getProductionPotential() < 50.0f) {
                ++underDeveloped;
            }
            this.totalAmountOfActualProduction = (int)((float)this.totalAmountOfActualProduction + p.actualProduction);
            this.totalAmountOfFuel += p.getFuelAmount();
            this.totalAmountOfResources += p.getResources();
            this.totalNumberOfFleets += p.getFleetStrength();
        }
        if (this.totalAmountOfFuel <= this.totalAmountOfResources) {
            this.maxNumberOfFleets = this.totalAmountOfFuel;
        }
        if (this.totalAmountOfFuel > this.totalAmountOfResources) {
            this.maxNumberOfFleets = this.totalAmountOfResources;
        }
        if (this.maailma.getPlanets("None") != 0) {
            this.Mode = COLONIZE;
            return;
        }
        if (underDeveloped > 2 || this.maxNumberOfFleets < this.getNumberOfFleets() && this.maailma.getPlanetsWithShipyards(this.nimi) != this.maailma.getPlanets(this.nimi)) {
            this.Mode = IMPROVE;
            return;
        }
        int ownFleetStrengths = this.maailma.getStrengthForAllFleets(this);
        CampaignPlayer weakest = this;
        Planet bestTargetForPlayer = null;
        this.targets.clear();
        for (CampaignPlayer c : this.maailma.getCampaignPlayers()) {
            if (c.nimi == "None" || c == this) continue;
            Planet weakestForPlayer = null;
            for (Planet p : this.maailma.getPlanetsByOwner(c.nimi)) {
                if (weakestForPlayer == null || weakestForPlayer.getFleetStrength() > p.getFleetStrength()) {
                    weakestForPlayer = p;
                }
                if (bestTargetForPlayer == null) {
                    bestTargetForPlayer = p;
                }
                if (((double)(this.totalAmountOfFuel / this.totalAmountOfResources + 1) < 1.2 || (double)(this.totalAmountOfFuel / this.totalAmountOfResources + 1) > 0.8) && bestTargetForPlayer.getActualProductionInPercentage() < p.getActualProductionInPercentage()) {
                    bestTargetForPlayer = p;
                    continue;
                }
                if (this.totalAmountOfFuel > this.totalAmountOfResources && bestTargetForPlayer.getResources() < p.getResources()) {
                    bestTargetForPlayer = p;
                    continue;
                }
                if (this.totalAmountOfFuel >= this.totalAmountOfResources || bestTargetForPlayer.getFuelAmount() >= p.getFuelAmount()) continue;
                bestTargetForPlayer = p;
            }
            if (weakestForPlayer != null) {
                if (this.targets.size() == 0) {
                    this.targets.add(weakestForPlayer);
                } else {
                    this.targets.add(this.r.nextInt(this.targets.size()), weakestForPlayer);
                }
            }
            if (this.maailma.getStrengthForAllFleets(c) >= ownFleetStrengths) continue;
            weakest = c;
        }
        if (bestTargetForPlayer != null) {
            this.targets.add(bestTargetForPlayer);
        }
        if (weakest == this && this.maxNumberOfFleets >= this.totalNumberOfFleets) {
            return;
        }
        this.Mode = ATTACK;
    }

    public Planet getPrimaryTarget() {
        return this.targets.get(0);
    }

    public int getProductionEfficency() {
        return this.productionEfficency;
    }

    public void setProductionEfficency(int productionEfficency) {
        this.productionEfficency = productionEfficency;
    }

    public int getMode() {
        return this.Mode;
    }

    public String getModeInText() {
        if (this.Mode == 1) {
            return "Attack";
        }
        if (this.Mode == 2) {
            return "Build Fleets";
        }
        if (this.Mode == 3) {
            return "Improve";
        }
        return "Colonize";
    }

    public void setMode(int mode) {
        this.Mode = mode;
    }

    public int getMaxNumberOfFleets() {
        return this.maxNumberOfFleets;
    }

    public int getNumberOfFleets() {
        return this.totalNumberOfFleets;
    }

    public float getFleetsToProductionThreshold() {
        return this.fleetsToProductionThreshold;
    }
}

