/*
 * Decompiled with CFR 0.152.
 */
package campaign;

import campaign.CampaignPlayer;
import campaign.Order;
import campaign.Planet;
import campaign.Universe;
import java.util.ArrayList;
import java.util.Random;

public class Fleet {
    private float xx;
    private float yy;
    public CampaignPlayer owner;
    public Planet current;
    protected Planet targetPlanet;
    protected Fleet targetFleet;
    protected String mode;
    public int strength;
    protected String orders;
    boolean retreat;
    boolean inOrbit = true;
    boolean inFlight = false;
    Universe maailma;
    private float radius = 0.0f;
    Random r;
    private boolean colonize;
    private boolean intercept;
    private boolean attack;
    private boolean returnBase;
    private Order currentOrder = new Order();
    private int ticks = 0;
    int number;
    private boolean wait = false;
    private boolean isVisible;
    private boolean inBattle;

    public int getFleetNumber() {
        return this.number;
    }

    Fleet(Planet p, CampaignPlayer c, Universe u) {
        this.r = new Random();
        this.maailma = u;
        this.owner = c;
        this.strength = 1;
        this.current = p;
        this.setXx(p.getXPlace());
        this.setYy(p.getYPlace());
        this.retreat = false;
        this.targetPlanet = null;
        this.current.setFleetInOrbit(this);
        this.current = p;
        if (c.nimi == "Player1") {
            this.isVisible = true;
        }
    }

    public int getStrength() {
        return this.strength;
    }

    public boolean areTheyClose(float x1, float y1, float x2, float y2, int threshold) {
        return (double)threshold > Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
    }

    private Planet getClosestPlanet(ArrayList<Planet> plist) {
        Planet closest = null;
        for (Planet p : plist) {
            if (closest == null) {
                closest = p;
            }
            if (!(this.distance(p.getXx(), p.getYy(), this.getXx(), this.getYy()) < this.distance(closest.getXx(), closest.getYy(), this.getXx(), this.getYy()))) continue;
            closest = p;
        }
        return closest;
    }

    private Fleet getClosestFleet(ArrayList<Fleet> flist) {
        Fleet closest = null;
        for (Fleet f : flist) {
            if (closest == null) {
                closest = f;
            }
            if (!(this.distance(f.getXx(), f.getYy(), this.getXx(), this.getYy()) < this.distance(closest.getXx(), closest.getYy(), this.getXx(), this.getYy()))) continue;
            closest = f;
        }
        return closest;
    }

    private Planet getNewbase() {
        if (this.current != null) {
            return this.current;
        }
        return this.getClosestPlanet(this.maailma.getPlanetsByOwner(this.owner.nimi));
    }

    public void AttackFleet(Fleet target) {
        if (this.current != null) {
            this.leaveOrbit();
        }
        if (target != null) {
            if (this.areTheyClose(this.getXx(), this.getYy(), target.getXx(), target.getYy(), 1)) {
                this.currentOrder = new Order("Battle fleet", target);
                target.currentOrder = new Order("Battle fleet", this);
                return;
            }
            this.fleetGetCloserTo(target.getXx(), target.getYy());
        }
        if (target == null) {
            this.currentOrder.setOrder("Done");
        }
    }

    public void liveIt() {
        if (this.strength == 0) {
            return;
        }
        if (this.owner.nimi != "Player1" && this.current == null) {
            this.isVisible = false;
            for (Planet p : this.maailma.getPlanetsByOwner("Player1")) {
                if (!this.areTheyClose(this.getXx(), this.getYy(), p.getXx(), p.getYy(), p.getRadarCoverage())) continue;
                this.isVisible = true;
                break;
            }
        }
        if (this.currentOrder.getOrder() == "Done") {
            this.currentOrder = this.getNewOrder();
        }
        if (this.currentOrder.getOrder() == "Stay put" || this.currentOrder.getOrder() == "") {
            ++this.ticks;
        }
        if (this.ticks > 500) {
            this.currentOrder.setOrder("Done");
            if (this.current == null) {
                System.out.println("Hep!!!");
            }
            this.ticks = 0;
        }
        if (this.currentOrder.getOrder() == "Colonize") {
            this.goToPlanet((Planet)this.currentOrder.getSubject());
        }
        if (this.currentOrder.getOrder() == "Attack fleet") {
            this.goToFleet((Fleet)this.currentOrder.getSubject());
        }
        if (this.currentOrder.getOrder() == "Return to base") {
            this.goToPlanet((Planet)this.currentOrder.getSubject());
        }
        if (this.currentOrder.getOrder() == "Merge with fleet") {
            this.goToFleet((Fleet)this.currentOrder.getSubject());
        }
        if (this.currentOrder.getOrder() == "Go to planet") {
            this.goToPlanet((Planet)this.currentOrder.getSubject());
        }
        if (this.currentOrder.getOrder() == "Battle fleet") {
            this.maailma.battleItOut(this, (Fleet)this.currentOrder.getSubject(), "Live it");
        }
        if (this.currentOrder.getOrder() == "Battle ground Defences") {
            this.maailma.groundBattle(this, (Planet)this.currentOrder.getSubject());
        }
    }

    private void goToPlanet(Planet target) {
        if (this.current != null && this.current != target) {
            this.leaveOrbit();
        }
        if (target != null) {
            if (this.areTheyClose(this.getXx(), this.getYy(), target.getXx(), target.getYy(), 1)) {
                this.arriveToOrbit(target);
                return;
            }
            this.fleetGetCloserTo(target.getXx(), target.getYy());
            if (target.owner != this.owner) {
                target.setSafe(false);
            }
        }
    }

    private void goToFleet(Fleet target) {
        if (this.current != null) {
            this.leaveOrbit();
        }
        if (target == null || target.strength == 0) {
            this.currentOrder.setOrder("Done");
        }
        if (target != null) {
            if (this.areTheyClose(this.getXx(), this.getYy(), target.getXx(), target.getYy(), 1)) {
                this.arriveToFleet(target);
                return;
            }
            this.fleetGetCloserTo(target.getXx(), target.getYy());
        }
    }

    private void arriveToFleet(Fleet target) {
        if (target == null) {
            System.out.println("Target fleet on null!");
        }
        if (target.owner == this.owner) {
            target.strength += this.strength;
            this.strength = 0;
            return;
        }
        if (target.owner != this.owner) {
            if (target.current != null) {
                this.current = target.current;
            }
            this.currentOrder = new Order("Battle fleet", target);
            target.setCurrentOrder(new Order("Battle fleet", this));
            return;
        }
    }

    private void notifyMerging() {
        if (this.currentOrder.getOrder() != "Merge with fleet") {
            this.wait = true;
        }
    }

    public Planet getCurrent() {
        return this.current;
    }

    private Order getNewOrder() {
        ArrayList<Planet> apu = new ArrayList<Planet>();
        Order palautus = new Order();
        palautus.setOrder("Stay put", null);
        if (this.current == null || this.getCurrent().getName().matches("No Current")) {
            palautus.setOrder("Go to planet", this.getClosestPlanet(this.maailma.getPlanets()));
            return palautus;
        }
        if (this.current != null && this.current.owner != this.owner) {
            palautus.setOrder("Colonize", this.current);
            return palautus;
        }
        if (this.current != null && !this.current.isSafe()) {
            return palautus;
        }
        if (this.current != null && this.current.getActualProductionInPercentage() < 20 && this.current.owner == this.owner || this.strength < this.owner.getMaxNumberOfFleets() / this.maailma.getPlanets(this.owner.nimi)) {
            return palautus;
        }
        block0 : switch (this.owner.getMode()) {
            case 1: {
                for (Planet p : this.owner.getTargets()) {
                    if (!((double)p.getFleetStrength() * 1.3 < (double)this.strength)) continue;
                    palautus.setOrder("Go to planet", p);
                    p.setSafe(false);
                    break;
                }
                if (this.current != null) {
                    int k = 0;
                    while (k < 10) {
                        if (k >= this.current.planetsClosestToDistant.size()) break block0;
                        Planet p = this.current.planetsClosestToDistant.get(k);
                        if (p.owner != this.owner && (double)p.getFleetStrength() * 1.3 < (double)this.strength) {
                            palautus.setOrder("Go to planet", p);
                            p.setSafe(false);
                        }
                        ++k;
                    }
                    break;
                }
                if (this.current == null || !this.current.isSafe()) break;
                for (Planet p : this.maailma.getPlanetsByOwner(this.owner.nimi)) {
                    if (!(p.getPreferredNumberOfFleets() > this.current.getPreferredNumberOfFleets()) && p.isSafe()) continue;
                    apu.add(p);
                }
                if (apu.size() <= 0) break;
                palautus.setOrder("Go to planet", this.getClosestPlanet(apu));
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                if (this.current == null) break;
                for (Planet p : this.maailma.getPlanetsByOwner(this.owner.nimi)) {
                    if (p.getFleetInOrbit() != null && !(p.actualProduction / p.productionPotential < this.owner.getFleetsToProductionThreshold()) && !(p.getPreferredNumberOfFleets() > this.current.getPreferredNumberOfFleets()) && p.isSafe() || p == this.current) continue;
                    apu.add(p);
                }
                if (apu.size() <= 0 || !this.r.nextBoolean() && !this.r.nextBoolean()) break;
                palautus.setOrder("Go to planet", this.getClosestPlanet(apu));
                break;
            }
            case 4: {
                Planet closestPlanet = this.getClosestPlanet(this.maailma.getPlanetsByOwner("None"));
                if (closestPlanet != null) {
                    palautus.setOrder("Colonize", closestPlanet);
                }
                if (closestPlanet != null) break;
                apu.clear();
                for (Planet p : this.maailma.getPlanets()) {
                    if ((p.getFleetInOrbit() != null || p.owner == this.owner) && (p.getFleetInOrbit() != this || p.owner == this.owner)) continue;
                    apu.add(p);
                }
                if (apu.size() <= 0) break;
                palautus.setOrder("Colonize", this.getClosestPlanet(apu));
            }
        }
        return palautus;
    }

    private double distance(float x1, float y1, float x2, float y2) {
        return Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
    }

    private void fleetGetCloserTo(float x, float y) {
        double length = Math.sqrt((x - this.getXx()) * (x - this.getXx()) + (y - this.getYy()) * (y - this.getYy()));
        double unitX = (double)(x - this.getXx()) / length;
        double unitY = (double)(y - this.getYy()) / length;
        this.setXx((float)((double)this.getXx() + unitX * (double)this.owner.fleetSpeed));
        this.setYy((float)((double)this.getYy() + unitY * (double)this.owner.fleetSpeed));
    }

    private void leaveOrbit() {
        if (this.current.getFleetInOrbit() == null) {
            System.out.println("Tyhj\u00e4\u00e4 on!");
        }
        if (this.current.owner == this.owner) {
            this.maailma.makeNewFleet(this.current);
        }
        this.current = null;
        this.maailma.fleetInTransit = true;
    }

    private void arriveToOrbit(Planet p) {
        if (p == this.maailma.getPlayerOrbitingPlanet() && !this.owner.nimi.matches("Player1")) {
            this.maailma.initiateAttackMode(this);
            return;
        }
        if (p.actualProduction / p.productionPotential < this.owner.getFleetsToProductionThreshold() && this.owner == p.owner) {
            this.addToPlanetsProduction(p);
        }
        if (p.getFleetInOrbit() != null) {
            if (p.getFleetInOrbit().owner == this.owner && p.getFleetInOrbit() != this) {
                p.getFleetInOrbit().strength += this.strength;
                this.strength = 0;
                return;
            }
            if (p.getFleetInOrbit().owner != this.owner) {
                this.currentOrder = new Order("Battle fleet", p.getFleetInOrbit());
                p.getFleetInOrbit().currentOrder = new Order("Battle fleet", this);
                return;
            }
        }
        if (p.getFleetInOrbit() == null) {
            if (p.owner == this.owner) {
                p.setFleetInOrbit(this);
            } else {
                this.currentOrder = p.getPlanetaryDefences() > 0 ? new Order("Battle ground Defences", p) : new Order("Colonize", p);
            }
        }
        if (this.currentOrder.getOrder() == "Colonize") {
            this.Colonize(p);
            return;
        }
        this.setXx(p.getXx());
        this.setYy(p.getYy());
        if (this.current != null && this.owner == this.current.owner) {
            this.current.setFleetInOrbit(this);
            this.currentOrder.setOrder("Done");
        }
    }

    public void setTarget(Planet p) {
        this.targetPlanet = p;
    }

    public void setTargetFleet(Fleet f) {
        this.targetFleet = f;
    }

    public Fleet getTargetFleet() {
        return this.targetFleet;
    }

    public void setMode(String m) {
        this.mode = m;
    }

    public void addToStrength(int a) {
        this.strength += a;
    }

    public void addToPlanetsProduction(Planet target) {
        target.actualProduction += 0.25f * (float)this.strength;
        this.strength /= 5;
    }

    public void Colonize(Planet target) {
        if (target.owner != this.owner) {
            target.actualProduction = (float)((double)target.actualProduction * 0.8);
        }
        this.current = target;
        this.addToPlanetsProduction(target);
        this.currentOrder.setOrder("Done");
        target.setOwner(this.owner);
        target.mode = 1;
        target.setDepot(true);
        target.setFleetInOrbit(this);
    }

    public void lessenStrength() {
        --this.strength;
    }

    public String getCurrentName() {
        if (this.current != null) {
            return this.current.getName();
        }
        return "No Current";
    }

    public String getMode() {
        if (this.colonize) {
            return "Colonize";
        }
        if (this.intercept) {
            return "Intercept";
        }
        if (this.attack) {
            return "Attack";
        }
        if (this.returnBase) {
            return "Return to Base";
        }
        return "No Mode";
    }

    public String getTargetPlanet() {
        if (this.targetPlanet != null) {
            return this.targetPlanet.getName();
        }
        return "No Target Planet";
    }

    public Order getCurrentOrder() {
        return this.currentOrder;
    }

    public void setCurrentOrder(Order o) {
        this.currentOrder = o;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }

    public float getXx() {
        return this.xx;
    }

    public void setXx(float xx) {
        this.xx = xx;
    }

    public float getYy() {
        return this.yy;
    }

    public void setYy(float yy) {
        this.yy = yy;
    }
}

