/*
 * Decompiled with CFR 0.152.
 */
package campaign;

import campaign.CampaignPlayer;
import campaign.Fleet;
import campaign.Universe;
import java.util.ArrayList;
import java.util.Random;

public class Planet {
    protected float productionPotential = 100.0f;
    protected float actualProduction;
    private int fuelAmount;
    private int resources;
    protected CampaignPlayer owner;
    protected int mode;
    protected ArrayList<Planet> planetsClosestToDistant;
    private double preferredNumberOfFleets;
    private Fleet fleetInOrbit;
    protected boolean underAttack;
    private int xx;
    private int yy;
    protected String nimi;
    protected Universe maailma;
    protected int fleets;
    protected Random r = new Random();
    protected boolean depot;
    protected boolean isVisible;
    private int radarCoverage;
    private float resourcePile = 0.0f;
    private int planetaryDefences;
    private String currentProduction;
    protected double preferredFleetFactorial;
    private int ticks;
    private boolean isSafe;
    private boolean hasShipYard;

    public String getCurrentProduction() {
        return this.currentProduction;
    }

    public void setHasShipYard(boolean hasShipYard) {
        this.hasShipYard = hasShipYard;
    }

    public boolean isHasShipYard() {
        return this.hasShipYard;
    }

    public int getRadarCoverage() {
        return this.radarCoverage;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }

    public boolean isDepot() {
        return this.depot;
    }

    public void setDepot(boolean depot) {
        this.depot = depot;
    }

    public ArrayList<Planet> getClosestPlanets(int amount) {
        return (ArrayList)this.planetsClosestToDistant.subList(0, amount);
    }

    public int getFleetStrength() {
        if (this.fleetInOrbit != null) {
            return this.fleetInOrbit.strength;
        }
        return 0;
    }

    Planet(int x, int y, String name, Universe u, CampaignPlayer c) {
        int painotus = this.r.nextInt(3);
        if (this.r.nextBoolean()) {
            this.setFuelAmount(painotus * 10 + this.r.nextInt(10));
            this.setResources((3 - painotus) * 10 + this.r.nextInt(10));
        } else {
            this.setResources(painotus * 10 + this.r.nextInt(10));
            this.setFuelAmount((3 - painotus) * 10 + this.r.nextInt(10));
        }
        this.owner = c;
        this.setXx(x);
        this.setYy(y);
        this.mode = 0;
        this.nimi = name;
        this.maailma = u;
        this.preferredNumberOfFleets = 10.0;
        this.radarCoverage = 200;
        this.depot = c.nimi == "Player1";
        this.ticks = 0;
        this.planetsClosestToDistant = new ArrayList();
        this.isSafe = true;
        this.hasShipYard = false;
        this.currentProduction = "None";
        this.actualProduction = 1.0f;
    }

    public double getPreferredNumberOfFleets() {
        return this.preferredNumberOfFleets;
    }

    public void setPreferredNumberOfFleets(double preferredNumberOfFleets) {
        this.preferredNumberOfFleets = preferredNumberOfFleets;
    }

    public Fleet getFleetInOrbit() {
        return this.fleetInOrbit;
    }

    public void currentFleetLeftOrbit() {
        this.fleetInOrbit = null;
    }

    public void setFleetInOrbit(Fleet f) {
        f.current = this;
        this.fleetInOrbit = f;
        this.fleetInOrbit.setXx(this.getXx());
        this.fleetInOrbit.setYy(this.getYy());
        f.inOrbit = true;
    }

    public void setActualProduction(float p) {
        this.actualProduction = p;
    }

    public void setOwner(CampaignPlayer c) {
        this.owner = c;
        if (c.nimi != "None") {
            this.mode = 1;
        }
        if (c.nimi == "Player1") {
            this.isVisible = true;
            this.depot = true;
        }
        this.isSafe = true;
        this.planetaryDefences = 0;
        this.maailma.checkPlanetVisibility();
        this.maailma.checkPlanetFleetAmount();
        this.resetProductionAndPile();
    }

    public String getName() {
        return this.nimi;
    }

    public boolean areTheyClose(float x1, float y1, float x2, float y2, int threshold) {
        return (double)threshold > Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
    }

    public void checkVisibility() {
        for (Planet p : this.maailma.getPlanetsByOwner("Player1")) {
            if (!this.areTheyClose(p.getXx(), p.getYy(), this.getXx(), this.getYy(), p.getRadarCoverage())) continue;
            this.isVisible = true;
            return;
        }
    }

    public void Live() {
        if (this.owner.nimi == "None") {
            return;
        }
        ++this.ticks;
        if (this.ticks > 50) {
            this.preferredNumberOfFleets = this.preferredFleetFactorial * (double)this.maailma.getStrengthForAllFleets(this.owner);
            this.ticks = 0;
        }
        if (this.fleetInOrbit != null && this.fleetInOrbit.strength == 0) {
            this.fleetInOrbit = null;
        }
        if (this.owner.getMode() == 0) {
            return;
        }
        this.resourcePile += this.actualProduction;
        if (this.currentProduction != "None") {
            this.letsProduce();
        }
        if (this.currentProduction == "None") {
            if (!this.isSafe) {
                this.currentProduction = this.hasShipYard ? "Fleets" : "Planetary defences";
            } else {
                if (this.owner.getMode() == 1) {
                    if (this.actualProduction > 100.0f && !this.hasShipYard) {
                        this.currentProduction = "Shipyard";
                    }
                    if (this.hasShipYard) {
                        this.currentProduction = "Fleets";
                    }
                }
                if (this.owner.getMode() == 2) {
                    this.currentProduction = this.hasShipYard ? "Fleets" : "Shipyard";
                }
                if (this.owner.getMode() == 3) {
                    if (this.actualProduction < 100.0f) {
                        this.currentProduction = "Factories";
                    } else if (this.productionPotential < 200.0f) {
                        this.currentProduction = "Terraforming";
                    }
                }
                if (this.owner.getMode() == 4) {
                    this.currentProduction = this.hasShipYard && this.actualProduction > 100.0f ? "Fleets" : (!this.hasShipYard && this.actualProduction > 100.0f ? "Shipyard" : "Factories");
                }
            }
        }
        if (this.currentProduction == "None") {
            if (this.productionPotential > this.actualProduction) {
                this.currentProduction = "Factories";
            }
            if (this.actualProduction > 200.0f && !this.hasShipYard) {
                this.currentProduction = "Shipyard";
            }
            if (this.actualProduction > 200.0f && this.hasShipYard) {
                this.currentProduction = "Fleets";
            }
        }
        if (!this.isSafe) {
            this.isSafe = true;
        }
    }

    public float getProductionPotential() {
        return this.productionPotential;
    }

    private void letsProduce() {
        if (this.currentProduction.equals("Factories")) {
            if (this.resourcePile >= (float)this.owner.neededResourcesForFactories + this.actualProduction * 100.0f) {
                this.actualProduction += 1.0f;
                this.resetProductionAndPile();
            }
        } else if (this.currentProduction.equals("Terraforming")) {
            if (this.resourcePile >= (float)this.owner.neededResourcesForTerraforming) {
                this.productionPotential += 0.1f;
                this.resetProductionAndPile();
            }
        } else if (this.currentProduction.equals("Fleets")) {
            if (this.resourcePile >= (float)this.owner.neededResourcesForFleets) {
                this.addToFleets();
                this.resetProductionAndPile();
            }
        } else if (this.currentProduction.equals("Shipyard")) {
            if (this.resourcePile >= (float)this.owner.neededResourcesForShipYard) {
                this.hasShipYard = true;
                this.resetProductionAndPile();
            }
        } else if (this.currentProduction.equals("Planetary defences") && this.resourcePile >= (float)this.owner.neededResourcesForPlanetaryDefences) {
            this.setPlanetaryDefences(this.getPlanetaryDefences() + 1);
            this.resetProductionAndPile();
        }
    }

    protected void resetProductionAndPile() {
        this.currentProduction = "None";
        this.resourcePile = 0.0f;
    }

    private ArrayList<Planet> scanForTargets() {
        return this.maailma.getPlanets();
    }

    private void addToFleets() {
        if (this.fleetInOrbit == null) {
            this.fleetInOrbit = new Fleet(this, this.owner, this.maailma);
            this.fleetInOrbit.number = this.maailma.getNextFleetNumber();
            this.maailma.fleets.add(this.fleetInOrbit);
            this.fleetInOrbit.setVisible(this.isVisible);
        }
        this.fleetInOrbit.addToStrength(1);
    }

    public CampaignPlayer getOwner() {
        return this.owner;
    }

    public int getXPlace() {
        return this.getXx();
    }

    public int getYPlace() {
        return this.getYy();
    }

    public String getActualProductionInText() {
        if (this.actualProduction / this.productionPotential == 0.0f) {
            return "";
        }
        if ((double)(this.actualProduction / this.productionPotential) < 0.2) {
            return "Very Low";
        }
        if ((double)(this.actualProduction / this.productionPotential) < 0.4) {
            return "Low";
        }
        if ((double)(this.actualProduction / this.productionPotential) < 0.6) {
            return "Medium";
        }
        if ((double)(this.actualProduction / this.productionPotential) < 0.7) {
            return "Good";
        }
        if ((double)(this.actualProduction / this.productionPotential) < 0.9) {
            return "Very Good";
        }
        return "Full";
    }

    public int getActualProductionInPercentage() {
        return (int)(this.actualProduction / this.productionPotential * 100.0f);
    }

    public int getActualProduction() {
        return (int)this.actualProduction;
    }

    public String getProductionInText() {
        if (this.mode == 0) {
            return "";
        }
        if (this.mode == 1) {
            return "Factories";
        }
        return "Fleets";
    }

    public int getXx() {
        return this.xx;
    }

    public void setXx(int xx) {
        this.xx = xx;
    }

    public int getYy() {
        return this.yy;
    }

    public void setYy(int yy) {
        this.yy = yy;
    }

    public boolean isSafe() {
        return this.isSafe;
    }

    public void setSafe(boolean isSafe) {
        this.isSafe = isSafe;
    }

    public int getFuelAmount() {
        return this.fuelAmount;
    }

    public void setFuelAmount(int fuelAmount) {
        this.fuelAmount = fuelAmount;
    }

    public int getResources() {
        return this.resources;
    }

    public void setResources(int resources) {
        this.resources = resources;
    }

    public int getPlanetaryDefences() {
        return this.planetaryDefences;
    }

    public void setPlanetaryDefences(int planetaryDefences) {
        this.planetaryDefences = planetaryDefences;
    }
}

