/*
 * Decompiled with CFR 0.152.
 */
package campaign;

import campaign.CampaignPlayer;
import campaign.Fleet;
import campaign.Order;
import campaign.Planet;
import campaign.StellarLocation;
import java.util.ArrayList;
import java.util.Random;
import java.util.TreeSet;
import peli.Model;
import peli.Player;

public class Universe {
    protected ArrayList<Planet> planets;
    protected ArrayList<StellarLocation> locations;
    protected ArrayList<Fleet> fleets;
    private ArrayList<CampaignPlayer> campaignPlayers;
    protected int xSize;
    protected int ySize;
    public String mode;
    protected Model kentta;
    protected Fleet targetFleet;
    protected Planet targetPlanet;
    private String currentScenario;
    private Planet homeBase;
    protected boolean pause;
    boolean fleetInTransit;
    private boolean playerInOrbit;
    private int fleetNumber;
    private boolean engage;
    private int ticks;
    public float playerX;
    public float playerY;
    protected float playerXvector;
    protected float playerYvector;
    private Player p;
    CampaignPlayer player1;
    CampaignPlayer none;
    Random r;
    private double radius;
    private StellarLocation targetLocation;
    private String wonScenario;

    public double getRadius() {
        return this.radius;
    }

    public StellarLocation getTargetLocation() {
        return this.targetLocation;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public String getMode() {
        return this.mode;
    }

    public boolean isPause() {
        return this.pause;
    }

    public boolean isPlayerInOrbit(Planet p) {
        return this.areTheyClose(this.playerX, this.playerY, p.getXx(), p.getYy(), 1.0f);
    }

    public void setPlayer(Player pl) {
        this.p = pl;
    }

    public Player getPlayer() {
        return this.p;
    }

    public Universe(Model w) {
        this.kentta = w;
        this.planets = new ArrayList();
        this.fleets = new ArrayList();
        this.locations = new ArrayList();
        this.campaignPlayers = new ArrayList();
        this.r = new Random();
        this.player1 = new CampaignPlayer("Player1", 20, 10, 0.4f, 5000, this);
        this.none = new CampaignPlayer("None", 0, 0, 0.0f, 0, this);
        this.campaignPlayers.add(this.none);
        this.campaignPlayers.add(this.player1);
        this.playerX = 0.0f;
        this.playerY = 0.0f;
    }

    public void newGame() {
        this.mode = "Campaign";
        this.fleetNumber = 0;
        this.pause = false;
        this.playerYvector = 0.0f;
        this.playerXvector = 0.0f;
        this.playerInOrbit = true;
        this.fleetInTransit = false;
        this.targetFleet = null;
        this.targetPlanet = null;
        this.targetLocation = null;
        this.wonScenario = "";
        this.fleets.clear();
        this.locations.clear();
        this.campaignPlayers.clear();
        this.player1 = new CampaignPlayer("Player1", 20, 10, 0.4f, 5000, this);
        this.none = new CampaignPlayer("None", 0, 0, 0.0f, 0, this);
        this.campaignPlayers.add(this.none);
        this.campaignPlayers.add(this.player1);
        this.ticks = 0;
        this.kentta.newGame("Game", 0);
        if (this.p != null) {
            this.p.setAlive(true);
        }
    }

    public void createUniverse(int[] planetList) {
        this.newGame();
        this.planets.clear();
        int j = 0;
        while (j < planetList.length - 3) {
            this.getCampaignPlayers().add(new CampaignPlayer("Enemy" + j, 10, 10, 0.3f, 5000, this));
            ++j;
        }
        int allPlanets = 0;
        int[] nArray = planetList;
        int n = planetList.length;
        int n2 = 0;
        while (n2 < n) {
            int a = nArray[n2];
            allPlanets += a;
            ++n2;
        }
        int x = (int)Math.sqrt((allPlanets + 1) * 2);
        int y = x + 1;
        int xkoko = this.kentta.getXsize() * this.kentta.getZoomLevel();
        int ykoko = this.kentta.getYsize() * this.kentta.getZoomLevel();
        int j2 = 0;
        while (j2 < x) {
            int k = 0;
            while (k < y) {
                Planet newPlanet = new Planet(xkoko / (x + 1) * j2 + this.r.nextInt(20) + 40, xkoko / (y + 1) * k - this.r.nextInt(20) + 30, "Planet #" + j2 + k, this, this.none);
                newPlanet.setOwner(this.none);
                this.planets.add(newPlanet);
                ++k;
            }
            ++j2;
        }
        while (this.planets.size() > allPlanets) {
            this.planets.remove(this.r.nextInt(this.planets.size()));
        }
        this.prepareStellarLocations();
        int planet = 0;
        int owner = -1;
        int[] nArray2 = planetList;
        int n3 = planetList.length;
        int n4 = 0;
        while (n4 < n3) {
            int p = nArray2[n4];
            if (++owner != 0) {
                while (p > 0) {
                    planet = this.r.nextInt(this.planets.size());
                    if (this.planets.get((int)planet).owner != this.none) continue;
                    this.planets.get(planet).setOwner(this.getCampaignPlayers().get(owner));
                    if (p == 1) {
                        this.planets.get(planet).setHasShipYard(true);
                        this.planets.get((int)planet).actualProduction = 100.0f;
                    }
                    --p;
                }
            }
            ++n4;
        }
        this.playerX = this.getPlanetsByOwner(this.player1.nimi).get(0).getXx();
        this.playerY = this.getPlanetsByOwner(this.player1.nimi).get(0).getYy();
        this.setHomeBase(this.getPlanetsByOwner(this.player1.nimi).get(0));
        this.checkPlanetVisibility();
        for (Planet p : this.planets) {
            this.fillAndOrderPlanets(p);
        }
    }

    private void prepareStellarLocations() {
        int kerroin = -1;
        int j = 0;
        while (j < 5) {
            kerroin = this.r.nextBoolean() ? 1 : -1;
            Planet p = this.planets.get(this.r.nextInt(this.planets.size() - 1));
            this.locations.add(new StellarLocation(p.getXx() + (this.r.nextInt(20) + 20) * kerroin, p.getYy() + (this.r.nextInt(20) + 20) * kerroin, "Testi", 2));
            ++j;
        }
    }

    private CampaignPlayer getOwnerByName(String string) {
        for (CampaignPlayer c : this.getCampaignPlayers()) {
            if (c.nimi != string) continue;
            return c;
        }
        return null;
    }

    public int getNextFleetNumber() {
        return ++this.fleetNumber;
    }

    public int getPlanets(String which) {
        int palautus = 0;
        for (Planet p : this.planets) {
            if (!p.owner.nimi.matches(which)) continue;
            ++palautus;
        }
        return palautus;
    }

    public int getStrengthForAllFleets(CampaignPlayer c) {
        int palautus = 0;
        for (Fleet f : this.getFleets()) {
            if (f.owner != c) continue;
            palautus += f.getStrength();
        }
        return palautus;
    }

    public void checkPlanetFleetAmount() {
        for (CampaignPlayer c : this.getCampaignPlayers()) {
            if (c == this.none) continue;
            this.checkPlanetFleetAmount(c);
        }
    }

    public void checkPlanetFleetAmount(CampaignPlayer c) {
        double preferredNumberOfFleets = 10.0;
        TreeSet<Double> values = new TreeSet<Double>();
        int apu = this.getStrengthForAllFleets(c) / (this.getPlanets(c.nimi) + 1);
        for (Planet p : this.getPlanetsByOwner(c.nimi)) {
            preferredNumberOfFleets = 10.0;
            double apu2 = 1.0;
            for (Planet pl : this.getPlanets()) {
                if (pl.owner.nimi == "None" || pl.owner == p.owner) continue;
                apu2 *= 1.0 + 1.0 / Math.sqrt((p.getXx() - pl.getXx()) * (p.getXx() - pl.getXx()) + (p.getYy() - pl.getYy()) * (p.getYy() - pl.getYy()));
            }
            preferredNumberOfFleets = (apu2 - 1.0) * (double)apu * 10.0 + 10.0;
            values.add(new Double(preferredNumberOfFleets));
            p.setPreferredNumberOfFleets(preferredNumberOfFleets);
        }
        int laskuri = 0;
        int tt = 1;
        int kerroinlaskuri = 0;
        for (Double d : values) {
            ++laskuri;
            for (Planet p : this.getPlanetsByOwner(c.nimi)) {
                if (p.getPreferredNumberOfFleets() != d.doubleValue()) continue;
                p.preferredFleetFactorial = tt;
                kerroinlaskuri += tt;
            }
            if (!((float)laskuri >= (float)this.getPlanets(c.nimi) / 3.0f)) continue;
            laskuri = 0;
            ++tt;
        }
    }

    public void checkPlanetVisibility() {
        for (Planet p : this.getPlanets()) {
            if (p.owner.nimi == "Player1" || p.owner.nimi == "None") continue;
            p.setVisible(false);
            if (p.getFleetInOrbit() != null) {
                p.getFleetInOrbit().setVisible(false);
            }
            for (Planet pl : this.getPlanetsByOwner("Player1")) {
                if (pl.owner == p.owner || p.owner.nimi == "None" || !this.areTheyClose(p.getXx(), p.getYy(), pl.getXx(), pl.getYy(), pl.getRadarCoverage())) continue;
                p.setVisible(true);
                if (p.getFleetInOrbit() == null) continue;
                p.getFleetInOrbit().setVisible(true);
            }
        }
    }

    public double getDistance(float x1, float y1, float x2, float y2) {
        return Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
    }

    public void fillAndOrderPlanets(Planet p) {
        ArrayList<Planet> hjelp = new ArrayList<Planet>();
        block0: for (Planet pl : this.planets) {
            if (hjelp.size() == 0) {
                hjelp.add(pl);
                continue;
            }
            int j = 0;
            while (j < hjelp.size()) {
                if (this.getDistance(p.getXx(), p.getYy(), ((Planet)hjelp.get(j)).getXx(), ((Planet)hjelp.get(j)).getYy()) > this.getDistance(p.getXx(), p.getYy(), pl.getXx(), pl.getYy())) {
                    hjelp.add(j, pl);
                    continue block0;
                }
                if (j == hjelp.size() - 1) {
                    Planet swap = (Planet)hjelp.get(hjelp.size() - 1);
                    hjelp.add(j, pl);
                    hjelp.add(j, swap);
                    hjelp.remove(hjelp.size() - 1);
                    continue block0;
                }
                ++j;
            }
        }
        p.planetsClosestToDistant = hjelp;
    }

    public void Live() {
        if (this.pause || this.mode == "Campaign Won!" || this.mode == "Campaign Lost!") {
            return;
        }
        ++this.ticks;
        this.fleetInTransit = false;
        if (this.ticks > 100) {
            for (CampaignPlayer c : this.campaignPlayers) {
                c.Live();
            }
            this.ticks = 0;
        }
        for (Planet p : this.planets) {
            p.Live();
        }
        for (Fleet f : this.fleets) {
            if (f.inOrbit) continue;
            this.fleetInTransit = true;
            break;
        }
        int j = 0;
        while (j < this.fleets.size()) {
            Fleet f = this.fleets.get(j);
            if (f.strength == 0) {
                this.fleets.remove(j);
                --j;
            }
            f.liveIt();
            ++j;
        }
        this.playerLive();
        if (this.getPlanets("Player1") == 0) {
            this.mode = "Campaign Lost!";
        }
        if (this.getPlanets("Player1") + this.getPlanets("None") == this.planets.size()) {
            this.mode = "Campaign Won!";
            this.wonScenario = this.currentScenario;
            this.currentScenario = "";
        }
    }

    public String getWonScenario() {
        return this.wonScenario;
    }

    public boolean areTheyClose(float x1, float y1, float x2, float y2, float threshold) {
        float xerotus = x1 - x2;
        float yerotus = y1 - y2;
        if (xerotus > threshold || yerotus > threshold) {
            return false;
        }
        return (double)threshold > Math.sqrt(xerotus * xerotus + yerotus * yerotus);
    }

    public void togglePause() {
        this.pause = !this.pause;
    }

    public void initiateAttackMode(Fleet targ) {
        if (!this.p.isAlive() || targ.owner.nimi == "Player1") {
            return;
        }
        this.targetFleet = targ;
        this.mode = "Attack";
        if (targ.current != null) {
            this.setHomeBase(targ.current);
        }
        this.kentta.newGame("Campaign", targ.strength);
    }

    private void playerLive() {
        if (!this.p.isAlive()) {
            return;
        }
        if (this.targetFleet != null && this.engage) {
            if (this.areTheyClose(this.targetFleet.getXx(), this.targetFleet.getYy(), this.playerX, this.playerY, 1.0f)) {
                this.initiateAttackMode(this.targetFleet);
            } else {
                this.playerGetCloserTo(this.targetFleet.getXx(), this.targetFleet.getYy());
            }
        }
        if (this.targetLocation != null && this.engage) {
            if (this.areTheyClose(this.targetLocation.xx, this.targetLocation.yy, this.playerX, this.playerY, 1.0f)) {
                this.arriveAtTarget(this.targetLocation);
            } else {
                this.playerGetCloserTo(this.targetLocation.xx, this.targetLocation.yy);
            }
        }
        if (this.targetPlanet != null && this.engage) {
            if (this.areTheyClose(this.targetPlanet.getXx(), this.targetPlanet.getYy(), this.playerX, this.playerY, 1.0f) && !this.playerInOrbit) {
                this.playerInOrbit = true;
                this.setHomeBase(this.targetPlanet);
                this.playerX = this.targetPlanet.getXx();
                this.playerY = this.targetPlanet.getYy();
                this.engage = false;
                if (this.targetPlanet.getFleetInOrbit() != null && this.targetPlanet.getFleetInOrbit().owner.nimi != "Player1") {
                    this.initiateAttackMode(this.targetPlanet.getFleetInOrbit());
                }
                this.targetPlanet = null;
            } else {
                this.playerGetCloserTo(this.targetPlanet.getXx(), this.targetPlanet.getYy());
            }
        }
        if (this.playerInOrbit) {
            if (this.getHomeBase().isDepot()) {
                this.p.setAmountOfFuel(350.0f);
            }
            this.radius += 0.025;
            if (this.radius >= 6.28) {
                this.radius = 0.0;
            }
        }
    }

    private void arriveAtTarget(StellarLocation targetLocation2) {
        this.p.setLocation(targetLocation2);
        this.targetPlanet = this.getHomeBase();
        this.initiateSpecialMode();
        targetLocation2.setVisited(true);
    }

    public void initiateSpecialMode() {
        if (!this.p.isAlive()) {
            return;
        }
        this.kentta.newGame("Special", 1);
        this.mode = "Special";
    }

    public boolean isPlayerInOrbit() {
        return this.playerInOrbit;
    }

    private void playerGetCloserTo(float x, float y) {
        this.playerInOrbit = false;
        if (this.p.getAmountOfFuel() < 1.0f) {
            return;
        }
        double length = Math.sqrt((x - this.playerX) * (x - this.playerX) + (y - this.playerY) * (y - this.playerY));
        double unitX = (double)(x - this.playerX) / length;
        double unitY = (double)(y - this.playerY) / length;
        this.playerX = (float)((double)this.playerX + unitX * 1.0);
        this.playerY = (float)((double)this.playerY + unitY * 1.0);
        this.p.setAmountOfFuel(this.p.getAmountOfFuel() - (float)(unitX * unitX + unitY * unitY));
    }

    public ArrayList<Planet> getPlanets() {
        return this.planets;
    }

    public ArrayList<StellarLocation> getLocations() {
        return this.locations;
    }

    public Planet getPlayerOrbitingPlanet() {
        if (this.playerInOrbit) {
            return this.getHomeBase();
        }
        return null;
    }

    public void afterMath(boolean playerAlive, int remainingForce) {
        if (playerAlive) {
            this.mode = "Campaign";
            if (this.targetFleet != null) {
                this.targetFleet.strength = remainingForce;
                this.targetFleet = null;
                this.targetPlanet = this.homeBase;
                this.targetLocation = null;
            }
            if (this.targetLocation != null && remainingForce == 0) {
                this.targetLocation.setVisited(true);
                for (String s : this.p.getNewMedals()) {
                    if (s != "Testi") continue;
                    this.player1.neededResourcesForFactories = (int)((double)this.player1.neededResourcesForFactories * 0.95);
                }
                this.targetLocation = null;
            }
        } else {
            this.mode = "Game Over";
            this.targetPlanet = null;
            this.setHomeBase(null);
            if (this.targetFleet != null) {
                this.targetFleet.strength = remainingForce;
            }
            this.targetFleet = null;
        }
    }

    public void battleItOut(Fleet eka, Fleet toka, String souce) {
        int es = eka.getStrength();
        int ts = toka.getStrength();
        if (es > 0 && ts > 0) {
            if (this.r.nextInt(es + ts) < ts) {
                --es;
            } else {
                --ts;
            }
        }
        eka.strength = es;
        toka.strength = ts;
        if (es == 0 || ts == 0) {
            eka.setCurrentOrder(new Order("Done", null));
            toka.setCurrentOrder(new Order("Done", null));
            if (toka.current != null && toka.current.getFleetInOrbit() == toka && ts == 0) {
                toka.current.setFleetInOrbit(eka);
            }
            if (eka.current != null && eka.current.getFleetInOrbit() == eka && es == 0) {
                eka.current.setFleetInOrbit(toka);
            }
        }
    }

    public void setCurrentTarget(Fleet target) {
        this.targetFleet = target;
    }

    public void clickedCoordinates(int x, int y, boolean engage) {
        for (Fleet f : this.fleets) {
            if (!(f.getXx() - 10.0f < (float)x) || !(f.getXx() + 10.0f > (float)x) || !(f.getYy() - 10.0f < (float)y) || !(f.getYy() + 10.0f > (float)y) || !this.areTheyClose(f.getXx(), f.getYy(), this.playerX, this.playerY, this.p.getAmountOfFuel()) || f.owner.nimi == "Player1") continue;
            this.targetPlanet = null;
            this.targetLocation = null;
            this.setCurrentTarget(f);
            this.playerInOrbit = !engage;
            this.engage = engage;
            return;
        }
        for (Planet p : this.planets) {
            if (p.getXx() - 10 >= x || p.getXx() + 10 <= x || p.getYy() - 10 >= y || p.getYy() + 10 <= y || !this.areTheyClose(p.getXx(), p.getYy(), this.playerX, this.playerY, this.p.getAmountOfFuel())) continue;
            this.targetPlanet = p;
            this.targetFleet = null;
            this.targetLocation = null;
            this.playerInOrbit = !engage;
            this.engage = engage;
            return;
        }
        for (StellarLocation l : this.locations) {
            if (l.xx - 10 >= x || l.xx + 10 <= x || l.yy - 10 >= y || l.yy + 10 <= y || l.isVisited() || !this.areTheyClose(l.xx, l.yy, this.playerX, this.playerY, this.p.getAmountOfFuel())) continue;
            this.targetPlanet = null;
            this.targetFleet = null;
            this.targetLocation = l;
            this.playerInOrbit = !engage;
            this.engage = engage;
            return;
        }
    }

    public ArrayList<Fleet> getFleets() {
        return this.fleets;
    }

    public ArrayList<Planet> getPlanetsByOwner(String owner) {
        ArrayList<Planet> palautus = new ArrayList<Planet>();
        for (Planet p : this.planets) {
            if (!p.owner.nimi.matches(owner)) continue;
            palautus.add(p);
        }
        return palautus;
    }

    public Planet getPlanet(float xx, float yy) {
        for (Planet p : this.planets) {
            if (!this.areTheyClose(p.getXx(), p.getYy(), xx, yy, 1.0f)) continue;
            return p;
        }
        return null;
    }

    public void makeNewFleet(Planet current) {
        int apu = current.getFleetInOrbit().strength / (this.r.nextInt(3) + 2);
        current.getFleetInOrbit().strength -= apu;
        Fleet f = new Fleet(current, current.owner, this);
        f.strength = apu;
        f.number = this.getNextFleetNumber();
        f.setVisible(current.isVisible);
        this.fleets.add(f);
    }

    public ArrayList<Fleet> getOthersFleets(CampaignPlayer c) {
        ArrayList<Fleet> palautus = new ArrayList<Fleet>();
        for (Fleet f : this.fleets) {
            if (f.owner == c) continue;
            palautus.add(f);
        }
        return palautus;
    }

    public int getPlanetsWithShipyards(String string) {
        int palautus = 0;
        for (Planet p : this.getPlanetsByOwner(string)) {
            if (!p.isHasShipYard()) continue;
            ++palautus;
        }
        return palautus;
    }

    public Planet getHomeBase() {
        return this.homeBase;
    }

    public void setHomeBase(Planet homeBase) {
        this.homeBase = homeBase;
    }

    public ArrayList<CampaignPlayer> getCampaignPlayers() {
        return this.campaignPlayers;
    }

    public void setCampaignPlayers(ArrayList<CampaignPlayer> campaignPlayers) {
        this.campaignPlayers = campaignPlayers;
    }

    public void setScenario(String chosenOne) {
        this.currentScenario = chosenOne;
    }

    public void groundBattle(Fleet fleet, Planet subject) {
        int voima = subject.getPlanetaryDefences();
        if (voima > 0) {
            if (this.r.nextInt(voima) < fleet.strength) {
                subject.setPlanetaryDefences(--voima);
            }
        } else {
            fleet.setCurrentOrder(new Order("Colonize", subject));
        }
    }
}

