/*
 * Decompiled with CFR 0.152.
 */
package peli;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Scanner;
import peli.Gamestate;
import peli.Hiscoretable;
import peli.View;

public class Controller {
    protected static int xkoko;
    protected static int ykoko;
    protected static int zoomlevel;
    protected static Hiscoretable taulu;
    private static ObjectOutputStream obj_out;
    static int rivi;
    private static Gamestate stat;

    public static void main(String[] args) throws InterruptedException {
        System.setProperty("org.lwjgl.librarypath", new File("native").getAbsolutePath());
        System.out.println("Main Sequence Start: Confirmed");
        try {
            Scanner scanner = new Scanner(new FileReader("config.txt"));
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (!line.equals("Asetukset_alkaa")) continue;
                line = scanner.nextLine();
                while (!line.equals("Asetukset_loppuu")) {
                    Controller.processAsetukset(line);
                    line = scanner.nextLine();
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        System.out.println("Engine Running: Confirmed");
        Controller.readHiscoretable();
        Controller.readGamestate();
        View Naytto = new View(xkoko, ykoko, zoomlevel, taulu, stat);
        Naytto.start();
    }

    private static void readGamestate() {
        String gamestateFile = "gamestate";
        stat = new Gamestate(gamestateFile);
        try {
            FileInputStream f_in = new FileInputStream(gamestateFile);
            ObjectInputStream obj_in = new ObjectInputStream(f_in);
            Object obj = obj_in.readObject();
            if (obj instanceof ArrayList) {
                stat.setAchievements((ArrayList)obj);
            }
        }
        catch (FileNotFoundException obj_in) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        if (stat == null) {
            stat = new Gamestate(gamestateFile);
            try {
                FileOutputStream f_out = new FileOutputStream(gamestateFile);
                obj_out = new ObjectOutputStream(f_out);
                obj_out.writeObject(stat);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected static void processAsetukset(String s) {
        Scanner scanner = new Scanner(s);
        if (!s.matches(".*=.*")) {
            System.out.println("Rivi v\u00e4\u00e4r\u00e4ss\u00e4 muodossa:");
            System.out.println(s);
            return;
        }
        scanner.useDelimiter("=");
        String setting = scanner.next().trim();
        String settingValue = scanner.next().trim();
        if (setting.equals("xkoko")) {
            xkoko = Integer.parseInt(settingValue);
        }
        if (setting.equals("ykoko")) {
            ykoko = Integer.parseInt(settingValue);
        }
        if (setting.equals("zoomlevel")) {
            zoomlevel = Integer.parseInt(settingValue);
        }
    }

    protected static void readHiscoretable() {
        try {
            FileInputStream f_in = new FileInputStream("hiscoretable");
            ObjectInputStream obj_in = new ObjectInputStream(f_in);
            Object obj = obj_in.readObject();
            if (obj instanceof Hiscoretable) {
                taulu = (Hiscoretable)obj;
            }
        }
        catch (FileNotFoundException obj_in) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        if (taulu == null) {
            taulu = new Hiscoretable();
            try {
                FileOutputStream f_out = new FileOutputStream("hiscoretable");
                obj_out = new ObjectOutputStream(f_out);
                obj_out.writeObject(taulu);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

