/*
 * Decompiled with CFR 0.152.
 */
package peli;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Random;
import org.lwjgl.Sys;
import peli.Atom;
import peli.Brain;
import peli.Entity;
import peli.Idea;
import peli.Model;

public class Enemy
extends Entity {
    private Point destination;
    private int type;
    int shot_freq;
    Random rand;
    private boolean done;
    private Brain brain;
    Idea currentOrder;
    private int targeted;
    protected int points;
    boolean noDefaultWave;
    boolean indestructable;
    boolean isLocked;
    private Entity parent = null;
    public int parentIndex;
    int projectile;
    private float xVectorPlaceHolder;
    private float yVectorPlaceHolder;
    private boolean secondBoom = true;
    private ArrayList<Idea> previousOrders;
    private int parentOrderIndex = 0;
    private int extraIndex = 0;

    public void setParent(Entity e) {
        this.parent = e;
    }

    public void setBrain(Brain b) {
        this.brain = b;
    }

    public int getIntType() {
        return this.type;
    }

    Enemy(double x, double y, int timer, Model w, int type, boolean noDefWave, boolean lock) {
        this.setAlive(true);
        this.noDefaultWave = noDefWave;
        this.indestructable = false;
        this.targeted = 0;
        this.isLocked = false;
        this.deadlyToPlayer = true;
        this.deadlyToEnemies = false;
        this.willBeDrawn = false;
        this.checkCollisions = false;
        this.isBullet = false;
        this.rand = new Random();
        this.isLocked = lock;
        this.done = false;
        this.world = w;
        this.current = 0;
        this.xborder = w.getXsize();
        this.yborder = w.getYsize();
        this.state = "Dormant";
        this.currentOrder = new Idea();
        this.rand = new Random();
        this.timer = timer;
        this.type = type;
        ((Entity)this).type = "Enemy";
        this.previousOrders = new ArrayList();
        this.shot_freq = 9990;
        this.points = 30;
        this.speed = 0.5f;
        this.shields = 1000;
        this.explosionDelay = 0;
        this.middle = new Point((int)x, (int)y);
        this.xx = x;
        this.yy = y;
        this.delta = 0L;
        this.lastTime = Sys.getTime();
    }

    public int getTypeInt() {
        return this.type;
    }

    public void beingTargeted(int targettingIncrement) {
        if (this.targeted < 100) {
            this.targeted += targettingIncrement;
        }
        if (targettingIncrement == 0) {
            this.targeted = 101;
        }
    }

    public void releaseTarget() {
        this.targeted = 0;
    }

    public int getTargeted() {
        return this.targeted;
    }

    public void setType(int t) {
        this.type = t;
    }

    public Brain getBrain() {
        return this.brain;
    }

    public int getPoints() {
        return this.points;
    }

    public Point getDestination() {
        return this.destination;
    }

    public void setDestinationToMiddle() {
        this.destination = (Point)this.middle.clone();
    }

    public String getOrderType() {
        return this.currentOrder.type;
    }

    @Override
    public void Live() {
        this.delta = Sys.getTime() - this.lastTime;
        if (this.parent != null && this.parent.state.equals("Destroyed")) {
            this.shields = 0;
        }
        if (this.state == "Destroyed") {
            if (Sys.getTime() > this.explosionTime && this.secondBoom) {
                this.Explode();
                this.secondBoom = false;
                if (this.type != 33) {
                    this.world.playMusic();
                }
            }
            this.coolDown();
            this.disperseAtoms();
            return;
        }
        if (this.shields <= 0) {
            this.state = "About to be destroyed";
            this.checkCollisions = false;
            this.Explode();
            return;
        }
        if ((this.state == "Fading in" || this.state == "Waiting" || this.state == "Fading out" || this.state == "Dormant" || this.state == "Following" || this.state == "Shooting") && this.delta > this.timer) {
            this.done = true;
        }
        if (this.done) {
            this.done = false;
            if (this.currentOrder.type == "Explode") {
                this.state = "Destroyed";
                this.Explode();
                return;
            }
            this.willBeDrawn = true;
            this.checkCollisions = true;
            if (this.middle.y < 20 && this.currentOrder.type != "Move to first place") {
                this.currentOrder = new Idea("First move", new Point(0, 10));
            } else if (this.parent != null) {
                this.currentOrder = ((Enemy)this.parent).getOrder(this.parentOrderIndex);
                this.previousOrders.add(this.currentOrder.copyMe());
                ++this.parentOrderIndex;
            } else {
                this.currentOrder = this.brain.getNewOrder(0);
                this.previousOrders.add(this.currentOrder.copyMe());
            }
            this.randomSeed = this.brain.getRandomSeed();
            if (this.currentOrder.type == "Move to first place") {
                this.state = "Moving";
                this.destination.x = ((Point)this.currentOrder.value).x;
                this.destination.y = ((Point)this.currentOrder.value).y;
                this.refreshVectors();
            }
            if (this.currentOrder.type == "Change speed") {
                this.state = "Changing speed";
                this.speed = ((Float)this.currentOrder.value).floatValue();
                this.done = true;
            }
            if (this.currentOrder.type == "Shoot laser") {
                this.state = "Shooting";
                this.timer = 2000L;
                this.world.addEnemyBullet(this.middle.x, this.middle.y, 63452, this);
            }
            if (this.currentOrder.type == "Shoot missile") {
                this.state = "Shooting";
                this.timer = 20L;
                this.world.addEnemyBullet(this.middle.x, this.middle.y, 63352, this);
            }
            if (this.currentOrder.type == "First move" || this.currentOrder.type == "Move") {
                this.state = "Moving";
                this.destination.x = this.middle.x;
                this.destination.y = this.middle.y;
                this.destination.x += ((Point)this.currentOrder.value).x;
                this.destination.y += ((Point)this.currentOrder.value).y;
                this.refreshVectors();
            }
            if (this.currentOrder.type == "Stop") {
                this.state = "Stopped";
                this.destination.x = 0;
                this.destination.y = 0;
            }
            if (this.currentOrder.type == "Wait") {
                this.timer = ((Integer)this.currentOrder.value).intValue();
                this.state = "Waiting";
            }
            if (this.currentOrder.type == "Escape") {
                this.willBeDrawn = false;
                this.setAlive(false);
                this.world.levelNotClear = true;
            }
            if (this.currentOrder.type == "Follow player") {
                this.destination.x = this.world.getPlayer((int)1).middle.x;
                this.destination.y = this.world.getPlayer((int)1).middle.y;
                this.refreshVectors();
                this.state = "Following";
                this.timer = 5000L;
            }
            if (this.currentOrder.type == "Fade out" || this.currentOrder.type == "Fade in") {
                this.checkCollisions = false;
                this.timer = ((Integer)this.currentOrder.value).intValue();
                this.xUnitVector = this.xVector / this.length;
                this.yUnitVector = this.yVector / this.length;
                if (this.currentOrder.type == "Fade out") {
                    this.state = "Fading out";
                }
                if (this.currentOrder.type == "Fade in") {
                    this.state = "Fading in";
                }
            }
            this.lastTime = Sys.getTime();
            this.delta = 0L;
        }
        if (this.state == "Waiting" && this.delta > this.timer) {
            this.done = true;
        }
        if (this.isHit && this.delta > 50L) {
            this.isHit = false;
        }
        if (this.state == "Following") {
            this.moveIt();
        }
        if (this.state == "Fading in" || this.state == "Fading out") {
            super.moveIt();
        }
        if (this.state == "Moving" && !this.isHit) {
            this.moveIt();
            if (this.rand.nextInt(10000) > this.shot_freq && this.middle.x > 0 && this.middle.x < this.xborder) {
                this.world.addEnemyBullet(this.middle.x, this.middle.y, 1, this);
            }
            this.lastTime = Sys.getTime();
        }
    }

    private Idea getOrder(int parentOrderIndex2) {
        return this.previousOrders.get(parentOrderIndex2 - this.extraIndex);
    }

    private void disperseAtoms() {
        if (this.delta < (long)this.boom.timeToLive) {
            Atom[] atomArray = this.rep[this.current];
            int n = atomArray.length;
            int n2 = 0;
            while (n2 < n) {
                Atom a = atomArray[n2];
                a.x_coord += a.getXVector();
                a.y_coord += a.getYVector();
                if (Sys.getTime() < this.explosionTime) {
                    a.setXVector(a.getXVector() * (this.boom.getMassDampening() / 2.0f));
                    a.setYVector(a.getYVector() * (this.boom.getMassDampening() / 2.0f));
                } else {
                    a.setXVector(a.getXVector() * this.boom.getMassDampening());
                    a.setYVector(a.getYVector() * this.boom.getMassDampening());
                }
                ++n2;
            }
        } else {
            this.setAlive(false);
        }
    }

    public void refreshVectors() {
        this.xVector = this.destination.x - this.middle.x;
        this.yVector = this.destination.y - this.middle.y;
        this.length = (float)Math.sqrt(this.xVector * this.xVector + this.yVector * this.yVector);
        this.xUnitVector = this.xVector / this.length;
        this.yUnitVector = this.yVector / this.length;
    }

    @Override
    public void moveIt() {
        super.moveIt();
        if (this.middle.x >= this.xborder && this.xVector > 0.0f) {
            this.middle.x -= this.xborder;
            this.xx = this.middle.x;
            this.destination.x -= this.xborder;
        }
        if (this.middle.x <= 0 && this.xVector < 0.0f) {
            this.middle.x += this.xborder;
            this.xx = this.middle.x;
            this.destination.x += this.xborder;
        }
        if (this.middle.y >= this.yborder) {
            this.world.firstPassOnly = false;
            this.middle.y -= this.yborder;
            this.yy = this.middle.y;
            this.destination.y -= this.yborder;
        }
        if (this.destination.distance(this.xx, this.yy) < 2.0) {
            if ((double)this.middle.x == this.destination.getX() && (double)this.middle.y == this.destination.getY()) {
                this.done = true;
            } else {
                this.refreshVectors();
            }
        }
    }

    public boolean typeMatches(int t) {
        return t == this.type;
    }

    public void setPoints(int points2) {
        this.points = points2;
    }
}

