/*
 * Decompiled with CFR 0.152.
 */
package peli;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Random;
import org.lwjgl.Sys;
import peli.Atom;
import peli.Bullet;
import peli.Explosion;
import peli.Model;
import peli.Player;

public class Entity {
    protected Atom[][] rep;
    protected int[][] repInt;
    protected String type;
    protected float speed;
    protected int shields;
    private boolean alive;
    protected Point middle;
    protected long delta;
    protected long lastTime;
    protected int explosionDelay;
    protected float xVector;
    protected float yVector;
    protected String state;
    protected long timer;
    protected Explosion boom;
    protected float xUnitVector;
    protected float yUnitVector;
    protected float length;
    protected double xx;
    protected double yy;
    protected boolean hasFired;
    protected Model world;
    protected int xsize;
    protected int ysize;
    protected int zoomlevel;
    boolean deadlyToPlayer;
    boolean deadlyToEnemies;
    boolean willBeDrawn;
    boolean checkCollisions;
    boolean isBullet;
    boolean pause;
    boolean isHit;
    boolean middleShot = false;
    protected int xborder;
    protected int yborder;
    protected int current;
    public int boomDelayFactor;
    private long thisTime;
    public long explosionTime;
    protected int randomSeed;
    protected float explosionRadius;
    boolean increasesPowershots = false;

    Entity(ArrayList<ArrayList<Atom>> t) {
        this.setAlive(true);
        this.rep = new Atom[t.size()][t.get(0).size()];
        int p = 0;
        for (ArrayList<Atom> a : t) {
            a.toArray(this.rep[p]);
            ++p;
        }
        this.boom = new Explosion();
        this.isHit = false;
    }

    Entity() {
        this.setAlive(true);
        this.middle = new Point();
        this.willBeDrawn = true;
        this.boom = new Explosion();
    }

    public boolean didItHit(float x, float y) {
        int xxx = this.xsize + this.xsize;
        int yyy = this.ysize + this.ysize;
        Atom[] atomArray = this.rep[this.current];
        int n = atomArray.length;
        int n2 = 0;
        while (n2 < n) {
            Atom a = atomArray[n2];
            if (a.x_coord + (float)this.middle.x > (float)this.xsize) {
                xxx = (int)(a.x_coord + (float)this.middle.x - (float)this.xsize);
            }
            if (a.y_coord + (float)this.middle.y > (float)this.ysize) {
                yyy = (int)(a.y_coord + (float)this.middle.y - (float)this.ysize);
            }
            if (a.x_coord + (float)this.middle.x < 0.0f) {
                xxx = (int)(a.x_coord + (float)this.middle.x + (float)this.xsize);
            }
            if (a.y_coord + (float)this.middle.y < 0.0f) {
                yyy = (int)(a.y_coord + (float)this.middle.y + (float)this.ysize);
            }
            if ((float)xxx == x && (float)yyy == y) {
                return true;
            }
            if (a.x_coord + (float)this.middle.x == x && a.y_coord + (float)this.middle.y == y) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void youWereHit(Entity e, boolean firstHit) {
        if (firstHit && this.shields > 0) {
            int apu = e.shields;
            e.shields -= this.shields;
            this.shields -= apu;
        }
        if (this.shields < 0) {
            this.shields = 0;
        }
        this.isHit = true;
        if (this.isBullet) {
            if (this.type == "Drone") {
                this.shields = 1000;
                this.isHit = false;
            }
            if (this.type == "Missile1" || this.type == "Missile2") {
                this.shields = 0;
            }
            if (this.type == "Enemy Laser") {
                this.shields = 100;
            }
            if (this.shields <= 0) {
                if (this.increasesPowershots) {
                    ++((Player)((Bullet)this).originator).howManyHits;
                    ((Player)((Bullet)this).originator).addShot2Amount();
                }
                this.alive = false;
            }
        }
        if (e.middle.x == this.middle.x && e.isBullet && this.shields == 0) {
            this.middleShot = true;
        }
    }

    public void setFired() {
        this.hasFired = true;
    }

    public void togglePause() {
        if (this.pause) {
            this.pause = false;
            this.lastTime = Sys.getTime() - this.delta;
        } else {
            this.pause = true;
        }
    }

    public void Explode() {
        Random rand = new Random();
        if (this.boom == null) {
            System.out.println("Ou Nou!");
            Atom[] atomArray = this.rep[this.current];
            int n = atomArray.length;
            int n2 = 0;
            while (n2 < n) {
                Atom a = atomArray[n2];
                this.explosionRadius = rand.nextFloat() * 80.0f - 40.0f;
                a.setXVector(a.x_coord / this.explosionRadius);
                a.setYVector((a.y_coord + 1.0f) / this.explosionRadius);
                ++n2;
            }
        } else {
            Atom[] atomArray = this.rep[this.current];
            int n = atomArray.length;
            int n3 = 0;
            while (n3 < n) {
                Atom a = atomArray[n3];
                a.temperature = 3200 / (1 + (int)Math.sqrt(a.x_coord * a.x_coord + a.y_coord * a.y_coord));
                this.explosionRadius = rand.nextFloat() * (float)this.boom.randomFactorial + this.boom.staticFactorial;
                a.setXVector(a.x_coord / this.explosionRadius);
                a.setYVector(a.y_coord / this.explosionRadius);
                ++n3;
            }
        }
    }

    public void coolDown() {
        Atom[] atomArray = this.rep[this.current];
        int n = atomArray.length;
        int n2 = 0;
        while (n2 < n) {
            Atom a = atomArray[n2];
            if (a.temperature > 6) {
                a.temperature -= 5;
            }
            ++n2;
        }
    }

    public Atom[] getRep() {
        return this.rep[this.current];
    }

    public void setRep(Atom[][] a) {
        this.rep = a;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String s) {
        this.state = s;
    }

    public double getSpeed() {
        return this.speed;
    }

    public boolean isAlive() {
        return this.alive;
    }

    public void moveIt() {
        if (this.type == "Player1" || this.type == "Player2") {
            this.xx += (double)this.xVector;
            this.yy += (double)this.yVector;
        } else {
            this.xx += (double)(this.xUnitVector * this.speed);
            this.yy += (double)(this.yUnitVector * this.speed);
        }
        this.middle.setLocation(this.xx, this.yy);
    }

    public void Live() {
        if (!this.isAlive()) {
            return;
        }
        this.delta = Sys.getTime() - this.lastTime;
        if (this.delta > (long)this.boom.timeToLive && this.state == "Label") {
            this.state = "Destroyed";
            this.lastTime = Sys.getTime();
        }
        if (this.delta > (long)this.boom.timeToLive && this.state == "Destroyed") {
            this.alive = false;
        }
    }

    public int getShields() {
        return this.shields;
    }

    public String getType() {
        return this.type;
    }

    public long getTimer() {
        return this.timer;
    }

    public void setTimer(long l) {
        this.timer = l;
    }

    public void setAlive(boolean alive) {
        this.alive = alive;
    }

    public int getRandomSeed() {
        return this.randomSeed;
    }
}

