/*
 * Decompiled with CFR 0.152.
 */
package peli;

import campaign.Universe;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import peli.Achievement;
import peli.Model;

public class Gamestate
implements Serializable {
    private static final long serialVersionUID = 2283288071025319715L;
    private ArrayList<Achievement> achievements;
    private HashMap<String, Float> globalStatistics;
    private HashMap<String, Float> globalThresholds;
    private HashMap<String, Float> conditions;
    Model w;
    Universe m;
    private String nimi;
    private ObjectOutputStream obj_out;

    Gamestate(String nimi) {
        this.achievements = new ArrayList();
        this.prepareConditions();
        this.prepareAchievements();
        this.prepareStatistics();
        this.nimi = nimi;
    }

    public void setAchievements(ArrayList<Achievement> a) {
        this.achievements = a;
    }

    Gamestate(Model world, Universe maailma) {
        this.w = world;
        this.m = maailma;
        this.achievements = new ArrayList();
        this.prepareConditions();
        this.prepareAchievements();
        this.prepareStatistics();
    }

    private void prepareStatistics() {
        this.globalStatistics = new HashMap();
        this.globalThresholds = new HashMap();
        this.globalStatistics.put("Destroyed Enemies", Float.valueOf(0.0f));
        this.globalStatistics.put("Accuracy", Float.valueOf(0.0f));
        this.globalStatistics.put("Level reached", Float.valueOf(0.0f));
    }

    public void updateConditions() {
        this.conditions.put("Level", Float.valueOf(this.w.getLevel()));
        this.conditions.put("Bullseyes in one game", Float.valueOf(this.w.getNumberOfMiddleShotsInPlay()));
        if (this.m.getWonScenario() != "") {
            this.conditions.put(this.m.getWonScenario(), Float.valueOf(1.0f));
        }
        if (this.w.getPlayer(1) != null) {
            this.conditions.put("Accrued Powershots", Float.valueOf(this.w.getPlayer(1).getShot2Amount()));
        }
    }

    private void prepareConditions() {
        this.conditions = new HashMap();
        this.conditions.put("Start up", Float.valueOf(1.0f));
        this.conditions.put("Bullseyes in one game", Float.valueOf(0.0f));
        this.conditions.put("Level", Float.valueOf(0.0f));
        this.conditions.put("Scenario 1", Float.valueOf(0.0f));
        this.conditions.put("Accrued Powershots", Float.valueOf(0.0f));
        this.conditions.put("Total Accuracy", Float.valueOf(0.0f));
    }

    public void prepareAchievements() {
        HashMap<String, Float> b = new HashMap<String, Float>();
        b.put("Start up", Float.valueOf(1.0f));
        Achievement startGame = new Achievement("Start the Game", "Enemy 1 Unlocked!", "Unlocks enemy 1", b, "Unlock enemy", 1);
        if (!this.achievementExists(startGame)) {
            this.achievements.add(startGame);
        }
        b.put("Bullseyes in one game", Float.valueOf(20.0f));
        Achievement bullseyes = new Achievement("20 Bullseyes in one game", "Missiles Unlocked!", "Unlocks Missiles", b, "Unlock weapon", "Missile");
        if (!this.achievementExists(bullseyes)) {
            this.achievements.add(bullseyes);
        }
        b.clear();
        b.put("Level", Float.valueOf(2.0f));
        Achievement reachLevel2 = new Achievement("Reach level 2", "Nothing happened!", "Nothing happens!", b, "Unlock nothing", null);
        if (!this.achievementExists(reachLevel2)) {
            this.achievements.add(reachLevel2);
        }
        b.clear();
        b.put("Scenario 1", Float.valueOf(1.0f));
        Achievement scenario1 = new Achievement("Complete Scenario 1", "Drone unlocked!", "Unlocks Drone Weapon", b, "Unlock weapon", "Drone");
        if (!this.achievementExists(scenario1)) {
            this.achievements.add(scenario1);
        }
    }

    private boolean achievementExists(Achievement ach) {
        for (Achievement a : this.achievements) {
            if (!a.nimi.equals(ach.nimi)) continue;
            return true;
        }
        return false;
    }

    public boolean setCondition(String cond, float f) {
        if (this.conditions.containsKey(cond)) {
            this.conditions.put(cond, Float.valueOf(f));
            return true;
        }
        return false;
    }

    public void checkAllreadyAchievedAchievements() {
        for (Achievement a : this.achievements) {
            if (!a.achieved) continue;
            this.makeProperChanges(a);
        }
    }

    public ArrayList<String> checkForAchievements() {
        this.updateConditions();
        ArrayList<String> palautus = new ArrayList<String>();
        boolean wasAnythingChanged = false;
        for (Achievement a : this.achievements) {
            if (a.achieved || !this.checkConditions(a)) continue;
            this.makeProperChanges(a);
            a.achieved = true;
            wasAnythingChanged = true;
            palautus.add(a.nimi);
        }
        if (wasAnythingChanged) {
            this.save();
        }
        return palautus;
    }

    private void makeProperChanges(Achievement a) {
        if (a.typeOfChange.equals("Unlock enemy")) {
            this.w.unLockEnemy((Integer)a.valueOfChange);
        }
        if (a.typeOfChange.equals("Unlock enemy type")) {
            this.w.unLockEnemyType((String)a.valueOfChange);
        }
        if (a.typeOfChange.equals("Unlock weapon")) {
            if (((String)a.valueOfChange).contains("Missile")) {
                this.w.canHaveMissiles = true;
            }
            if (((String)a.valueOfChange).contains("Drone")) {
                this.w.canHaveDrone = true;
            }
        }
        a.typeOfChange.equals("Unlock option");
    }

    private void save() {
        try {
            FileOutputStream f_out = new FileOutputStream(this.nimi);
            this.obj_out = new ObjectOutputStream(f_out);
            this.obj_out.writeObject(this.achievements);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean checkAchievement(String s) {
        for (Achievement a : this.achievements) {
            if (!a.nimi.equals(s)) continue;
            return a.achieved;
        }
        return false;
    }

    private boolean checkConditions(Achievement a) {
        for (String s : a.conditions.keySet()) {
            if (this.conditions.containsKey(s) && Float.compare(this.conditions.get(s).floatValue(), a.conditions.get(s).floatValue()) >= 0) continue;
            return false;
        }
        return true;
    }

    public ArrayList<Achievement> getAchievements() {
        return this.achievements;
    }

    public void setWorldAndMaailma(Model world, Universe maailma) {
        this.w = world;
        this.m = maailma;
    }
}

