/*
 * Decompiled with CFR 0.152.
 */
package peli;

import java.awt.Point;
import peli.Atom;
import peli.Bullet;
import peli.Enemy;
import peli.Entity;
import peli.Model;
import peli.Player;

public class Missile
extends Bullet {
    private Entity target;
    private Player owner;
    private Model world;
    private int tick;

    Missile() {
    }

    Missile(Player p, Entity t, Model w) {
        System.out.println("Luodaan ohjusta!");
        this.type = "Missile1";
        this.shields = 4000;
        if (p.type.matches("Player2")) {
            this.type = "Missile2";
        }
        this.owner = p;
        this.originator = p;
        this.target = t;
        this.world = w;
        this.deadlyToEnemies = true;
        this.willBeDrawn = true;
        this.checkCollisions = true;
        this.isBullet = true;
        this.middle = new Point(p.middle.x, p.middle.y);
        this.state = "Moving";
        this.speed = 2.0f;
        this.tick = 0;
        this.xVector = this.target.middle.x - this.middle.x;
        this.yVector = this.target.middle.y - this.middle.y;
        this.xx = this.middle.x;
        this.yy = this.middle.y;
        this.length = (float)Math.sqrt(this.xVector * this.xVector + this.yVector * this.yVector);
        this.xUnitVector = this.xVector / this.length;
        this.yUnitVector = this.yVector / this.length;
        this.rep = new Atom[1][1];
        this.rep[0][0] = new Atom(0.0f, 0.0f, 4);
        this.rep[0][0].sparkle = true;
    }

    public Entity getTarget() {
        return this.target;
    }

    @Override
    public void Live() {
        if (!this.isAlive()) {
            if (!this.target.isAlive()) {
                ((Enemy)this.target).beingTargeted(-1);
            } else if (this.target != this.originator) {
                ((Enemy)this.target).releaseTarget();
            }
        }
        ++this.tick;
        if (this.tick > 1) {
            this.world.addToResidue(new Atom(this.middle.x, this.middle.y, 7, 0.0f, 0.0f, 1000));
            this.tick = 0;
        }
        if (this.target == null || this.target == this.owner || this.target.state == "Destroyed" || this.xUnitVector == 0.0f && this.yUnitVector == 0.0f) {
            this.target = this.world.pickTarget(this.owner);
            if (this.target == this.owner) {
                --this.owner.extraMissile;
            }
        }
        if (this.target == null) {
            this.target = this.owner;
            ++this.owner.extraMissile;
        }
        if (this.target != null) {
            this.xVector = this.target.middle.x - this.middle.x;
            this.yVector = this.target.middle.y - this.middle.y;
        }
        this.length = (float)Math.sqrt(this.xVector * this.xVector + this.yVector * this.yVector);
        if (this.length == 0.0f) {
            this.length = 1.0E-4f;
        }
        float xUnit = this.xVector / this.length;
        float yUnit = this.yVector / this.length;
        this.xUnitVector += xUnit / 2.0f;
        this.yUnitVector += yUnit / 2.0f;
        if (this.xUnitVector > this.speed) {
            this.xUnitVector = this.speed;
        }
        if (this.yUnitVector > this.speed) {
            this.yUnitVector = this.speed;
        }
        if (this.xUnitVector < -this.speed) {
            this.xUnitVector = -this.speed;
        }
        if (this.yUnitVector < -this.speed) {
            this.yUnitVector = -this.speed;
        }
        this.xx += (double)this.xUnitVector;
        this.yy += (double)this.yUnitVector;
        this.middle.setLocation(this.xx, this.yy);
    }
}

