/*
 * Decompiled with CFR 0.152.
 */
package peli;

import java.awt.Point;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import java.util.Scanner;
import org.lwjgl.Sys;
import org.newdawn.slick.opengl.Texture;
import org.newdawn.slick.opengl.TextureLoader;
import org.newdawn.slick.util.Log;
import org.newdawn.slick.util.ResourceLoader;
import peli.Atom;
import peli.Brain;
import peli.Bullet;
import peli.Enemy;
import peli.Entity;
import peli.Explosion;
import peli.Gamestate;
import peli.Idea;
import peli.Level;
import peli.Missile;
import peli.Music;
import peli.Player;
import peli.Wave;
import peli.Weapon;

public class Model {
    private ArrayList<ArrayList<Atom>> players;
    private ArrayList<ArrayList<Atom>> enemy;
    private ArrayList<Enemy> enemyBluePrints;
    private ArrayList<Bullet> bulletBluePrints;
    private ArrayList<Brain> brainBluePrints;
    private HashMap<Integer, Explosion> explosionBluePrints;
    private HashMap<Integer, Integer> entitiesAndExplosions;
    private ArrayList<Enemy> enemiesList;
    private ArrayList<Entity> additions;
    private ArrayList<Wave> waves;
    private Entity labelBullseye;
    private ArrayList<String> achievements;
    ArrayList<Entity> allEntities;
    private ArrayList<Atom> residue;
    private Player player1;
    private Player player2;
    private int numberOfEnemies;
    private int level = 0;
    private String state;
    private Level taso;
    private long lastTime;
    private long delta;
    long time;
    private int numberOfMiddleShotsInPlay = 0;
    private boolean entityEnd;
    private boolean waveEnd;
    private String mode;
    private Random rand;
    private String creature;
    int rivi;
    private int xsize;
    private int ysize;
    private int zoomlevel;
    private boolean pause;
    public boolean levelNotClear;
    private boolean hyperspacePrimed;
    private boolean hyperspaceConfirmed;
    private int hyperspaceTimer;
    double laskuri = 0.0;
    long deltat;
    private boolean waveBegin;
    private int waveMinLevel;
    private int waveInitialAmount;
    private float waveIncreaseAmount;
    private int waveSkipLevelsDivisable;
    private int waveMaxLevel;
    private float explosionMD;
    private int explosionflameMultiplier;
    private int explosionTemp;
    private int explosionMassMult;
    private int explosionRndFactorial;
    private int explosionintBetweenFlames;
    private int explosionTimeToLive;
    private int suurinX;
    private int suurinY;
    private ArrayList<Integer> waveXDiff;
    private ArrayList<Integer> waveYDiff;
    private ArrayList<Integer> waveParents;
    private Brain b;
    private Gamestate tila;
    private Explosion e;
    private int waveType;
    private boolean entityBegin;
    private ArrayList<Integer> waveEnemies;
    public boolean canHaveMissiles;
    private boolean brainBegin;
    private boolean brainEnd;
    private int brainType;
    private boolean noDefaultWave;
    private boolean explosionBegin;
    private boolean explosionEnd;
    private float explosionStcFactorial;
    private int explosionNumber;
    private int entityExplosion;
    private float entitySpeed;
    private int entityShields;
    private boolean bulletBegin;
    private boolean bulletEnd;
    private String bulletType;
    private boolean bulletDeadlyToEnemies;
    private boolean bulletDeadlyToPlayer;
    private int bulletShield;
    private float bulletSpeed;
    private Music musa;
    private ArrayList<ArrayList<Atom>> bulletRep;
    public boolean canHaveDrone;
    private boolean enemyLock;
    private int entityParent;
    private float bulletXVector;
    private Entity labelComponent;
    public boolean firstPassOnly;

    Model(int x, int y, int zoom, Gamestate gstate) {
        this.tila = gstate;
        this.canHaveMissiles = false;
        this.enemyBluePrints = new ArrayList();
        this.brainBluePrints = new ArrayList();
        this.enemiesList = new ArrayList();
        this.entityEnd = false;
        this.waveEnd = false;
        this.creature = new String();
        this.rand = new Random();
        this.pause = false;
        this.deltat = 0L;
        this.additions = new ArrayList();
        this.achievements = new ArrayList();
        this.allEntities = new ArrayList();
        this.residue = new ArrayList();
        this.waveEnemies = new ArrayList();
        this.waveParents = new ArrayList();
        this.explosionBluePrints = new HashMap();
        this.entitiesAndExplosions = new HashMap();
        this.labelBullseye = new Entity();
        this.xsize = x / zoom;
        this.ysize = y / zoom;
        this.zoomlevel = zoom;
        this.acquireAssets();
        this.checkNeedForDefaultWave();
        this.createStarfield();
        this.mode = new String();
        this.state = "Playing";
        this.lastTime = Sys.getTime();
        this.musa = new Music();
        this.musa.execute();
    }

    private void createStarfield() {
        int j = 0;
        while (j < 20) {
            this.addStarToResidue();
            ++j;
        }
    }

    public void playMusic() {
        this.musa.playMusic();
    }

    public void killMusic() {
        this.musa.killALData();
    }

    private void addStarToResidue() {
        float speed = this.rand.nextFloat();
        Atom a = new Atom(this.rand.nextInt(this.xsize), 0.0f, 99, 0.0f, speed / 2.0f, -1);
        byte c = (byte)(speed * 127.0f);
        a.color = new byte[]{c, c, c};
        this.residue.add(a);
    }

    public void checkNeedForDefaultWave() {
        ArrayList<Integer> enemiesWithWaves = new ArrayList<Integer>();
        int apu = 0;
        while (apu < this.enemyBluePrints.size()) {
            if (!this.enemyBluePrints.get((int)apu).noDefaultWave) {
                enemiesWithWaves.add(this.enemyBluePrints.get(apu).getIntType());
            }
            ++apu;
        }
        enemiesWithWaves.trimToSize();
        for (Wave w : this.waves) {
            int[] nArray = w.enemys;
            int n = w.enemys.length;
            int n2 = 0;
            while (n2 < n) {
                int t = nArray[n2];
                enemiesWithWaves.remove((Object)t);
                ++n2;
            }
        }
        if (enemiesWithWaves.size() > 0) {
            int[] k = new int[enemiesWithWaves.size()];
            int[] xDif = new int[enemiesWithWaves.size()];
            int[] yDif = new int[enemiesWithWaves.size()];
            int[] p = new int[1];
            int apu2 = 0;
            while (apu2 < enemiesWithWaves.size()) {
                k[apu2] = (Integer)enemiesWithWaves.get(apu2);
                ++apu2;
            }
            Wave defaultWave = new Wave(k, xDif, yDif, p, 1, 0, 6, 1.0f, 5, this, 0);
            this.waves.add(defaultWave);
        }
    }

    public ArrayList<Enemy> getEnemies() {
        return this.enemiesList;
    }

    public ArrayList<Atom> getResidue() {
        return this.residue;
    }

    public Atom[][] arrayListToArray(ArrayList<ArrayList<Atom>> ar) {
        Atom[][] palautus = new Atom[1][ar.get(0).size()];
        int j = 0;
        while (j < ar.size()) {
            int laskuri = 0;
            for (Atom a : ar.get(j)) {
                palautus[j][laskuri] = new Atom(a.x_coord, a.y_coord, a.material, a.color);
                ++laskuri;
            }
            ++j;
        }
        return palautus;
    }

    public int getLevel() {
        return this.level;
    }

    public Player getPlayer(int p) {
        if (p == 1) {
            return this.player1;
        }
        return this.player2;
    }

    public int getNumberOfEnemies() {
        return this.numberOfEnemies;
    }

    public void togglePause() {
        this.pause = !this.pause;
        for (Entity e : this.allEntities) {
            e.togglePause();
        }
    }

    public ArrayList<Entity> getAll() {
        return this.allEntities;
    }

    public String getMode() {
        return this.mode;
    }

    public void addToResidue(Atom a) {
        this.residue.add(a);
    }

    public void newGame(String mode, int str) {
        this.hyperspaceConfirmed = false;
        this.hyperspacePrimed = false;
        this.hyperspaceTimer = 500;
        this.mode = mode;
        this.pause = false;
        this.allEntities.clear();
        this.enemiesList.clear();
        this.additions.clear();
        this.level = 0;
        this.numberOfMiddleShotsInPlay = 0;
        this.taso = new Level(this.waves);
        if (mode == "Game" || mode == "twoPlayer") {
            this.player1 = this.createNewPlayer(1);
            this.player1.hasMissiles = this.canHaveMissiles;
            if (this.canHaveDrone) {
                this.createDrone(this.player1);
            }
        }
        if (mode == "Special") {
            this.enemiesList.addAll(this.taso.getSpecial(str));
            this.allEntities.addAll(this.enemiesList);
            this.numberOfEnemies = this.enemiesList.size();
        }
        if (mode == "ninjaMode") {
            this.player1 = this.createNewPlayer(2);
            if (this.canHaveDrone) {
                this.createDrone(this.player1);
            }
        }
        if (mode == "twoPlayer") {
            this.player2 = this.createNewPlayer(0);
            this.player2.hasMissiles = this.canHaveMissiles;
            if (this.canHaveDrone) {
                this.createDrone(this.player2);
            }
        }
        if (mode == "Campaign") {
            this.enemiesList.addAll(this.taso.getEnemiesAmount(str));
            this.allEntities.addAll(this.enemiesList);
            this.numberOfEnemies = str;
        }
        if (mode == "Game" || mode == "twoPlayer" || mode == "ninjaMode") {
            this.prepareNewLevel();
        }
        this.state = "Playing";
        this.lastTime = Sys.getTime();
    }

    public void addMassToExplosion(Entity e) {
        Random r = new Random();
        int massMplr = e.boom.getMassMultiplier();
        ArrayList<Atom[][]> atomit = new ArrayList<Atom[][]>();
        if (e.middleShot) {
            e.boom.flameMultiplier *= 5;
            e.boom.massMultiplier *= 2;
            e.boom.massDampening = (float)((double)e.boom.massDampening / 0.92);
            this.labelBullseye.middle.x = e.middle.x;
            this.labelBullseye.middle.y = e.middle.y;
            this.labelBullseye.state = "Label";
            this.labelBullseye.lastTime = Sys.getTime();
        }
        int k = 0;
        while (k < e.boom.flameMultiplier) {
            Atom[][] al = new Atom[1][e.getRep().length * massMplr];
            int laskuri = 0;
            int j = 0;
            while (j < massMplr) {
                Atom[] atomArray = e.rep[e.current];
                int n = atomArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Atom a = atomArray[n2];
                    al[0][laskuri] = new Atom(a.x_coord + r.nextFloat(), a.y_coord + r.nextFloat(), a.material, a.xVector, a.yVector, a.temperature);
                    if (r.nextInt(5) > 4) {
                        al[0][laskuri].sparkle = true;
                    }
                    ++laskuri;
                    ++n2;
                }
                ++j;
            }
            atomit.add(al);
            ++k;
        }
        int j = 0;
        while (j < e.boom.flameMultiplier) {
            Enemy addition = new Enemy(e.middle.x, e.middle.y, e.boom.intervalBetweenFlames * j, this, 33, true, false);
            addition.boom = e.boom.copyMe();
            addition.setRep((Atom[][])atomit.get(j));
            addition.Explode();
            addition.state = "Destroyed";
            addition.explosionTime = e.explosionTime;
            addition.currentOrder = new Idea("", null);
            addition.delta = e.delta;
            this.additions.add(addition);
            ++this.numberOfEnemies;
            ++j;
        }
        if (e.middleShot) {
            this.additions.add(this.copyEntity(this.labelBullseye));
        }
    }

    private Entity copyEntity(Entity e) {
        Entity palautus = new Entity();
        palautus.checkCollisions = e.checkCollisions;
        palautus.timer = e.timer;
        palautus.state = e.state;
        palautus.lastTime = e.lastTime;
        palautus.boom = e.boom;
        palautus.middle.x = e.middle.x;
        palautus.middle.y = e.middle.y;
        Atom[][] a = new Atom[1][e.getRep().length];
        int p = 0;
        while (p < e.getRep().length) {
            a[0][p] = e.getRep()[p];
            ++p;
        }
        palautus.setRep(a);
        return palautus;
    }

    public void decreaseEnemyCount() {
        --this.numberOfEnemies;
    }

    private void checkAchievements() {
        this.tila.checkForAchievements();
    }

    public void setPlayer(int p, Player pl) {
        if (p == 1) {
            this.player1 = pl;
        } else {
            this.player2 = pl;
        }
    }

    public void Live() {
        if (this.pause) {
            return;
        }
        this.delta = Sys.getTime() - this.lastTime;
        if (this.state == "Playing") {
            this.checkAllCollisions();
            this.checkResidue();
            for (Entity b : this.allEntities) {
                b.Live();
                if (b.state != "About to be destroyed") continue;
                b.explosionTime = this.musa.getExplosionDelay();
                this.addMassToExplosion(b);
                b.setState("Destroyed");
            }
            if (this.additions.size() > 0) {
                this.allEntities.addAll(0, this.additions);
                this.additions.clear();
            }
            this.lastTime = Sys.getTime();
        }
        if (this.hyperspacePrimed && !this.hyperspaceConfirmed) {
            --this.hyperspaceTimer;
            if (this.hyperspaceTimer < 0) {
                this.hyperspaceTimer = 500;
                this.hyperspacePrimed = false;
            }
        }
        if (this.hyperspaceConfirmed) {
            --this.hyperspaceTimer;
            if (this.hyperspaceTimer < 0) {
                this.hyperspaceTimer = 500;
                this.state = "Game Over";
            }
        }
        if (this.numberOfEnemies == 0 && this.state == "Playing") {
            this.state = "Level end";
            this.player1.checkForMedals(this.mode);
            if (this.mode.matches("twoPlayer")) {
                this.player2.checkForMedals(this.mode);
            }
            this.lastTime = Sys.getTime();
        }
        if (this.state == "Level end") {
            if (this.delta > 6000L) {
                if (this.mode == "Special") {
                    this.state = "Special Over";
                } else if (this.mode == "Campaign") {
                    this.state = "Campaign Over";
                } else {
                    this.prepareNewLevel();
                }
            } else {
                this.player1.Live();
                if (this.mode == "twoPlayer") {
                    this.player2.Live();
                }
            }
        }
        if (this.state == "Game Over") {
            if (this.mode == "Special") {
                this.state = "Special Over";
            }
            if (this.mode == "Campaign") {
                this.state = "Campaign Over";
            }
            if (this.hyperspaceConfirmed) {
                return;
            }
            if (this.player1.isAlive()) {
                this.state = "Playing";
            }
            if (this.mode == "twoPlayer" && this.player2.isAlive()) {
                this.state = "Playing";
            }
        }
    }

    private void checkResidue() {
        int p = 0;
        while (p < this.residue.size()) {
            Atom a = this.residue.get(p);
            a.x_coord += a.getXVector();
            a.y_coord += a.getYVector();
            if (a.temperature != -1) {
                if (a.temperature <= 0) {
                    this.residue.remove(p);
                    --p;
                } else {
                    a.temperature -= 10;
                }
            } else if (a.y_coord > (float)this.ysize) {
                this.residue.remove(p);
                --p;
                this.addStarToResidue();
            }
            ++p;
        }
    }

    private void prepareNewLevel() {
        this.enemiesList.clear();
        this.levelNotClear = false;
        this.state = "Playing";
        ++this.level;
        this.achievements.clear();
        this.achievements.addAll(this.tila.checkForAchievements());
        this.enemiesList.addAll(this.taso.getEnemies(this.level));
        this.enemiesList.ensureCapacity(this.enemiesList.size() + 10);
        this.numberOfEnemies = this.countEnemies();
        this.allEntities.addAll(this.enemiesList);
        this.allEntities.ensureCapacity(this.allEntities.size() + 20);
        this.lastTime = Sys.getTime();
        this.firstPassOnly = true;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String s) {
        this.state = s;
    }

    public void createDrone(Player p) {
        Atom[][] atoms = this.arrayListToArray(this.acquirePNGAssets("Assets/Official/drone.png"));
        Bullet drone = new Bullet("Drone", new Point(100, 100), this.player1);
        drone.setRep(atoms);
        drone.deadlyToPlayer = false;
        drone.deadlyToEnemies = true;
        drone.speed = 0.5f;
        drone.originator = p;
        drone.shields = 1000;
        drone.state = "Moving";
        drone.setAlive(true);
        this.allEntities.add(drone);
    }

    public void addEnemyBullet(int x, int y, int t, Entity orig) {
        if (t == 63452) {
            Bullet eb = new Bullet("Enemy Laser", new Point(0, 0), orig);
            this.additions.add(eb);
            return;
        }
        Bullet eb = null;
        eb = this.getCopyOfBullet(t, orig);
        if (eb != null) {
            Player p = this.choosePlayer();
            eb.setDestination(p.xx, p.yy);
            this.additions.add(eb);
        }
    }

    public Bullet getCopyOfBullet(int type, Entity orig) {
        Bullet eb = null;
        for (Bullet b : this.bulletBluePrints) {
            if (!b.type.contains(String.valueOf(type))) continue;
            eb = b.copyMe();
            eb.originator = orig;
        }
        return eb;
    }

    private Player choosePlayer() {
        if (this.player2 != null && this.delta % 2L == 0L && this.player2.isAlive()) {
            return this.player2;
        }
        return this.player1;
    }

    public void AddToAdditions(Entity e) {
        this.additions.add(e);
    }

    public void checkAllCollisions() {
        int k = 0;
        while (k < this.allEntities.size()) {
            Entity e = this.allEntities.get(k);
            if (!e.isAlive() && e.type != "Player1" && e.type != "Player2") {
                if (e.type == "Enemy" || e.type == "Havittaja") {
                    --this.numberOfEnemies;
                    this.enemiesList.remove(e);
                }
                if (e.type == "Missile1" || e.type == "Missile2") {
                    this.removeTargetStatus(e);
                }
                this.allEntities.remove(e);
                --k;
            } else {
                int j = k + 1;
                while (j < this.allEntities.size()) {
                    Entity ee = this.allEntities.get(j);
                    if (this.allIsWell(e, ee)) {
                        Atom[] atomArray = ee.getRep();
                        int n = atomArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Atom a = atomArray[n2];
                            if (a.material == 0) break;
                            if (e.didItHit(a.getX() + (float)ee.middle.x, a.getY() + (float)ee.middle.y)) {
                                this.createSparks(a.getX(), a.getY(), ee.middle);
                                if (e.middle.x == ee.middle.x && (e.isBullet || ee.isBullet)) {
                                    ++this.numberOfMiddleShotsInPlay;
                                }
                                e.youWereHit(ee, true);
                                ee.youWereHit(e, false);
                                if (e.shields <= 0 && ee.deadlyToEnemies && !e.isBullet) {
                                    if (ee.isBullet) {
                                        this.updatePoints(((Bullet)ee).getOriginator(), ((Enemy)e).points);
                                    } else {
                                        this.updatePoints(ee, ((Enemy)e).points);
                                    }
                                }
                                if (ee.shields > 0 || !e.deadlyToEnemies || ee.isBullet) break;
                                if (e.isBullet) {
                                    this.updatePoints(((Bullet)e).getOriginator(), ((Enemy)ee).points);
                                    break;
                                }
                                this.updatePoints(e, ((Enemy)ee).points);
                                break;
                            }
                            ++n2;
                        }
                    }
                    ++j;
                }
            }
            ++k;
        }
    }

    private void createSparks(float x, float y, Point middle) {
        int xx = 2;
        int yy = 2;
        if (x < 0.0f) {
            xx = -2;
        }
        if (y < 0.0f) {
            yy = -2;
        }
        int j = 0;
        while (j < 10) {
            this.addToResidue(new Atom((float)middle.x + x, (float)middle.y + y, 77, this.rand.nextFloat() / (float)xx, this.rand.nextFloat() / (float)yy, 1500));
            ++j;
        }
    }

    public int getNumberOfMiddleShotsInPlay() {
        return this.numberOfMiddleShotsInPlay;
    }

    public boolean closeEnough(int x, int y, int threshold) {
        return false;
    }

    public boolean allIsWell(Entity e, Entity ee) {
        if (!e.checkCollisions || !ee.checkCollisions) {
            return false;
        }
        if (e.state == "Destroyed" || e.state == "Dormant" || ee.state == "Destroyed" || ee.state == "Dormant") {
            return false;
        }
        if ((e.type.equals("Missile1") || e.type.equals("Missile2")) && ((Missile)e).getTarget() != ee) {
            return false;
        }
        if ((ee.type.equals("Missile1") || e.type.equals("Missile2")) && ((Missile)ee).getTarget() != e) {
            return false;
        }
        if (!(!(ee.xx - e.xx > 20.0 || ee.yy - e.yy > 20.0 || e.xx - ee.xx > 20.0) && !(e.yy - ee.yy > 20.0) || e.type == "Enemy Laser" || ee.type == "Enemy Laser" || ee.xx + 10.0 > (double)this.xsize || ee.xx - 10.0 < 0.0 || ee.yy + 10.0 > (double)this.ysize || ee.yy - 10.0 < 0.0 || e.xx + 10.0 > (double)this.xsize || e.xx - 10.0 < 0.0 || e.yy + 10.0 > (double)this.ysize || e.yy - 10.0 < 0.0)) {
            return false;
        }
        if (ee.deadlyToEnemies && e.deadlyToEnemies) {
            return false;
        }
        if (ee.deadlyToPlayer && e.deadlyToPlayer) {
            return false;
        }
        if (ee.isBullet && ee.deadlyToPlayer && e.isBullet && e.deadlyToEnemies && !ee.type.equals("Drone") && !e.type.equals("Drone")) {
            return false;
        }
        return !e.isBullet || !e.deadlyToPlayer || !ee.isBullet || !ee.deadlyToEnemies || ee.type.equals("Drone") || e.type.equals("Drone");
    }

    public int countEnemies() {
        int palautus = 0;
        for (Enemy e : this.enemiesList) {
            if (e.indestructable) continue;
            ++palautus;
        }
        return palautus;
    }

    public int getXsize() {
        return this.xsize;
    }

    public int getYsize() {
        return this.ysize;
    }

    public int getZoomLevel() {
        return this.zoomlevel;
    }

    private Entity acquireLabel(String nameOfLabel) {
        Entity palautus = new Entity();
        ArrayList<ArrayList<Atom>> aa = this.acquirePNGAssets(nameOfLabel);
        Atom[][] a = new Atom[1][aa.get(0).size()];
        int p = 0;
        while (p < aa.get(0).size()) {
            a[0][p] = aa.get(0).get(p);
            ++p;
        }
        palautus.setRep(a);
        palautus.checkCollisions = false;
        palautus.setState("Destroyed");
        palautus.boom.timeToLive = 3000;
        return palautus;
    }

    private void acquireAssets() {
        this.noDefaultWave = false;
        this.waves = new ArrayList();
        this.waveXDiff = new ArrayList();
        this.waveYDiff = new ArrayList();
        this.players = new ArrayList();
        this.bulletBluePrints = new ArrayList();
        this.enemy = new ArrayList();
        this.enemy.add(new ArrayList());
        this.acquireAssets("assets");
        this.labelBullseye = this.acquireLabel("Assets/Official/bullseye.png");
        this.labelComponent = this.acquireLabel("Assets/Official/component.png");
    }

    public void acquireAssets(String file) {
        try {
            Scanner scanner = new Scanner(new FileReader("Assets/Official/" + file));
            this.rivi = 0;
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (!line.equals("Assets begin")) continue;
                line = scanner.nextLine();
                while (!line.equals("Assets end")) {
                    Atom[][] a;
                    this.processAssets(line);
                    line = scanner.nextLine();
                    if (this.creature != "Player1" && this.entityEnd) {
                        a = new Atom[1][this.enemy.get(0).size()];
                        int p = 0;
                        while (p < this.enemy.get(0).size()) {
                            a[0][p] = this.enemy.get(0).get(p);
                            ++p;
                        }
                        Enemy e = new Enemy(0.0, 0.0, 0, this, Integer.parseInt(this.creature), this.noDefaultWave, this.enemyLock);
                        e.setRep(a);
                        if (this.entityParent != 0) {
                            e.parentIndex = this.entityParent;
                        }
                        e.speed = this.entitySpeed;
                        e.shields = this.entityShields;
                        this.enemyBluePrints.add(e);
                        this.entityEnd = false;
                        this.enemy.clear();
                        this.enemy.add(new ArrayList());
                    }
                    if (this.waveEnd) {
                        this.waveEnemies.trimToSize();
                        int[] e = new int[this.waveEnemies.size()];
                        int[] xDif = new int[this.waveEnemies.size() - 1];
                        int[] yDif = new int[this.waveEnemies.size() - 1];
                        int[] par = new int[this.waveParents.size()];
                        int p = 0;
                        while (p < this.waveEnemies.size()) {
                            e[p] = this.waveEnemies.get(p);
                            ++p;
                        }
                        p = 0;
                        while (p < this.waveEnemies.size() - 1) {
                            xDif[p] = this.waveXDiff.get(p);
                            ++p;
                        }
                        p = 0;
                        while (p < this.waveEnemies.size() - 1) {
                            yDif[p] = this.waveYDiff.get(p);
                            ++p;
                        }
                        p = 0;
                        while (p < this.waveParents.size()) {
                            par[p] = this.waveParents.get(p);
                            ++p;
                        }
                        this.waves.add(new Wave(e, xDif, yDif, par, this.waveMinLevel, this.waveMaxLevel, this.waveInitialAmount, this.waveIncreaseAmount, this.waveSkipLevelsDivisable, this, this.waveType));
                        this.waveEnd = false;
                    }
                    if (this.brainEnd) {
                        this.brainBluePrints.add(this.b);
                        this.brainEnd = false;
                    }
                    if (!this.bulletEnd) continue;
                    a = new Atom[1][this.bulletRep.get(0).size()];
                    int p = 0;
                    while (p < this.bulletRep.get(0).size()) {
                        a[0][p] = this.bulletRep.get(0).get(p);
                        ++p;
                    }
                    Bullet b = new Bullet(this.bulletType, this.bulletDeadlyToEnemies, this.bulletDeadlyToPlayer, this.bulletShield, this.bulletSpeed, a, null);
                    b.xVector = this.bulletXVector;
                    if (this.bulletType.equals("2")) {
                        b.increasesPowershots = true;
                    }
                    this.bulletBluePrints.add(b);
                }
                this.rivi = 0;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private Brain getBrain(int type) {
        for (Brain b : this.brainBluePrints) {
            if (b.enemyType != type) continue;
            return b.copyMe();
        }
        return new Brain(new Idea("First move", new Point(0, 100)));
    }

    public void processAssets(String s) {
        if (s.matches("^## Enemy.*") || s.matches("^## Player1.*")) {
            this.entityBegin = true;
            this.enemyLock = false;
            this.entityExplosion = 0;
            this.entitySpeed = 0.7f;
            this.entityParent = 0;
            this.entityShields = 1000;
            if (s.substring(3).matches("Player1")) {
                this.creature = "Player1";
            } else {
                this.creature = s.substring(9);
                this.rivi = 0;
                return;
            }
        }
        if (s.matches("^## Explosion.*")) {
            this.explosionMD = 0.85f;
            this.explosionflameMultiplier = 1;
            this.explosionTemp = 1;
            this.explosionMassMult = 3;
            this.explosionStcFactorial = 0.4f;
            this.explosionRndFactorial = 14;
            this.explosionintBetweenFlames = 50;
            this.explosionTimeToLive = 3000;
            this.explosionBegin = true;
            this.explosionNumber = Integer.parseInt(s.substring(13).trim());
            return;
        }
        if (s.matches("^## Wave.*")) {
            this.waveXDiff.clear();
            this.waveYDiff.clear();
            this.waveEnemies.clear();
            this.waveBegin = true;
            this.waveType = Integer.parseInt(s.substring(8));
            this.waveParents.clear();
            return;
        }
        if (s.matches("^## Brain.*")) {
            this.b = new Brain();
            this.brainBegin = true;
            return;
        }
        if (s.matches("^## Bullet.*")) {
            this.bulletDeadlyToEnemies = false;
            this.bulletDeadlyToPlayer = false;
            this.bulletRep = new ArrayList();
            this.bulletSpeed = 0.5f;
            this.bulletShield = 1000;
            this.bulletBegin = true;
            this.bulletEnd = false;
            this.bulletXVector = 0.0f;
            this.bulletType = s.substring(10).trim();
            return;
        }
        if (this.bulletBegin && s.matches("")) {
            this.bulletEnd = true;
            this.bulletBegin = false;
            return;
        }
        if (s.matches("Brain end")) {
            this.brainEnd = true;
            this.brainBegin = false;
            return;
        }
        if (this.entityBegin && s.matches("")) {
            this.entityEnd = true;
            this.entityBegin = false;
            if (this.creature != "Player1") {
                this.entitiesAndExplosions.put(Integer.parseInt(this.creature), this.entityExplosion);
            }
            return;
        }
        if (this.waveBegin && s.matches("")) {
            this.waveEnd = true;
            this.waveBegin = false;
            return;
        }
        if (this.explosionBegin && s.matches("")) {
            this.explosionEnd = true;
            this.explosionBegin = false;
            this.e = new Explosion(this.explosionMD, this.explosionTemp, this.explosionMassMult, this.explosionRndFactorial, this.explosionStcFactorial, this.explosionflameMultiplier, this.explosionintBetweenFlames, this.explosionTimeToLive);
            this.explosionBluePrints.put(this.explosionNumber, this.e);
        }
        if (this.bulletBegin) {
            if (s.matches(".*.png")) {
                this.bulletRep = this.acquirePNGAssets("Assets/Official/" + s);
            }
            if (s.matches(".*deadly to enemies.*")) {
                this.bulletDeadlyToEnemies = true;
            }
            if (s.matches(".*deadly to player.*")) {
                this.bulletDeadlyToPlayer = true;
            }
            if (s.matches("shields.*")) {
                this.bulletShield = Integer.parseInt(s.substring(9).trim());
            }
            if (s.matches("speed.*")) {
                this.bulletSpeed = Float.parseFloat(s.substring(7).trim());
            }
            if (s.matches("xdifference.*")) {
                this.bulletXVector = Float.parseFloat(s.substring(13).trim());
            }
        }
        if (this.brainBegin) {
            String[] apu;
            if (s.matches("enemy.*")) {
                this.b.enemyType = Integer.parseInt(s.substring(7).trim());
            }
            if (s.matches("Random.*")) {
                this.b.addOrder(new Idea("Random", null));
            }
            if (s.matches("First move.*")) {
                apu = s.substring(11).split(",");
                this.b.addOrder(new Idea("First move", new Point(Integer.parseInt(apu[0].trim()), Integer.parseInt(apu[1].trim()))));
            }
            if (s.matches("Move.*") && !s.matches("Move to first place.*")) {
                apu = s.substring(5).split(",");
                this.b.addOrder(new Idea("Move", new Point(Integer.parseInt(apu[0].trim()), Integer.parseInt(apu[1].trim()))));
            }
            if (s.matches("Move to first place.*")) {
                apu = s.substring(20).split(",");
                this.b.addOrder(new Idea("Move to first place", new Point(Integer.parseInt(apu[0].trim()), Integer.parseInt(apu[1].trim()))));
            }
            if (s.matches("Change speed.*")) {
                this.b.addOrder(new Idea("Change speed", Float.valueOf(Float.parseFloat(s.substring(13).trim()))));
            }
            if (s.matches("Shoot laser.*")) {
                this.b.addOrder(new Idea("Shoot laser", null));
            }
            if (s.matches("Shoot missile.*")) {
                this.b.addOrder(new Idea("Shoot missile", null));
            }
            if (s.matches("Follow player.*")) {
                this.b.addOrder(new Idea("Follow player", null));
            }
            if (s.matches("Fade in.*")) {
                this.b.addOrder(new Idea("Fade in", Integer.parseInt(s.substring(8).trim())));
            }
            if (s.matches("Wait.*")) {
                this.b.addOrder(new Idea("Wait", Integer.parseInt(s.substring(6))));
            }
            if (s.matches("Fade out.*")) {
                this.b.addOrder(new Idea("Fade out", Integer.parseInt(s.substring(9).trim())));
            }
            if (s.matches("Escape.*")) {
                this.b.addOrder(new Idea("Escape", null));
            }
            return;
        }
        if (this.waveBegin) {
            if (s.matches("enemies.*")) {
                this.waveEnemies.add(Integer.parseInt(s.substring(10).trim()));
                this.waveParents.add(new Integer(0));
            }
            if (s.matches("x difference.*")) {
                this.waveXDiff.add(Integer.parseInt(s.substring(15).trim()));
            }
            if (s.matches("y difference.*")) {
                this.waveYDiff.add(Integer.parseInt(s.substring(15).trim()));
            }
            if (this.waveXDiff.size() < this.waveEnemies.size() - 1) {
                this.waveXDiff.add(new Integer(0));
            }
            if (this.waveYDiff.size() < this.waveEnemies.size() - 1) {
                this.waveYDiff.add(new Integer(0));
            }
            if (s.matches("minLevel.*")) {
                this.waveMinLevel = Integer.parseInt(s.substring(11).trim());
            }
            if (s.matches("maxLevel.*")) {
                this.waveMaxLevel = Integer.parseInt(s.substring(11).trim());
            }
            if (s.matches("initialAmount.*")) {
                this.waveInitialAmount = Integer.parseInt(s.substring(16).trim());
            }
            if (s.matches("increaseAmount.*")) {
                this.waveIncreaseAmount = Float.parseFloat(s.substring(17).trim());
            }
            if (s.matches("skipLevelsDivisable.*")) {
                this.waveSkipLevelsDivisable = Integer.parseInt(s.substring(22));
            }
            if (s.matches("^parent.*")) {
                this.waveParents.set(this.waveParents.size() - 1, Integer.parseInt(s.substring(8).trim()));
            }
        }
        if (this.entityBegin) {
            if (s.matches(".*.png")) {
                this.enemy = this.acquirePNGAssets("Assets/Official/" + s);
            }
            if (s.matches("^locked.*")) {
                this.enemyLock = true;
            }
            if (s.matches("^explosion type.*")) {
                this.entityExplosion = Integer.parseInt(s.substring(16).trim());
            }
            if (s.matches("^no default wave.*")) {
                this.noDefaultWave = true;
            }
            if (s.matches("^speed.*")) {
                this.entitySpeed = Float.parseFloat(s.substring(7).trim());
            }
            if (s.matches("^shields.*")) {
                this.entityShields = Integer.parseInt(s.substring(9).trim());
            }
            if (s.matches("end")) {
                this.entityEnd = true;
            }
            if (this.creature == "Player1") {
                this.players = this.acquirePNGAssets("Assets/Official/player1.png");
            }
        }
        if (this.explosionBegin) {
            if (s.matches("^massDampening.*")) {
                this.explosionMD = Float.parseFloat(s.substring(15));
            }
            if (s.matches("^number of flames.*")) {
                this.explosionflameMultiplier = Integer.parseInt(s.substring(18).trim());
            }
            if (s.matches("^temperature.*")) {
                this.explosionTemp = Integer.parseInt(s.substring(13).trim());
            }
            if (s.matches("^mass multiplier.*")) {
                this.explosionMassMult = Integer.parseInt(s.substring(17).trim());
            }
            if (s.matches("^random factorial.*")) {
                this.explosionRndFactorial = Integer.parseInt(s.substring(18).trim());
            }
            if (s.matches("^static factorial.*")) {
                this.explosionStcFactorial = Float.parseFloat(s.substring(18).trim());
            }
            if (s.matches("^time between flames.*")) {
                this.explosionintBetweenFlames = Integer.parseInt(s.substring(22).trim());
            }
            if (s.matches("^time to live.*")) {
                this.explosionTimeToLive = Integer.parseInt(s.substring(14).trim());
            }
        }
    }

    private ArrayList<ArrayList<Atom>> acquirePNGAssets(String s) {
        ArrayList<ArrayList<Atom>> palautus = new ArrayList<ArrayList<Atom>>();
        ArrayList<Atom> atoms = new ArrayList<Atom>();
        try {
            Log.setVerbose(false);
            Texture texture = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream(s));
            byte[] b = texture.getTextureData();
            this.suurinX = 0;
            int x = 0;
            this.suurinY = 0;
            int y = 0;
            int p = 0;
            while (p < b.length) {
                if (y == texture.getImageHeight()) break;
                if (x == texture.getImageWidth()) {
                    p += (texture.getTextureWidth() - texture.getImageWidth()) * 4;
                    x = 0;
                    ++y;
                }
                ++x;
                int add = 128;
                int add2 = 128;
                if (p >= b.length) break;
                if (b[p] != 0) {
                    byte[] f = new byte[]{b[p] < 0 ? (byte)(b[p] + add2) : (byte)(b[p] - add), b[p + 1] < 0 ? (byte)(b[p + 1] + add2) : (byte)(b[p + 1] - add), b[p + 2] < 0 ? (byte)(b[p + 2] + add2) : (byte)(b[p + 2] - add)};
                    Atom a = new Atom(x, y, 1, f);
                    if (x > this.suurinX) {
                        this.suurinX = x;
                    }
                    if (y > this.suurinY) {
                        this.suurinY = y;
                    }
                    atoms.add(a);
                }
                p += 4;
            }
            if (this.suurinX % 2 == 0) {
                this.suurinX += 2;
            }
            if (this.suurinY % 2 == 0) {
                this.suurinY += 2;
            }
            if (this.suurinX % 2 != 0) {
                ++this.suurinX;
            }
            if (this.suurinY % 2 != 0) {
                ++this.suurinY;
            }
            for (Atom a : atoms) {
                a.x_coord -= (float)(this.suurinX / 2);
                a.y_coord -= (float)(this.suurinY / 2);
            }
            palautus.add(atoms);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return palautus;
    }

    public ArrayList<ArrayList<Atom>> copyArrayList(ArrayList<ArrayList<Atom>> al, int mode) {
        ArrayList<ArrayList<Atom>> palautus = new ArrayList<ArrayList<Atom>>();
        for (ArrayList<Atom> a : al) {
            ArrayList<Atom> apu = new ArrayList<Atom>();
            for (Atom am : a) {
                if (mode == 0) {
                    apu.add(new Atom((int)am.x_coord, (int)am.y_coord, 6, am.color));
                }
                if (mode == 2) {
                    apu.add(new Atom((int)am.x_coord, (int)am.y_coord, 1, am.color));
                }
                if (mode != 1) continue;
                apu.add(new Atom((int)am.x_coord, (int)am.y_coord, am.material, am.color));
            }
            palautus.add(apu);
        }
        return palautus;
    }

    public void updatePoints(Entity e, int points) {
        if (((Player)e).getPlayerInt() == 1) {
            this.player1.AddScore(points);
        } else {
            this.player2.AddScore(points);
        }
    }

    public Entity pickTarget(Player p) {
        for (Enemy e : this.getEnemies()) {
            if (e.state == "Destroyed" || e.getTargeted() != 100 || e.state == "Dormant") continue;
            e.beingTargeted(0);
            return e;
        }
        return null;
    }

    public int createMissile(Player player, int number) {
        int k = 0;
        while (k < number) {
            Entity e = this.pickTarget(player);
            if (e == null) {
                return k * 1000;
            }
            this.additions.add(new Missile(player, e, this));
            ++k;
        }
        return number * 1000;
    }

    public void removeTargetStatus(Entity entity) {
        if (((Missile)entity).getTarget().type != "Player1" && ((Missile)entity).getTarget().type != "Player2") {
            ((Enemy)((Missile)entity).getTarget()).releaseTarget();
        }
    }

    public Atom[] getEnemyRepresentation(int type) {
        for (Enemy e : this.enemyBluePrints) {
            if (!e.typeMatches(type)) continue;
            return e.getRep();
        }
        return null;
    }

    public Enemy getCopyOfEnemy(int t, int x, int y, int timer) {
        Enemy palautus = null;
        for (Enemy e : this.enemyBluePrints) {
            if (!e.typeMatches(t)) continue;
            int currentIndex = 0;
            int currentArray = 0;
            Atom[][] uusi = new Atom[e.rep.length][e.rep[0].length];
            Atom[][] atomArray = e.rep;
            int n = e.rep.length;
            int n2 = 0;
            while (n2 < n) {
                Atom[] aa;
                Atom[] atomArray2 = aa = atomArray[n2];
                int n3 = aa.length;
                int n4 = 0;
                while (n4 < n3) {
                    Atom a = atomArray2[n4];
                    uusi[currentIndex][currentArray] = new Atom(a.x_coord, a.y_coord, a.material, a.getColor());
                    ++currentArray;
                    ++n4;
                }
                currentArray = 0;
                ++currentIndex;
                ++n2;
            }
            palautus = new Enemy(x, y, timer, this, t, e.noDefaultWave, e.isLocked);
            palautus.boom = this.getExplosion(t);
            palautus.speed = e.speed;
            palautus.setBrain(this.getBrain(t));
            palautus.setRep(uusi);
            palautus.setPoints(e.getPoints());
            palautus.shields = e.shields;
            palautus.setDestinationToMiddle();
        }
        return palautus;
    }

    private Explosion getExplosion(int t) {
        int explosionType = this.entitiesAndExplosions.get(t);
        if (this.explosionBluePrints.get(explosionType) == null) {
            return new Explosion();
        }
        return this.explosionBluePrints.get(explosionType).copyMe();
    }

    public Player createNewPlayer(int i) {
        Player palautus = new Player(this.xsize / 2 - 20, this.ysize - 30, this, this.copyArrayList(this.players, 1), false);
        Bullet b1 = this.getCopyOfBullet(2, palautus);
        palautus.setWeapon(1, new Weapon(palautus, this, b1, -1, 4, true));
        Bullet b2 = this.getCopyOfBullet(3, palautus);
        palautus.setWeapon(2, new Weapon(palautus, this, b2, 50, 6, false));
        this.allEntities.add(palautus);
        return palautus;
    }

    public int[] getTypesOfEnemies() {
        int[] palautus = new int[this.enemyBluePrints.size()];
        int p = 0;
        for (Enemy e : this.enemyBluePrints) {
            palautus[p] = e.getTypeInt();
            ++p;
        }
        return palautus;
    }

    public ArrayList<String> getLevelEndInText() {
        ArrayList<String> palautus = new ArrayList<String>();
        if (this.mode == "Game" || this.mode == "twoPlayer") {
            if (this.delta < 3000L) {
                palautus.add("Level " + this.level + " Clear!");
            }
            if (this.delta >= 3000L) {
                palautus.add("Get Ready for level " + (this.level + 1) + "!");
            }
            palautus.add("");
            palautus.add(this.player1.endOfLevelText);
            for (String s : this.getPlayer(1).getNewMedals()) {
                palautus.add(s);
            }
            palautus.add("");
            palautus.add("");
            if (this.mode == "twoPlayer") {
                this.getPlayer(2).getNewMedals().isEmpty();
            }
        }
        if (this.achievements.size() > 0) {
            palautus.add("You even achieved something!");
            palautus.addAll(this.achievements);
        }
        if (this.mode == "Special") {
            palautus = this.player1.getLocation().getLocationEndText();
        }
        return palautus;
    }

    public ArrayList<String> infoText() {
        ArrayList<String> palautus = new ArrayList<String>();
        if (this.pause) {
            palautus.add("Paused");
        }
        if (this.hyperspaceConfirmed) {
            palautus.add("Hyperspace jump confirmed,");
            palautus.add("please, stand by :");
            palautus.add("" + this.hyperspaceTimer);
        }
        if (this.hyperspacePrimed && !this.hyperspaceConfirmed) {
            palautus.add("Please confirm jump to hyperspace.");
        }
        return palautus;
    }

    public void setHyperSpace() {
        if (this.hyperspacePrimed) {
            this.hyperspaceConfirmed = true;
        }
        if (!this.hyperspacePrimed) {
            this.hyperspacePrimed = true;
        }
    }

    public void unLockEnemy(int i) {
        for (Enemy e : this.enemyBluePrints) {
            if (e.getIntType() != i) continue;
            e.isLocked = false;
        }
    }

    public boolean isEnemyAvailable(int f) {
        for (Enemy e : this.enemyBluePrints) {
            if (e.getIntType() != f || !e.isLocked) continue;
            return false;
        }
        return true;
    }

    public ArrayList<ArrayList<Atom>> getPlayers() {
        return this.players;
    }

    public void unLockEnemyType(String string) {
        if (string.equals("Escort")) {
            this.unLockEnemy(99);
        }
    }
}

