/*
 * Decompiled with CFR 0.152.
 */
package peli;

import campaign.StellarLocation;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Random;
import org.lwjgl.Sys;
import peli.Atom;
import peli.Enemy;
import peli.Entity;
import peli.Incident;
import peli.Model;
import peli.Weapon;

public class Player
extends Entity {
    private boolean left;
    private boolean right;
    private boolean up;
    private boolean down;
    private boolean shot;
    private boolean shot2;
    private float amountOfFuel;
    boolean hasMissiles;
    public String endOfLevelText;
    protected boolean fire;
    protected int batteries;
    private Entity drone;
    private ArrayList<Incident> incidents = new ArrayList();
    private ArrayList<String> medals;
    private ArrayList<String> newMedals;
    private String medalString;
    private int numberOfWarheads;
    private int targettingSpeed;
    public int bulletSpeedFactor;
    private Weapon firstWeapon;
    private Weapon secondWeapon;
    int howManyFired;
    int howManyHits;
    private int shot2amount;
    private int thrusterRecharge;
    private int weaponRecharge;
    private boolean weaponCharge;
    private boolean thrusterCharge;
    private int shieldRecharge;
    private boolean tacticalDisplay;
    private StellarLocation location;
    private int score;
    private int ticks;
    private boolean missile;
    public int extraMissile;
    int acquiredTargets;
    public int incidentTimer = 128;
    private boolean start = true;
    private Incident shieldsLow;
    private Incident enemiesLow;
    private int shot1type = 2;
    private int shot2type = 3;
    private ArrayList<Integer> shots;
    private boolean dash;

    public void setWeapon(int n, Weapon w) {
        if (n == 1) {
            this.firstWeapon = w;
        }
        if (n == 2) {
            this.secondWeapon = w;
        }
    }

    public void setDrone(Entity d) {
        d = this.drone;
    }

    public Player(int x, int y, Model w, ArrayList<ArrayList<Atom>> t, boolean twoPlayer) {
        super(t);
        this.resetIncidentConditions();
        this.hasMissiles = false;
        this.extraMissile = 0;
        this.amountOfFuel = 350.0f;
        this.ticks = 0;
        this.current = 0;
        this.world = w;
        this.speed = 0.01f;
        this.xVector = 0.0f;
        this.yVector = 0.0f;
        this.targettingSpeed = 1;
        this.xsize = this.world.getXsize();
        this.ysize = this.world.getYsize();
        this.zoomlevel = this.world.getZoomLevel();
        this.xborder = this.xsize;
        this.yborder = this.ysize;
        this.shot2amount = 50;
        this.howManyHits = 0;
        this.howManyFired = 0;
        this.medals = new ArrayList();
        this.newMedals = new ArrayList();
        this.shots = new ArrayList();
        this.shots.add(this.shot1type);
        this.medalString = new String();
        this.bulletSpeedFactor = 10;
        this.tacticalDisplay = false;
        this.deadlyToPlayer = false;
        this.deadlyToEnemies = true;
        this.willBeDrawn = true;
        this.checkCollisions = true;
        this.isBullet = false;
        this.missile = false;
        this.middle = new Point(x, y);
        this.xx = x;
        this.yy = y;
        this.numberOfWarheads = 5000;
        this.type = !twoPlayer ? "Player1" : "Player2";
        this.lastTime = Sys.getTime();
        this.fire = true;
        this.batteries = 0;
        this.shields = 6000;
        this.thrusterCharge = false;
        this.weaponCharge = false;
        this.down = false;
        this.up = false;
        this.right = false;
        this.left = false;
        this.state = "Playing";
        this.thrusterRecharge = 2;
        this.weaponRecharge = 2;
    }

    private void resetIncidentConditions() {
        this.shieldsLow = new Incident("Shields Low! ");
        this.enemiesLow = new Incident("Threat level Low ");
        this.incidents.add(this.shieldsLow);
        this.incidents.add(this.enemiesLow);
    }

    public float getAmountOfFuel() {
        return this.amountOfFuel;
    }

    public void setAmountOfFuel(float amountOfFuel) {
        this.amountOfFuel = amountOfFuel;
    }

    public void setRight() {
        this.right = true;
    }

    public boolean getTacticalDisplay() {
        return this.tacticalDisplay;
    }

    public void flipTacticalDisplay() {
        this.tacticalDisplay = !this.tacticalDisplay;
    }

    public void setTacticalDisplay(boolean td) {
        this.tacticalDisplay = td;
        if (!td) {
            for (Enemy e : this.world.getEnemies()) {
                e.releaseTarget();
            }
        }
    }

    private void disperseAtoms() {
        if (this.delta < 5000L) {
            Random r = new Random();
            Atom[] atomArray = this.rep[this.current];
            int n = atomArray.length;
            int n2 = 0;
            while (n2 < n) {
                Atom a = atomArray[n2];
                if (r.nextBoolean()) {
                    a.setX(a.getX() + (float)r.nextInt(2));
                } else {
                    a.setX(a.getX() - (float)r.nextInt(2));
                }
                if (r.nextBoolean()) {
                    a.setY(a.getY() + (float)r.nextInt(2));
                } else {
                    a.setY(a.getY() - (float)r.nextInt(2));
                }
                ++n2;
            }
        } else {
            this.setAlive(false);
            this.world.setState("Game Over");
        }
    }

    @Override
    public void Live() {
        this.delta = Sys.getTime() - this.lastTime;
        if (!this.isAlive()) {
            return;
        }
        if (this.shields <= 0 && this.state == "Playing") {
            this.state = "About to be destroyed";
            return;
        }
        if (this.state == "Destroyed") {
            this.disperseAtoms();
            return;
        }
        this.checkIncidents();
        if (this.tacticalDisplay && this.hasMissiles) {
            this.acquiredTargets = 0;
            for (Enemy e : this.world.getEnemies()) {
                if (this.acquiredTargets >= this.numberOfWarheads / 1000 + this.extraMissile || !(e.yy > 0.0) || e.shields > 4000 || e.indestructable) continue;
                e.beingTargeted(this.targettingSpeed);
                if (e.getTargeted() < 100) break;
                ++this.acquiredTargets;
            }
        }
        if (this.isHit) {
            this.isHit = false;
        }
        if (this.missile) {
            this.numberOfWarheads -= this.world.createMissile(this, this.numberOfWarheads / 1000);
            this.missile = false;
        }
        if (this.left && this.xVector > -10.0f) {
            this.xVector -= this.speed * 2.0f;
        }
        if (this.right && this.xVector < 10.0f) {
            this.xVector += this.speed * 2.0f;
        }
        if (this.up && this.yVector > -10.0f) {
            this.yVector -= this.speed * 2.0f;
        }
        if (this.down && this.yVector < 10.0f) {
            this.yVector += this.speed * 2.0f;
        }
        if (!this.left && !this.right) {
            if (this.xVector > 0.0f) {
                this.xVector = (float)((double)this.xVector - (double)this.speed * 1.5);
                if ((double)this.xVector < 0.02) {
                    this.xVector = 0.0f;
                }
            }
            if (this.xVector < 0.0f) {
                this.xVector = (float)((double)this.xVector + (double)this.speed * 1.5);
                if ((double)this.xVector > -0.02) {
                    this.xVector = 0.0f;
                }
            }
        }
        if (!this.up && !this.down) {
            if (this.yVector > 0.0f) {
                this.yVector = (float)((double)this.yVector - (double)this.speed * 1.5);
                if ((double)this.yVector < 0.02) {
                    this.yVector = 0.0f;
                }
            }
            if (this.yVector < 0.0f) {
                this.yVector = (float)((double)this.yVector + (double)this.speed * 1.5);
                if ((double)this.yVector > -0.02) {
                    this.yVector = 0.0f;
                }
            }
        }
        this.down = false;
        this.up = false;
        this.right = false;
        this.left = false;
        this.Chargings();
        this.chargeBattery();
        super.moveIt();
        if (this.middle.getX() >= (double)this.xborder) {
            this.middle.x -= this.xborder;
            this.xx -= (double)this.xborder;
        }
        if (this.middle.getX() <= 0.0) {
            this.middle.x += this.xborder;
            this.xx += (double)this.xborder;
        }
        if (this.middle.getY() >= (double)this.yborder) {
            this.middle.y -= this.yborder;
            this.yy -= (double)this.yborder;
        }
        if (this.middle.getY() <= 0.0) {
            this.middle.y += this.yborder;
            this.yy += (double)this.yborder;
        }
        this.lastTime = Sys.getTime();
    }

    private void runStart() {
        if (this.delta > 500L) {
            this.delta = 0L;
            this.lastTime = Sys.getTime();
            if (this.ticks < 20) {
                this.state = "Fading in";
            }
        }
        if (this.ticks == 20) {
            this.start = false;
            this.state = "Playing";
        }
    }

    private void checkIncidents() {
        if (this.shields < 2000 && this.shieldsLow.incidentTimer > 1) {
            this.shieldsLow.incidentTimer /= 2;
        } else if (this.shields > 2000 && this.shieldsLow.incidentTimer < 128) {
            this.shieldsLow.incidentTimer *= 2;
        }
        if (this.world.getEnemies().size() < 5 && this.enemiesLow.incidentTimer > 1) {
            this.enemiesLow.incidentTimer /= 2;
        } else if (this.world.getEnemies().size() > 5 && this.enemiesLow.incidentTimer < 128) {
            this.enemiesLow.incidentTimer *= 2;
        }
    }

    public int getShieldRecharge() {
        return this.shieldRecharge;
    }

    @Override
    public double getSpeed() {
        return this.speed;
    }

    public void setShoot() {
        this.shot = true;
    }

    public int getWeaponRecharge() {
        return this.weaponRecharge;
    }

    public int thrusterRecharge() {
        return this.thrusterRecharge;
    }

    public void addShot2Amount() {
        this.secondWeapon.addToQuantity(0.5f);
    }

    public void chargeBattery() {
        if (this.hasMissiles) {
            ++this.numberOfWarheads;
        }
        if (this.batteries <= 30) {
            this.batteries += this.weaponRecharge;
        }
        if (this.shot) {
            if (this.firstWeapon.Shoot()) {
                ++this.howManyFired;
            }
            this.shot = false;
        }
        if (this.shot2) {
            this.secondWeapon.Shoot();
            this.shot2 = false;
        }
        this.shields += this.shieldRecharge;
        if (this.shields > 6000) {
            this.shields = 6000;
        }
        if (this.shields <= 2 && this.thrusterRecharge > 1) {
            this.thrusterRecharge = 1;
            this.shields = 1;
        }
    }

    public int getBatteries() {
        return this.batteries;
    }

    @Override
    public int getShields() {
        return this.shields;
    }

    public void emptyBatteries() {
        this.batteries = 0;
    }

    public void setUp() {
        this.up = true;
    }

    public void setShoot2() {
        this.shot2 = true;
    }

    public void setDown() {
        this.down = true;
    }

    public void setLeft() {
        this.left = true;
    }

    public int getShot2Amount() {
        return this.shot2amount;
    }

    public void Chargings() {
        if (this.weaponCharge) {
            this.firstWeapon.updateCurrentChargeLevel(1);
            this.secondWeapon.updateCurrentChargeLevel(1);
        }
        if (this.thrusterCharge) {
            ++this.thrusterRecharge;
        }
        if (this.thrusterRecharge > 3) {
            this.thrusterRecharge = 1;
        }
        this.shieldRecharge = 7 - (this.thrusterRecharge + this.firstWeapon.getCurrentChargeLevel() + this.secondWeapon.getCurrentChargeLevel());
        this.thrusterCharge = false;
        this.weaponCharge = false;
        if (this.thrusterRecharge == 1) {
            this.speed = 0.006f;
        }
        if (this.thrusterRecharge == 2) {
            this.speed = 0.014f;
        }
        if (this.thrusterRecharge == 3) {
            this.speed = 0.03f;
        }
        if (this.dash) {
            this.speed *= 2.0f;
            this.shieldRecharge -= 2;
        }
    }

    public void adjustWeaponCharge() {
        this.weaponCharge = true;
    }

    public void adjustThrusterCharge() {
        this.thrusterCharge = true;
    }

    public int getThrusterRecharge() {
        return this.thrusterRecharge;
    }

    public int getScore() {
        return this.score;
    }

    public void AddScore(int points) {
        this.score += points;
    }

    public int howManyMedals(String m) {
        int palautus = 0;
        for (String s : this.medals) {
            if (s != m) continue;
            ++palautus;
        }
        return palautus;
    }

    public void checkForMedals(String mode) {
        this.endOfLevelText = new String();
        this.newMedals.clear();
        if (mode == "Game" || mode == "twoPlayer") {
            if (this.howManyFired > 0) {
                if ((float)this.howManyHits / (float)this.howManyFired >= 0.9f && (float)this.howManyHits / (float)this.howManyFired <= 1.0f) {
                    this.AddMedal("Awesome Accuracy!");
                    this.firstWeapon.upgradeWeapon("Speed", 500);
                }
                if ((float)this.howManyHits / (float)this.howManyFired > 1.0f) {
                    this.AddMedal("Impossible Accuracy!");
                    this.firstWeapon.upgradeWeapon("Power", 500);
                }
            }
            if (this.world.firstPassOnly) {
                this.AddMedal("Quick Trigger Finger");
                this.firstWeapon.upgradeWeapon("Quantity", 1);
            }
            if (this.howManyMedals("Awesome Accuracy!") == 5) {
                while (this.medals.remove("Awesome Accuracy!")) {
                    this.medals.remove("Awesome Accuracy!");
                }
                while (this.newMedals.remove("Awesome Accuracy!")) {
                    this.newMedals.remove("Awesome Accuracy!");
                }
                this.AddMedal("Consistent Awesome Accuracy!");
                this.secondWeapon.upgradeWeapon("Speed", 500);
            }
            if (this.howManyMedals("Impossible Accuracy!") == 5) {
                while (this.medals.remove("Impossible Accuracy!")) {
                    this.medals.remove("Impossible Accuracy!");
                }
                while (this.newMedals.remove("Impossible Accuracy!")) {
                    this.newMedals.remove("Impossible Accuracy!");
                }
                this.AddMedal("Consistent Impossible Accuracy!");
                this.secondWeapon.upgradeWeapon("Power", 500);
            }
            if (this.howManyMedals("Quick Trigger Finger") == 5) {
                while (this.medals.remove("Quick Trigger Finger")) {
                    this.medals.remove("Quick Trigger Finger");
                }
                while (this.newMedals.remove("Quick Trigger Finger")) {
                    this.newMedals.remove("Quick Trigger Finger");
                }
                this.AddMedal("Consistent Quick Trigger Finger");
                this.secondWeapon.upgradeWeapon("Quantity", 1);
            }
            this.medalString = new String();
            for (String s : this.medals) {
                if (s == "Quick Trigger Finger") {
                    this.medalString = String.valueOf(this.medalString) + "&";
                }
                if (s == "Awesome Accuracy!") {
                    this.medalString = String.valueOf(this.medalString) + "!";
                }
                if (s == "Bonus Clearance") {
                    this.medalString = String.valueOf(this.medalString) + "#";
                }
                if (s == "Impossible Accuracy!") {
                    this.medalString = String.valueOf(this.medalString) + "$";
                }
                if (s == "Consistent Awesome Accuracy!") {
                    this.medalString = String.valueOf(this.medalString) + "+!";
                }
                if (s == "Consistent Impossible Accuracy!") {
                    this.medalString = String.valueOf(this.medalString) + "+$";
                }
                if (s != "Consistent Quick Trigger Finger") continue;
                this.medalString = String.valueOf(this.medalString) + "+&";
            }
            this.howManyHits = 0;
            this.howManyFired = 0;
        }
        if (mode == "Special") {
            this.AddMedal(this.location.getNimi());
        }
        if (this.newMedals.size() == 1) {
            this.endOfLevelText = String.valueOf(this.endOfLevelText) + "Congratulations, you have won a new medal!";
        }
        if (this.newMedals.size() > 1) {
            this.endOfLevelText = String.valueOf(this.endOfLevelText) + "Congratulations, you have won new medals!";
        }
    }

    private void AddMedal(String string) {
        this.newMedals.add(string);
        if (!this.medals.isEmpty()) {
            int k = 0;
            while (k < this.medals.size()) {
                if (this.medals.get(k) == string) {
                    this.medals.add(k, string);
                    return;
                }
                ++k;
            }
        }
        this.medals.add(string);
    }

    public ArrayList<String> getMedals() {
        return this.medals;
    }

    public String getMedalString() {
        return this.medalString;
    }

    public ArrayList<String> getMedalsDigest() {
        ArrayList<String> palautus = new ArrayList<String>();
        String pal = new String();
        if (this.medals.size() > 0) {
            String medal = this.medals.get(0);
            int k = 0;
            for (String s : this.medals) {
                if (s == medal) {
                    ++k;
                }
                if (s == medal) continue;
                pal = String.valueOf(medal) + " * " + k;
                palautus.add(pal);
                medal = s;
                k = 1;
            }
            pal = k > 1 ? String.valueOf(medal) + " * " + k : medal;
            palautus.add(pal);
        }
        return palautus;
    }

    public int getNumberOfWarheads() {
        return this.numberOfWarheads;
    }

    public ArrayList<String> getNewMedals() {
        return this.newMedals;
    }

    public void setShootMissile() {
        if (this.hasMissiles) {
            this.missile = true;
        }
    }

    public String getComponentMake(int i) {
        if (i == 1) {
            return "Reynham Industries Thrusters markII";
        }
        if (i == 2) {
            return "Weyland Inc. Twin Cannons";
        }
        if (i == 3) {
            return "Acme All Power Generator";
        }
        if (i == 4) {
            return "Punk Buster Howitzer";
        }
        return "No component";
    }

    public int getPlayerInt() {
        if (this.type == "Player1") {
            return 1;
        }
        return 2;
    }

    public int getTargettingSpeed() {
        return this.targettingSpeed;
    }

    public void setTargettingSpeed(int targettingSpeed) {
        this.targettingSpeed = targettingSpeed;
    }

    public StellarLocation getLocation() {
        return this.location;
    }

    public void setLocation(StellarLocation location) {
        this.location = location;
    }

    public String getShieldsInText() {
        String palautus = "Shld: " + this.shields / 60;
        return palautus;
    }

    public String getShot2AmountInText() {
        if (this.secondWeapon.getQuantity() > 1000.0f) {
            return "Powershots: >1k";
        }
        return "Powershots :" + (int)this.secondWeapon.getQuantity();
    }

    public String getWeaponRechargeInText() {
        if (this.firstWeapon.getCurrentChargeLevel() == 1) {
            return "Wpn: Low";
        }
        if (this.firstWeapon.getCurrentChargeLevel() == 2) {
            return "Wpn: Med";
        }
        if (this.firstWeapon.getCurrentChargeLevel() == 3) {
            return "Wpn: High";
        }
        return null;
    }

    public String getThrusterRechargeInText() {
        if (this.thrusterRecharge == 1) {
            return "Spd: Low";
        }
        if (this.thrusterRecharge == 2) {
            return "Spd: Med";
        }
        if (this.thrusterRecharge == 3) {
            return "Spd: High";
        }
        return null;
    }

    public String getNumberOfWarheadsinText() {
        if (this.hasMissiles) {
            return "Msl: " + this.numberOfWarheads / 1000;
        }
        return "";
    }

    public ArrayList<Incident> getIncidents() {
        return this.incidents;
    }

    public void setDash(boolean shift) {
        this.dash = shift;
    }

    public boolean getDash() {
        return this.dash;
    }
}

