/*
 * Decompiled with CFR 0.152.
 */
package peli;

import GUI.Boksi;
import GUI.DrawingTools;
import GUI.Dropdownmenu;
import GUI.arvoBoksi;
import campaign.CampaignPlayer;
import campaign.Fleet;
import campaign.Planet;
import campaign.Scenario;
import campaign.StellarLocation;
import campaign.Universe;
import java.awt.Font;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Random;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.Sys;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.PixelFormat;
import org.lwjgl.util.glu.GLU;
import org.newdawn.slick.Color;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.TrueTypeFont;
import org.newdawn.slick.util.Log;
import peli.Achievement;
import peli.Atom;
import peli.Enemy;
import peli.Entity;
import peli.Gamestate;
import peli.Hiscoretable;
import peli.Model;
import peli.Player;

public class View {
    private Model world;
    private TrueTypeFont font2;
    private TrueTypeFont font3;
    private TrueTypeFont font33;
    private TrueTypeFont font4;
    private TrueTypeFont font5;
    private boolean suljetaan;
    String views;
    String option;
    private Enemy malli;
    private int xsize;
    private int ysize;
    private int zoomlevel;
    private Hiscoretable taulu;
    private String nimi;
    boolean t;
    boolean changingOption;
    boolean klicka;
    private int achievementX = 50;
    private int achievementY = 150;
    private Universe maailma;
    private Planet current;
    private int currentPlanet;
    private Color tactDispl;
    private Color tactDispl2;
    private Boksi sc;
    private Boksi switchshowPlanetNames;
    private Boksi switchshowPlanetProduction;
    private Boksi switchshowPlanetSize;
    private Boksi switchResources;
    private ArrayList<String> campaignHelpText;
    private Dropdownmenu scenarios;
    private ArrayList<Scenario> skenaariot;
    private DrawingTools dt;
    private ArrayList<Boksi> boksit;
    private ArrayList<arvoBoksi> arvoBoksit;
    private arvoBoksi numberOfEnemies;
    private Image nonAchieved;
    private Image achieved;
    private Image bullseye;
    Achievement hoveringAchievement;
    private Optiot valinnat;
    private int vaoId = 0;
    private int vboId = 0;
    private int vbocId = 0;
    private int vertexCount = 0;
    private int indicesCount = 0;
    private int vboiId;
    private int fsId;
    private int pId;
    private float[] vertices;
    private float[] colors;
    int fps;
    private Random rand;
    private Player pl1;
    private Player pl2;
    private ArrayList<Player> players;
    Player pl;
    private boolean ninja;
    private boolean pl1hiscore;
    private boolean pl2hiscore;
    private int componentTimer;
    private Gamestate tila;
    ArrayList<String> tt;
    double laskuri = 0.0;
    long delta;
    boolean campaignStart = true;
    private boolean campaignHelp;
    private long dashTimer;

    View(int xkoko, int ykoko, int zoom, Hiscoretable tab, Gamestate stat) {
        this.taulu = tab;
        this.tila = stat;
        this.tactDispl = Color.gray;
        this.tactDispl2 = Color.gray;
        this.componentTimer = 128;
        this.changingOption = false;
        this.klicka = false;
        this.pl2hiscore = false;
        this.pl1hiscore = false;
        this.skenaariot = new ArrayList();
        this.boksit = new ArrayList();
        this.arvoBoksit = new ArrayList();
        this.valinnat = new Optiot(xkoko, ykoko);
        this.players = new ArrayList();
        this.ninja = false;
        this.zoomlevel = zoom;
        this.xsize = xkoko;
        this.ysize = ykoko;
        this.views = "Start";
        this.rand = new Random();
        int xboksi = xkoko / 3;
        this.dt = new DrawingTools(this.xsize);
        this.boksit.add(new Boksi("Start 1 player game", new Point(xboksi, ykoko / 100 * 65), new Point(xboksi * 2, ykoko / 100 * 69), "Start", "Game", this.dt));
        this.boksit.add(new Boksi("Start 2 player game", new Point(xboksi, ykoko / 100 * 70), new Point(xboksi * 2, ykoko / 100 * 74), "Start", "twoPlayer", this.dt));
        this.boksit.add(new Boksi("Achievements", new Point(xboksi / 2, ykoko / 100 * 65), new Point(xboksi - 6, ykoko / 100 * 69), "Start", "Achievements", this.dt));
        this.boksit.add(new Boksi("Campaign", new Point(xboksi, ykoko / 100 * 75), new Point(xboksi * 2, ykoko / 100 * 79), "Start", "Campaign options", this.dt));
        this.boksit.add(new Boksi("Help", new Point(xboksi, ykoko / 100 * 80), new Point(xboksi * 2, ykoko / 100 * 84), "Start", "Help", this.dt));
        this.boksit.add(new Boksi("Hiscore Table", new Point(xboksi, ykoko / 100 * 90), new Point(xboksi * 2, ykoko / 100 * 94), "Start", "Hiscoretable", this.dt));
        this.boksit.add(new Boksi("1PL Options", new Point(xboksi, ykoko / 100 * 95), new Point(xkoko / 2 - 3, ykoko / 100 * 99), "Start", "Options1", this.dt));
        this.boksit.add(new Boksi("2PL Options", new Point(xkoko / 2 + 3, ykoko / 100 * 95), new Point(xboksi * 2, ykoko / 100 * 99), "Start", "Options2", this.dt));
        this.sc = new Boksi("Start Campaign", new Point(xboksi, ykoko / 100 * 80), new Point(xboksi * 2, ykoko / 100 * 84), "Campaign options", "Campaign", this.dt);
        this.sc.setFrozen(true);
        this.boksit.add(this.sc);
        this.boksit.add(new Boksi("Back to Main Menu", new Point(xboksi, ykoko / 100 * 85), new Point(xboksi * 2, ykoko / 100 * 89), "Campaign options", "Start", this.dt));
        this.arvoBoksit.add(new arvoBoksi("Neutral Planets", "1", 0, -1, new Point(200, 200), new Point(150, 400), "Campaign options", this.dt, true));
        this.arvoBoksit.add(new arvoBoksi("Own Planets", "1", 1, -1, new Point(200, 230), new Point(150, 400), "Campaign options", this.dt, true));
        this.numberOfEnemies = new arvoBoksi("Number of enemies", "1", 1, 14, new Point(200, 260), new Point(250, 400), "Campaign options", this.dt, true);
        this.arvoBoksit.add(this.numberOfEnemies);
        this.boksit.add(new Boksi("Back", new Point(0, ykoko / 100 * 97), new Point(xboksi / 2, ykoko / 100 * 100), "Campaign", "Campaign options", this.dt));
        this.switchshowPlanetNames = new Boksi("Plt Names", new Point(xkoko - 70, ykoko / 100 * 95), new Point(xkoko, ykoko / 100 * 99), "Campaign", "", this.dt);
        this.switchshowPlanetNames.isToggle = true;
        this.boksit.add(this.switchshowPlanetNames);
        this.switchshowPlanetProduction = new Boksi("Prod", new Point(xkoko - 70, ykoko / 100 * 90), new Point(xkoko, ykoko / 100 * 94), "Campaign", "", this.dt);
        this.switchshowPlanetProduction.isToggle = true;
        this.boksit.add(this.switchshowPlanetProduction);
        this.switchshowPlanetSize = new Boksi("Plt Size", new Point(xkoko - 70, ykoko / 100 * 85), new Point(xkoko, ykoko / 100 * 89), "Campaign", "", this.dt);
        this.switchshowPlanetSize.isToggle = true;
        this.boksit.add(this.switchshowPlanetSize);
        this.switchResources = new Boksi("Show Rsc", new Point(xkoko - 70, ykoko / 100 * 80), new Point(xkoko, ykoko / 100 * 84), "Campaign", "", this.dt);
        this.switchResources.isToggle = true;
        this.boksit.add(this.switchResources);
        this.setupCampaignHelpText();
        this.boksit.add(new Boksi("Back to Main Menu", new Point(xboksi, ykoko / 100 * 85), new Point(xboksi * 2, ykoko / 100 * 89), "Achievements", "Start", this.dt));
        this.boksit.add(new Boksi("Back to Main Menu", new Point(xboksi, ykoko / 100 * 85), new Point(xboksi * 2, ykoko / 100 * 89), "Help", "Start", this.dt));
        this.boksit.add(new Boksi("Back to Main Menu", new Point(xboksi, ykoko / 100 * 85), new Point(xboksi * 2, ykoko / 100 * 89), "Hiscoretable", "Start", this.dt));
        this.boksit.add(new Boksi("Back to Main Menu", new Point(xboksi, ykoko / 100 * 85), new Point(xboksi * 2, ykoko / 100 * 89), "Options1", "Start", this.dt));
        this.boksit.add(new Boksi("Back to Main Menu", new Point(xboksi, ykoko / 100 * 85), new Point(xboksi * 2, ykoko / 100 * 89), "Options2", "Start", this.dt));
        this.suljetaan = false;
        this.nimi = new String();
        this.t = false;
        this.tt = new ArrayList();
    }

    private void setupCampaignHelpText() {
        this.campaignHelpText = new ArrayList();
        this.campaignHelpText.add("Welcome to the Goldwingu Campaign Mode!");
        this.campaignHelpText.add("Attack enemy fleets with your ship to give us a chance to build our own production capacity.");
        this.campaignHelpText.add("Click on a planet or an enemy fleet to attack it.");
        this.campaignHelpText.add("");
        this.campaignHelpText.add("Adjust GUI with buttons on the right hand bottom corner");
        this.campaignHelpText.add("Show Rsc: toggles showing whether the planet has a shipyard 'S' and/or fuel depot 'D',");
        this.campaignHelpText.add("and also number of planetary defences and the production value for the planet.");
        this.campaignHelpText.add("Plt Size: toggles the size of planets on screen.");
        this.campaignHelpText.add("Prod: toggles showing the production capability of the planet");
        this.campaignHelpText.add("Plt Names: toggles showing the planets names on screen.");
        this.campaignHelpText.add("");
        this.campaignHelpText.add("At the top right corner you can see some info on the players: ");
        this.campaignHelpText.add("Name of player: Total # of planets / # planets with a shipyard : Current mode : # of the ships in all fleets ");
        this.campaignHelpText.add("");
        this.campaignHelpText.add("Question marks on the screen represent locations that might offer benefits upon visiting them.");
        this.campaignHelpText.add("Also displayed on screen are the limits of players fueltanks for both one-way and two-trips. ");
    }

    public void changeColor(Atom a) {
        GL11.glColor3f(0.99f, 0.99f, 0.99f);
        switch (a.material) {
            case 1: {
                GL11.glColor3f(0.99f, 0.99f, 0.99f);
                break;
            }
            case 2: {
                GL11.glColor3f(0.99f, 0.54f, 0.0f);
                break;
            }
            case 3: {
                GL11.glColor3f(0.99f, 0.0f, 0.99f);
                break;
            }
            case 4: {
                GL11.glColor3f(0.99f, 0.99f, 0.0f);
                break;
            }
            case 5: {
                GL11.glColor3f(0.99f, 0.0f, 0.0f);
                break;
            }
            case 6: {
                GL11.glColor3f(0.2f, 0.2f, 0.2f);
                break;
            }
            case 7: {
                GL11.glColor3f(0.8f, 0.8f, 0.8f);
                break;
            }
            case 77: {
                float red = (float)this.rand.nextInt(8) / 10.0f;
                GL11.glColor3f(0.99f, red, 0.0f);
            }
        }
    }

    public void GLSetupForText() {
        GL11.glEnable(3042);
        GL11.glBlendFunc(770, 771);
    }

    public void drawJustifiedText(TrueTypeFont f, int y, String s, Color c) {
        f.drawString((this.xsize - f.getWidth(s)) / 2, y, s, c);
    }

    public void drawTextArray(TrueTypeFont f, ArrayList<String> ss, int x, int y, Color c, boolean justified) {
        GL11.glEnable(3042);
        GL11.glBlendFunc(770, 771);
        int j = 0;
        for (String k : ss) {
            ++j;
            if (justified) {
                this.drawJustifiedText(f, y + j * f.getHeight(), k, c);
                continue;
            }
            this.drawText(f, x, y + j * f.getHeight(), k, c);
        }
        GL11.glDisable(3042);
    }

    public void updateDeltaAndFPS() {
    }

    public void start() throws InterruptedException {
        try {
            PixelFormat pixelFormat = new PixelFormat();
            Display.setDisplayMode(new DisplayMode(this.xsize, this.ysize));
            Display.create(pixelFormat);
            Display.setTitle("Goldwingu!");
        }
        catch (LWJGLException e) {
            e.printStackTrace();
            System.exit(0);
        }
        try {
            Log.setVerbose(false);
            this.nonAchieved = new Image("notAchieved.png");
            this.achieved = new Image("achieved.png");
            this.bullseye = new Image("/Assets/Official/bullseye.png");
        }
        catch (SlickException e2) {
            e2.printStackTrace();
        }
        this.world = new Model(this.xsize - 200, this.ysize, this.zoomlevel, this.tila);
        this.maailma = new Universe(this.world);
        this.malli = this.world.getCopyOfEnemy(1, 0, 0, 0);
        this.tila.setWorldAndMaailma(this.world, this.maailma);
        this.tila.prepareAchievements();
        this.tila.checkAllreadyAchievedAchievements();
        this.tila.checkForAchievements();
        GL11.glDisable(2929);
        GL11.glMatrixMode(5889);
        GL11.glOrtho(0.0, this.xsize, this.ysize, 0.0, -1.0, 1.0);
        GL11.glMatrixMode(5888);
        GL11.glViewport(0, 0, this.xsize, this.ysize);
        GL11.glBlendFunc(770, 771);
        GL11.glPointSize(this.zoomlevel);
        this.prepareFonts();
        this.prepareScenarios();
        try {
            Keyboard.create();
        }
        catch (LWJGLException e1) {
            e1.printStackTrace();
        }
        this.delta = 0L;
        long lastTime = Sys.getTime();
        GL11.glTexParameteri(3553, 10240, 9728);
        GL11.glTexParameteri(3553, 10241, 9728);
        while (!Display.isCloseRequested() && !this.suljetaan) {
            this.delta = Sys.getTime() - lastTime;
            GL11.glClear(16384);
            if (this.views == "Help") {
                this.viewHelp();
            }
            if (this.views == "Start") {
                this.viewStart();
            }
            if (this.views == "Game Over") {
                this.viewGameOver(this.delta, lastTime);
            }
            if (this.views == "Hiscoretable") {
                this.viewHighscoretable();
            }
            if (this.views == "Achievements") {
                this.viewAchievements();
            }
            if (this.views == "Campaign options") {
                this.viewCampaignOptions();
            }
            if (this.views == "Options1" || this.views == "Options2") {
                this.viewOptions();
            }
            if (this.views == "Campaign") {
                if (this.delta < 1000L) {
                    this.laskuri += 1.0;
                } else {
                    lastTime = Sys.getTime();
                    this.fps = (int)this.laskuri;
                    this.laskuri = 0.0;
                }
                this.viewCampaign();
            }
            if (this.views == "Game" || this.views == "twoPlayer") {
                float alpha;
                if (this.delta < 1000L) {
                    this.laskuri += 1.0;
                } else {
                    lastTime = Sys.getTime();
                    this.fps = (int)this.laskuri;
                    this.laskuri = 0.0;
                }
                this.drawUI();
                GL11.glPointSize(3.0f);
                if (this.pl1.getTacticalDisplay() || this.pl2.getTacticalDisplay()) {
                    this.tactDispl = this.tacticalDisplayColor(this.pl1);
                    this.tactDispl2 = this.tacticalDisplayColor(this.pl2);
                }
                if (!this.world.getResidue().isEmpty()) {
                    GL11.glBegin(0);
                    for (Atom a : this.world.getResidue()) {
                        if (a.temperature != -1) {
                            alpha = (float)(a.temperature + 1) / 1500.0f;
                            GL11.glColor3f(0.99f, (float)a.temperature / 1500.0f, 0.0f);
                        } else {
                            GL11.glColor3b(a.getColor()[0], a.getColor()[1], a.getColor()[2]);
                        }
                        DrawingTools.drawPixel(a.x_coord * (float)this.zoomlevel + 0.5f, a.y_coord * (float)this.zoomlevel + 0.5f);
                    }
                    GL11.glEnd();
                }
                for (Entity e : this.world.getAll()) {
                    float y1;
                    float x1;
                    if (e.state == "Destroyed" || e.state == "Label") {
                        alpha = ((float)e.boom.timeToLive - (float)e.delta) / (float)e.boom.timeToLive;
                        GL11.glEnable(3042);
                        GL14.glBlendColor(0.0f, 0.0f, 0.0f, alpha);
                        GL11.glBlendFunc(32771, 32772);
                        GL11.glPointSize(3.0f);
                        GL11.glBegin(0);
                        Atom[] atomArray = e.getRep();
                        int n = atomArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Atom a = atomArray[n2];
                            if (a.sparkle) {
                                GL11.glColor3f(0.99f, this.rand.nextFloat(), 0.0f);
                            } else if (a.temperature > 1000) {
                                GL11.glColor3f(0.99f, 0.99f, (float)(a.temperature - 1000) / 1000.0f);
                            } else if (a.temperature >= 1 && a.temperature < 1000) {
                                GL11.glColor3f(0.99f, (float)a.temperature / 1000.0f, 0.0f);
                            } else {
                                GL11.glColor3f(0.99f, 0.99f, 0.99f);
                            }
                            x1 = (a.x_coord + (float)e.middle.x) * (float)this.zoomlevel;
                            y1 = (a.y_coord + (float)e.middle.y) * (float)this.zoomlevel;
                            DrawingTools.drawPixel(x1 + 0.5f, y1 + 0.5f);
                            ++n2;
                        }
                        GL11.glEnd();
                        GL11.glDisable(3042);
                        continue;
                    }
                    if (!e.willBeDrawn) continue;
                    if (e.state == "Fading in" || e.state == "Fading out") {
                        alpha = ((float)e.timer - (float)e.delta) / (float)e.timer;
                        if (e.state == "Fading in") {
                            alpha = 1.0f - alpha;
                        }
                        GL11.glEnable(3042);
                        GL14.glBlendColor(0.0f, 0.0f, 0.0f, alpha);
                        GL11.glBlendFunc(32771, 32772);
                    }
                    GL11.glBegin(0);
                    Atom[] atomArray = e.getRep();
                    int n = atomArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        Atom a = atomArray[n3];
                        if (e.isHit) {
                            GL11.glColor3f(0.99f, 0.0f, 0.0f);
                        } else if (e.type != "Enemy Laser") {
                            GL11.glColor3b(a.getColor()[0], a.getColor()[1], a.getColor()[2]);
                        } else {
                            this.changeColor(a);
                        }
                        float tx = (float)((double)a.x_coord + e.xx);
                        float ty = (float)((double)a.y_coord + e.yy);
                        x1 = tx * (float)this.zoomlevel;
                        y1 = ty * (float)this.zoomlevel;
                        if (tx > (float)this.world.getXsize()) {
                            x1 = (tx - (float)this.world.getXsize()) * (float)this.zoomlevel;
                        }
                        if (tx < 0.0f) {
                            x1 = (tx + (float)this.world.getXsize()) * (float)this.zoomlevel;
                        }
                        if (ty > (float)this.world.getYsize()) {
                            y1 = (ty - (float)this.world.getYsize()) * (float)this.zoomlevel;
                        }
                        if (ty < 0.0f) {
                            x1 = (ty + (float)this.world.getYsize()) * (float)this.zoomlevel;
                        }
                        DrawingTools.drawPixel(x1, y1 + 0.5f);
                        ++n3;
                    }
                    GL11.glEnd();
                    if (e.state != "Fading in" && e.state != "Fading out") continue;
                    GL11.glDisable(3042);
                }
                GL11.glDisable(3042);
                GL11.glEnd();
                this.world.Live();
                if (this.world.getState() == "Campaign Over" || this.world.getState() == "Special Over") {
                    this.views = "Campaign";
                    this.tila.checkForAchievements();
                    this.maailma.afterMath(this.world.getPlayer(1).isAlive(), this.world.getEnemies().size());
                }
                if (this.world.getState() == "Game Over") {
                    this.views = "Game Over";
                    this.pl1hiscore = this.taulu.checkScores(this.pl1.getScore());
                    this.pl2hiscore = this.taulu.checkScores(this.pl2.getScore());
                    lastTime = Sys.getTime();
                }
            }
            this.processKeyboard();
            this.processMouse();
            Display.update();
            Display.sync(60);
        }
        this.world.killMusic();
        this.destroyOpenGL();
        Display.destroy();
    }

    private void prepareScenarios() {
        this.skenaariot.clear();
        this.skenaariot.add(new Scenario(10, 1, 3, new int[]{2, 2, 2}, "It is the start of everything.", "Scenario 1"));
        this.skenaariot.add(new Scenario(10, 1, 1, new int[]{1}, "It is the end of everything.", "Make your own!"));
        this.scenarios = new Dropdownmenu(this.font2, 50, 170, 200, 182);
        for (Scenario s : this.skenaariot) {
            this.scenarios.addMenuChoice(s.getName(), true);
        }
    }

    private void prepareFonts() {
        Font awtFont = new Font("Times New Roman", 1, 44);
        TrueTypeFont font = new TrueTypeFont(awtFont, false);
        Font awtFont2 = new Font("Tahoma", 1, 12);
        this.font2 = new TrueTypeFont(awtFont2, false);
        Font awtFont3 = new Font("Tahoma", 0, 40);
        this.font3 = new TrueTypeFont(awtFont3, false);
        Font awtFont33 = new Font("Tahoma", 2, 30);
        this.font33 = new TrueTypeFont(awtFont33, false);
        Font awtFont4 = new Font("Tahoma", 1, 20);
        this.font4 = new TrueTypeFont(awtFont4, false);
        Font awtFont5 = new Font("Tahoma", 0, 10);
        this.font5 = new TrueTypeFont(awtFont5, false);
    }

    private void viewCampaignOptions() {
        GL11.glEnable(3042);
        this.drawJustifiedText(this.font3, 80, "Goldwingu2", Color.orange);
        this.drawJustifiedText(this.font33, 120, "Campaign Settings", Color.orange);
        this.drawJustifiedText(this.font2, 170, "(Press Tab during Campaign to view Help.)", Color.white);
        GL11.glDisable(3042);
        for (Scenario s : this.skenaariot) {
            if (s.getName() != this.scenarios.getChosenOne() || !this.scenarios.chosenOneWasChanged) continue;
            boolean truth = true;
            if (s.getName() == "Make your own!") {
                truth = false;
            }
            this.sc.setFrozen(false);
            this.arvoBoksit.clear();
            this.arvoBoksit.add(new arvoBoksi("Neutral Planets", String.valueOf(s.getNeutralPlanets()), 0, -1, new Point(200, 200), new Point(150, 400), "Campaign options", this.dt, truth));
            this.arvoBoksit.add(new arvoBoksi("Own Planets", String.valueOf(s.getOwnPlanets()), 1, -1, new Point(200, 230), new Point(150, 400), "Campaign options", this.dt, truth));
            this.numberOfEnemies = new arvoBoksi("Number of enemies", String.valueOf(s.getNumberOfEnemies()), 1, 14, new Point(200, 260), new Point(250, 400), "Campaign options", this.dt, truth);
            this.arvoBoksit.add(this.numberOfEnemies);
            this.scenarios.chosenOneWasChanged = false;
            this.processMouse();
        }
        this.drawStartUI();
    }

    public void checkAchievements() {
        for (String s : this.tila.checkForAchievements()) {
            System.out.println(s);
        }
    }

    private void viewAchievements() {
        GL11.glEnable(3042);
        this.drawJustifiedText(this.font3, 40, "Achievements", Color.orange);
        this.drawStartUI();
        int x = this.achievementX;
        int y = this.achievementY;
        for (Achievement a : this.tila.getAchievements()) {
            if (a.achieved) {
                this.achieved.draw(x, y);
            } else {
                this.nonAchieved.draw(x, y);
            }
            if (a == this.hoveringAchievement) {
                if (a.achieved) {
                    this.drawJustifiedText(this.font2, 15, this.hoveringAchievement.unlockedScreenText, Color.green);
                } else {
                    this.drawJustifiedText(this.font2, 15, this.hoveringAchievement.lockedScreenText, Color.green);
                }
                this.drawText(this.font2, x + 32 - this.font2.getWidth(this.hoveringAchievement.nimi) / 2, y + 65, this.hoveringAchievement.nimi, Color.gray);
            }
            if ((x += 70) <= 330) continue;
            y += 80;
            x = 50;
        }
        GL11.glDisable(3042);
    }

    private void viewOptions() {
        this.GLSetupForText();
        int j = 0;
        if (this.views == "Options1") {
            for (Optio o : this.valinnat.optiot) {
                if (this.option == null) {
                    this.option = "Push the key";
                }
                if (this.changingOption && o.box.highlight) {
                    if (this.valinnat.checkCollisions(this.option, 1)) {
                        this.drawText(this.font2, o.box.eka.x, o.box.eka.y, "Key already in use!", Color.red);
                    } else {
                        this.drawText(this.font2, o.box.eka.x, o.box.eka.y, this.option, Color.orange);
                    }
                } else {
                    this.drawBoxes(o.box);
                }
                this.drawBoxes(new Boksi(this.valinnat.optiot.get((int)j).name, new Point(o.box.eka.x - 300, o.box.eka.y), new Point(o.box.toka.x - 200, o.box.toka.y), "", "", this.dt));
                ++j;
            }
        }
        j = 0;
        if (this.views == "Options2") {
            for (Optio o : this.valinnat.twoploptiot) {
                if (this.option == null) {
                    this.option = "Push the key";
                }
                if (this.changingOption && o.box.highlight) {
                    if (this.valinnat.checkCollisions(this.option, 2)) {
                        this.drawText(this.font2, o.box.eka.x, o.box.eka.y, "Key already in use!", Color.red);
                    } else {
                        this.drawText(this.font2, o.box.eka.x, o.box.eka.y, this.option, Color.orange);
                    }
                } else {
                    this.drawBoxes(o.box);
                }
                this.drawBoxes(new Boksi(this.valinnat.twoploptiot.get((int)j).name, new Point(o.box.eka.x - 300, o.box.eka.y), new Point(o.box.toka.x - 200, o.box.toka.y), "", "", this.dt));
                ++j;
            }
        }
        GL11.glDisable(3042);
        this.drawStartUI();
    }

    private void viewCampaign() {
        this.maailma.Live();
        GL11.glColor3f(0.2f, 0.2f, 0.2f);
        GL11.glDisable(3042);
        GL11.glBlendFunc(770, 771);
        for (Planet p : this.maailma.getPlanets()) {
            int x1 = p.getXx();
            int y1 = p.getYy();
            if (p.getActualProduction() > 100) {
                this.changePlanetColor(p.getOwner(), true);
            } else {
                this.changePlanetColor(p.getOwner(), false);
            }
            if (this.switchshowPlanetSize.isOn) {
                DrawingTools.drawCircle(x1, y1, 20.0f);
            } else {
                DrawingTools.drawCircle(x1, y1, 10.0f);
            }
            GL11.glEnable(3042);
            if (this.maailma.getCampaignPlayers().get(1).getTargets().contains(p)) {
                this.drawCenterText(this.font5, x1, y1, "[   ]", Color.white);
            }
            if (!p.isSafe() && p.getOwner().nimi == "Player1") {
                this.drawCenterText(this.font5, x1, y1 - 20, "!", Color.red);
            }
            if (p.getOwner().nimi != "None" && p.isVisible()) {
                if (this.switchshowPlanetNames.isOn) {
                    this.drawCenterText(this.font5, x1, y1 - 20, p.getName(), Color.red);
                }
                if (this.switchshowPlanetProduction.isOn && p.getActualProductionInPercentage() != 100) {
                    this.drawCenterText(this.font5, x1, y1, "" + p.getActualProduction(), Color.white);
                }
                if (this.switchResources.isOn) {
                    if (p.isHasShipYard()) {
                        this.drawCenterText(this.font5, x1 - 15, y1 - 5, "S", Color.green);
                    }
                    if (p.isDepot()) {
                        this.drawCenterText(this.font5, x1 - 15, y1 + 5, "D", Color.green);
                    }
                    this.drawText(this.font5, x1 + 35, y1 - 10, "Def:" + p.getPlanetaryDefences(), Color.white);
                    this.drawText(this.font5, x1 + 35, y1, "Val:" + (int)p.getProductionPotential(), Color.white);
                }
                this.drawCenterText(this.font5, x1, y1 + 25, p.getCurrentProduction(), Color.white);
            }
            GL11.glDisable(3042);
        }
        GL11.glPointSize(1.0f);
        if (this.maailma.mode == "Campaign Won!" || this.maailma.mode == "Campaign Lost!" || this.maailma.mode == "Game Over") {
            GL11.glEnable(3042);
            String s = "You Win!";
            if (this.maailma.mode == "Campaign Lost!") {
                s = "You Lose!";
            }
            if (this.maailma.mode == "Game Over") {
                s = "You're Dead!";
            }
            this.drawCenterText(this.font3, this.xsize / 2, this.ysize / 2 + 200, s, Color.orange);
            this.tila.checkForAchievements();
            GL11.glDisable(3042);
        }
        if (this.maailma.getMode() != "Game Over" && this.maailma.getPlayer().isAlive()) {
            float playerY;
            float playerX;
            if (this.maailma.isPlayerInOrbit()) {
                playerX = (float)((double)this.maailma.getHomeBase().getXx() + 25.0 * Math.sin(this.maailma.getRadius()));
                playerY = (float)((double)this.maailma.getHomeBase().getYy() + 25.0 * Math.cos(this.maailma.getRadius()));
            } else {
                playerX = this.maailma.playerX;
                playerY = this.maailma.playerY;
            }
            GL11.glPointSize(1.0f);
            GL11.glBegin(0);
            double kerroin = 0.09773555555555556;
            int t = 0;
            while (t < 360) {
                double angle = kerroin * (double)t;
                double mc = Math.cos(angle);
                double ms = Math.sin(angle);
                double x = mc * (double)this.maailma.getPlayer().getAmountOfFuel() + (double)this.maailma.playerX;
                double y = ms * (double)this.maailma.getPlayer().getAmountOfFuel() + (double)this.maailma.playerY;
                double x2 = mc * (double)this.maailma.getPlayer().getAmountOfFuel() / 2.0 + (double)this.maailma.playerX;
                double y2 = ms * (double)this.maailma.getPlayer().getAmountOfFuel() / 2.0 + (double)this.maailma.playerY;
                if (x < (double)(this.xsize - 200) && y < (double)(this.xsize - 200)) {
                    GL11.glColor3f(0.99f, 0.0f, 0.99f);
                    GL11.glVertex2d(x, y);
                }
                if (x2 < (double)(this.xsize - 200) && y2 < (double)(this.xsize - 200)) {
                    GL11.glColor3f(0.99f, 0.99f, 0.0f);
                    GL11.glVertex2d(x2, y2);
                }
                ++t;
            }
            Atom[] atomArray = this.maailma.getPlayer().getRep();
            int n = atomArray.length;
            int n2 = 0;
            while (n2 < n) {
                Atom a = atomArray[n2];
                this.changeColor(a);
                GL11.glVertex2f(playerX + a.x_coord + 0.5f, playerY + a.y_coord + 0.5f);
                ++n2;
            }
            GL11.glEnd();
        }
        for (StellarLocation l : this.maailma.getLocations()) {
            GL11.glColor3f(0.5f, 0.5f, 0.5f);
            DrawingTools.drawCircle(l.xx, l.yy, 10.0f);
            GL11.glEnable(3042);
            if (!l.isVisited()) {
                this.drawCenterText(this.font5, l.xx, l.yy, "?", Color.white);
            } else {
                this.drawCenterText(this.font5, l.xx, l.yy, "X", Color.red);
            }
            GL11.glDisable(3042);
        }
        int jp = 620;
        GL11.glPointSize(1.0f);
        for (Fleet f : this.maailma.getFleets()) {
            if (!f.isVisible()) continue;
            int x1 = (int)f.getXx();
            int y1 = (int)f.getYy();
            if (f.owner.nimi != "Player1" && f.current == null) {
                GL11.glBegin(0);
                GL11.glColor3f(0.99f, 0.99f, 0.99f);
                Atom[] atomArray = this.malli.getRep();
                int n = atomArray.length;
                int n3 = 0;
                while (n3 < n) {
                    Atom a = atomArray[n3];
                    GL11.glVertex2f((float)x1 + a.x_coord + 0.5f, (float)y1 + a.y_coord + 0.5f);
                    GL11.glVertex2f((float)x1 + 0.5f, (float)y1 + 0.5f);
                    ++n3;
                }
                GL11.glEnd();
            }
            GL11.glEnable(3042);
            if (f.getCurrentOrder().getOrder() == "Attack fleet") {
                this.drawText(this.font2, x1, y1 - 20, "!", Color.red);
            }
            this.drawText(this.font5, x1 + 12, y1 - this.font5.getHeight() / 2, "" + f.strength, Color.white);
            if (f.owner.nimi == "Player1" && f.current == null) {
                this.drawText(this.font2, x1 - this.font2.getWidth("@") / 2, y1 - this.font2.getHeight() / 2, "@", Color.green);
            }
            GL11.glDisable(3042);
        }
        jp = 0;
        GL11.glEnable(3042);
        for (CampaignPlayer c : this.maailma.getCampaignPlayers()) {
            if (c.nimi == "None") {
                this.drawText(this.font5, 600.0f, 100 + jp, "Neutral: " + this.maailma.getPlanets("None"), Color.white);
            } else if (this.maailma.getPlanets(c.nimi) > 0) {
                this.drawText(this.font5, 600.0f, 100 + jp, String.valueOf(c.nimi) + " : " + this.maailma.getPlanets(c.nimi) + " / " + this.maailma.getPlanetsWithShipyards(c.nimi) + " : " + c.getModeInText() + " : " + " All fleets: " + c.getTotalNumberOfFleets(), Color.white);
            } else {
                jp -= 10;
            }
            jp += 10;
        }
        GL11.glDisable(3042);
        if (this.maailma.getMode() == "Attack" || this.maailma.getMode() == "Special") {
            this.views = "Game";
            this.pl = this.maailma.getPlayer();
            this.world.setPlayer(1, this.pl);
            this.world.allEntities.add(this.pl);
            this.pl1 = this.pl;
            this.pl2 = this.pl;
            this.players.clear();
            this.players.add(this.pl1);
        }
        if (this.campaignHelp) {
            int fl = this.ysize / 2;
            GL11.glDisable(3042);
            GL11.glColor3f(0.2f, 0.2f, 0.2f);
            GL11.glBegin(4);
            DrawingTools.drawRectangle(50.0f, fl - 5, this.xsize - 50, 5 + fl + this.campaignHelpText.size() * 15);
            GL11.glEnd();
            GL11.glEnable(3042);
            int j = 0;
            while (j < this.campaignHelpText.size()) {
                this.drawJustifiedText(this.font2, fl + j * 15, this.campaignHelpText.get(j), Color.white);
                ++j;
            }
        }
        this.drawStartUI();
    }

    private void viewHighscoretable() {
        this.drawText(this.font2, (this.xsize - this.font2.getWidth("Hiscores")) / 2, 80.0f, "Hiscores", Color.green);
        int j = 0;
        Object[] objectArray = this.taulu.getNames();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = objectArray[n2];
            if (s.equalsIgnoreCase("raah")) {
                this.ninja = true;
            }
            s = String.valueOf(s) + " " + this.taulu.getMedals()[j];
            this.drawText(this.font2, (this.xsize - this.font2.getWidth(s)) / 2 - 100, 600 - j * 20, s, Color.green);
            ++j;
            ++n2;
        }
        j = 0;
        int[] nArray = this.taulu.getScores();
        objectArray = nArray;
        n = nArray.length;
        n2 = 0;
        while (n2 < n) {
            String i = objectArray[n2];
            this.drawText(this.font2, (this.xsize - this.font2.getWidth(String.valueOf((int)i))) / 2 + 100, 600 - j * 20, String.valueOf((int)i), Color.green);
            ++j;
            ++n2;
        }
        if (this.ninja) {
            this.drawJustifiedText(this.font4, 620, "Ninja Detected! Ninja-mode unlocked!", Color.darkGray);
            this.boksit.add(new Boksi("Ninja Mode", new Point(this.xsize / 3 * 2 + 5, this.ysize / 100 * 65), new Point((int)((double)(this.xsize / 3) * 2.5), this.ysize / 100 * 69), "Start", "ninjaMode", this.dt));
        }
        this.drawStartUI();
    }

    private void viewGameOver(long delta, long lastTime) {
        this.tt.clear();
        delta = Sys.getTime() - lastTime;
        this.tt.add("Game Over");
        this.tt.add(String.valueOf(this.pl.getType()) + ", Your final score: " + this.pl.getScore());
        if (this.pl.getMedalsDigest().size() > 0) {
            this.tt.add("You were awarded the following medals: ");
            this.tt.addAll(this.pl.getMedalsDigest());
        }
        if (this.pl == this.pl1 && this.pl1hiscore || this.pl == this.pl2 && this.pl2hiscore) {
            this.tt.add("You made the Highscore table!");
            this.tt.add("Enter your name:");
            this.tt.add(this.nimi);
            lastTime = Sys.getTime();
        }
        if (this.t && (this.pl1hiscore || this.pl2hiscore)) {
            this.checkHiScore(this.pl);
            this.t = false;
            if (this.pl == this.pl1 && this.world.getMode().matches("twoPlayer")) {
                this.pl = this.pl2;
            } else {
                this.views = "Hiscoretable";
                this.pl = this.pl1;
            }
            lastTime = Sys.getTime();
            delta = Sys.getTime() - lastTime;
        }
        if (delta > 10000L) {
            if (this.pl == this.pl2) {
                lastTime = Sys.getTime();
                delta = Sys.getTime() - lastTime;
                this.world.setState("Playing");
                this.views = "Start";
            } else {
                this.pl = this.pl2;
                lastTime = Sys.getTime();
                delta = Sys.getTime() - lastTime;
            }
        }
        this.drawTextArray(this.font2, this.tt, 0, 220, Color.pink, true);
    }

    private void viewStart() {
        this.drawJustifiedText(this.font3, 80, "Goldwingu2", Color.orange);
        this.drawJustifiedText(this.font33, 120, "Episode1", Color.orange);
        this.drawJustifiedText(this.font4, 160, "Means to End", Color.orange);
        this.drawJustifiedText(this.font5, 200, "Conceived, designed and programmed by", Color.lightGray);
        this.drawJustifiedText(this.font5, 210, "Kimmo Savolainen", Color.lightGray);
        this.drawJustifiedText(this.font5, 220, "Version 0.17 (Goldwingu Actual 2.1.0.17)", Color.lightGray);
        this.drawStartUI();
    }

    private void viewHelp() {
        this.tt.clear();
        this.tt.add("Welcome to your destruction!");
        this.tt.add(" ");
        this.tt.add("One player instructions:");
        this.tt.add(" ");
        this.tt.add("Use cursor keys to move your ship.");
        this.tt.add("Bring up tactical display with " + Keyboard.getKeyName(this.valinnat.TGLDISPLAY) + ",");
        this.tt.add("Shoot with '" + Keyboard.getKeyName(this.valinnat.NORMALSHOT) + "' and '" + Keyboard.getKeyName(this.valinnat.POWERSHOT) + "' keys for normal and powershots.");
        this.tt.add("Shoot your missiles with '" + Keyboard.getKeyName(this.valinnat.MISSILE) + "' key.");
        this.tt.add("Adjust your ships speed with '" + Keyboard.getKeyName(this.valinnat.CHGSPEED) + "'" + " key (or " + Keyboard.getKeyName(this.valinnat.TGLQUICKCHANGE) + " + " + Keyboard.getKeyName(this.valinnat.LEFT) + "),");
        this.tt.add("and your weapons recharging rate with the '" + Keyboard.getKeyName(this.valinnat.CHGWEAPON) + "' key (or " + Keyboard.getKeyName(this.valinnat.TGLQUICKCHANGE) + " + " + Keyboard.getKeyName(this.valinnat.RIGHT) + ").");
        this.tt.add(" ");
        this.tt.add("Two player (co-op) instructions:");
        this.tt.add(" ");
        this.tt.add("Player1 tactical display: " + Keyboard.getKeyName(this.valinnat.PL1TGLDISPLAY));
        this.tt.add("Player2 tactical display: " + Keyboard.getKeyName(this.valinnat.PL2TGLDISPLAY));
        this.tt.add("Player1 movement: ('" + Keyboard.getKeyName(this.valinnat.PL1UP) + "', '" + Keyboard.getKeyName(this.valinnat.PL1DOWN) + "', '" + Keyboard.getKeyName(this.valinnat.PL1LEFT) + "', '" + Keyboard.getKeyName(this.valinnat.PL1RIGHT) + "')");
        this.tt.add("Player2 movement: (" + Keyboard.getKeyName(this.valinnat.PL2UP) + " " + Keyboard.getKeyName(this.valinnat.PL2DOWN) + " " + Keyboard.getKeyName(this.valinnat.PL2LEFT) + " " + Keyboard.getKeyName(this.valinnat.PL2RIGHT) + ")");
        this.tt.add("Player1 normal shots '" + Keyboard.getKeyName(this.valinnat.PL1NORMALSHOT) + "', powershots '" + Keyboard.getKeyName(this.valinnat.PL1POWERSHOT) + "' and missiles '" + Keyboard.getKeyName(this.valinnat.PL1MISSILE) + "'.");
        this.tt.add("Player2 normal shots '" + Keyboard.getKeyName(this.valinnat.PL2NORMALSHOT) + "', powershots '" + Keyboard.getKeyName(this.valinnat.PL2POWERSHOT) + "' and missiles '" + Keyboard.getKeyName(this.valinnat.PL2MISSILE) + "'.");
        this.tt.add("Player1 Speed '" + Keyboard.getKeyName(this.valinnat.PL1CHGSPEED) + "' and weapon recharge '" + Keyboard.getKeyName(this.valinnat.PL1CHGWEAPON) + "' adjusting (or " + Keyboard.getKeyName(this.valinnat.PL1TGLQUICKCHANGE) + " + " + Keyboard.getKeyName(this.valinnat.PL1LEFT) + " and " + Keyboard.getKeyName(this.valinnat.PL1TGLQUICKCHANGE) + " + " + Keyboard.getKeyName(this.valinnat.PL1RIGHT) + ")");
        this.tt.add("Player2 Speed '" + Keyboard.getKeyName(this.valinnat.PL2CHGSPEED) + "' and weapon recharge '" + Keyboard.getKeyName(this.valinnat.PL2CHGWEAPON) + "' adjusting (or " + Keyboard.getKeyName(this.valinnat.PL2TGLQUICKCHANGE) + " + " + Keyboard.getKeyName(this.valinnat.PL2LEFT) + " and " + Keyboard.getKeyName(this.valinnat.PL2TGLQUICKCHANGE) + " + " + Keyboard.getKeyName(this.valinnat.PL2RIGHT) + ")");
        this.tt.add(" ");
        this.tt.add("Campaign Instructions:");
        this.tt.add(" ");
        this.tt.add("In campaign mode you can save the universe from not being under Human rule");
        this.tt.add(" with your awesome reflexes!");
        this.tt.add("Attack enemy fleets with your ship to give us a chance to build our own production capacity.");
        this.tt.add("Click a planet or an enemy fleet to attack it.");
        this.tt.add(" ");
        this.tt.add("Be careful not to drain your shields though!");
        this.tt.add("Powershots are faster and more powerful but limited in number,");
        this.tt.add("you get more powershots from successful hits from your normal shots.");
        this.tt.add("The number of your missiles increases over time.");
        this.tt.add("You can earn medals for outstanding achievements.");
        this.drawTextArray(this.font2, this.tt, 0, 100, Color.white, true);
        this.drawStartUI();
    }

    private void drawWorld() {
        int size = 0;
        for (Entity e : this.world.getAll()) {
            size += e.getRep().length;
        }
        this.vertices = new float[size * 3];
        this.colors = new float[size * 3];
        int laskuri = 0;
        boolean byteLaskuri = false;
        for (Entity e : this.world.getAll()) {
            Atom[] atomArray = e.getRep();
            int n = atomArray.length;
            int n2 = 0;
            while (n2 < n) {
                Atom a = atomArray[n2];
                this.colors[laskuri] = 0.4f;
                this.vertices[laskuri++] = 0.5f + (a.getX() + (float)e.middle.x) * (float)this.zoomlevel;
                this.colors[laskuri] = 0.4f;
                this.vertices[laskuri++] = 0.5f + (a.getY() + (float)e.middle.y) * (float)this.zoomlevel;
                this.colors[laskuri] = 0.4f;
                this.vertices[laskuri++] = 0.0f;
                ++n2;
            }
        }
        this.setupQuad(this.vertices, this.colors);
        this.vertices = null;
        this.colors = null;
        GL20.glUseProgram(this.pId);
        GL30.glBindVertexArray(this.vaoId);
        GL20.glEnableVertexAttribArray(0);
        GL20.glEnableVertexAttribArray(1);
        GL11.glDrawArrays(0, 0, this.vertexCount);
        GL15.glBindBuffer(34963, 0);
        GL20.glDisableVertexAttribArray(0);
        GL20.glDisableVertexAttribArray(1);
        GL30.glBindVertexArray(0);
        GL20.glUseProgram(0);
        this.GLError("Piirrossa meni pieleen!");
    }

    private void changePlanetColor(CampaignPlayer owner, boolean b) {
        if (b) {
            GL11.glColor3f(owner.a, owner.b, owner.c);
        } else {
            GL11.glColor3f(owner.a / 2.0f, owner.b / 2.0f, owner.c / 2.0f);
        }
    }

    private void checkHiScore(Player p) {
        int score = p.getScore();
        String m = p.getMedalString();
        if (this.taulu.checkScores(score)) {
            this.taulu.putNewScore(score, this.nimi, m);
            this.nimi = "";
            try {
                FileOutputStream f_out = new FileOutputStream("hiscoretable");
                ObjectOutputStream obj_out = new ObjectOutputStream(f_out);
                obj_out.writeObject(this.taulu);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void drawHollowRectangle(float x1, float y1, float x2, float y2) {
        GL11.glBegin(2);
        GL11.glVertex2f(x1 + 100.0f, y1);
        GL11.glVertex2f(x2 + 70.0f, y1);
        GL11.glVertex2f(x2 + 70.0f, y2);
        GL11.glVertex2f(x1 + 100.0f, y2);
        GL11.glEnd();
    }

    public void processKeyboard() {
        boolean shift;
        if ((this.views == "Options1" || this.views == "Options2") && this.changingOption) {
            while (Keyboard.next()) {
                if (Keyboard.isKeyDown(28)) {
                    this.valinnat.changeHighlightedOption(this.option);
                    this.changingOption = false;
                    this.option = null;
                    continue;
                }
                if (Keyboard.isKeyDown(1)) {
                    this.changingOption = false;
                    continue;
                }
                if (!Keyboard.getEventKeyState()) continue;
                this.option = Keyboard.getKeyName(Keyboard.getEventKey());
            }
        }
        if (this.views == "Game Over" && (this.pl1hiscore || this.pl2hiscore)) {
            while (Keyboard.next() && !this.t) {
                if (!Keyboard.getEventKeyState()) continue;
                if (Keyboard.getEventKey() == 28) {
                    this.t = true;
                }
                if (Keyboard.getEventKey() == 14 && this.nimi.length() > 0) {
                    this.nimi = this.nimi.substring(0, this.nimi.length() - 1);
                } else if (this.nimi.length() < 15) {
                    this.nimi = String.valueOf(this.nimi) + Keyboard.getEventCharacter();
                }
                this.nimi = this.CheckForLetters(this.nimi);
            }
        }
        if (this.views == "Start") {
            if (Keyboard.isKeyDown(57)) {
                this.views = "Game";
                this.startNewGame("Game");
            }
            return;
        }
        if (this.views == "Campaign") {
            this.campaignHelp = Keyboard.isKeyDown(15);
            while (Keyboard.next()) {
                if (!Keyboard.getEventKeyState()) continue;
                if (Keyboard.getEventKey() == 203) {
                    this.currentPlanet = this.currentPlanet == this.maailma.getPlanets().size() - 1 ? 0 : ++this.currentPlanet;
                    this.current = this.maailma.getPlanets().get(this.currentPlanet);
                }
                if (Keyboard.getEventKey() != this.valinnat.TOGGLEPAUSE) continue;
                this.maailma.togglePause();
            }
        }
        if (this.views == "Game") {
            shift = false;
            if (Keyboard.isKeyDown(this.valinnat.TGLDISPLAY)) {
                this.pl1.setTacticalDisplay(true);
            } else {
                this.pl1.setTacticalDisplay(false);
            }
            if (Keyboard.isKeyDown(this.valinnat.UP)) {
                this.pl1.setUp();
            }
            if (Keyboard.isKeyDown(this.valinnat.DOWN)) {
                this.pl1.setDown();
            }
            if (Keyboard.isKeyDown(this.valinnat.LEFT) && !shift) {
                this.pl1.setLeft();
            }
            if (Keyboard.isKeyDown(this.valinnat.RIGHT) && !shift) {
                this.pl1.setRight();
            }
            if (Keyboard.isKeyDown(this.valinnat.TGLQUICKCHANGE)) {
                shift = true;
            }
            if (shift) {
                if (this.dashTimer == 0L) {
                    this.dashTimer = Sys.getTime();
                }
                if (Sys.getTime() - this.dashTimer > 2000L) {
                    this.pl1.setDash(shift);
                }
            }
            if (this.dashTimer > 0L && !shift) {
                this.dashTimer = 0L;
                this.pl1.setDash(shift);
            }
            if (Keyboard.isKeyDown(this.valinnat.POWERSHOT)) {
                this.pl1.setShoot2();
            }
            while (Keyboard.next()) {
                if (!Keyboard.getEventKeyState()) continue;
                if (Keyboard.getEventKey() == this.valinnat.CHGWEAPON || Keyboard.getEventKey() == this.valinnat.LEFT && shift) {
                    this.pl1.adjustWeaponCharge();
                }
                if (Keyboard.getEventKey() == this.valinnat.CHGSPEED || Keyboard.getEventKey() == this.valinnat.RIGHT && shift) {
                    this.pl1.adjustThrusterCharge();
                }
                if (Keyboard.getEventKey() == this.valinnat.NORMALSHOT) {
                    this.pl1.setShoot();
                }
                if (Keyboard.getEventKey() == this.valinnat.MISSILE) {
                    this.pl1.setShootMissile();
                }
                if (Keyboard.getEventKey() == this.valinnat.TOGGLEPAUSE) {
                    this.world.togglePause();
                }
                if (Keyboard.getEventKey() != this.valinnat.HYPERSPACE) continue;
                this.world.setHyperSpace();
            }
        }
        if (this.views == "twoPlayer") {
            shift = false;
            boolean shift2 = false;
            if (Keyboard.isKeyDown(this.valinnat.PL1TGLDISPLAY) && this.pl1.isAlive()) {
                this.pl1.setTacticalDisplay(true);
            } else {
                this.pl1.setTacticalDisplay(false);
            }
            if (Keyboard.isKeyDown(this.valinnat.PL2TGLDISPLAY) && this.pl2.isAlive()) {
                this.pl2.setTacticalDisplay(true);
            } else {
                this.pl2.setTacticalDisplay(false);
            }
            if (Keyboard.isKeyDown(this.valinnat.PL1UP)) {
                this.pl1.setUp();
            }
            if (Keyboard.isKeyDown(this.valinnat.PL2UP)) {
                this.pl2.setUp();
            }
            if (Keyboard.isKeyDown(this.valinnat.PL2DOWN)) {
                this.pl2.setDown();
            }
            if (Keyboard.isKeyDown(this.valinnat.PL2LEFT) && !shift2) {
                this.pl2.setLeft();
            }
            if (Keyboard.isKeyDown(this.valinnat.PL2RIGHT) && !shift2) {
                this.pl2.setRight();
            }
            if (Keyboard.isKeyDown(this.valinnat.PL1DOWN)) {
                this.pl1.setDown();
            }
            if (Keyboard.isKeyDown(this.valinnat.PL1LEFT) && !shift) {
                this.pl1.setLeft();
            }
            if (Keyboard.isKeyDown(this.valinnat.PL1RIGHT) && !shift) {
                this.pl1.setRight();
            }
            if (Keyboard.isKeyDown(this.valinnat.PL1TGLQUICKCHANGE)) {
                shift = true;
            }
            if (Keyboard.isKeyDown(this.valinnat.PL2TGLQUICKCHANGE)) {
                shift2 = true;
            }
            if (Keyboard.isKeyDown(this.valinnat.PL1POWERSHOT)) {
                this.pl1.setShoot2();
            }
            if (Keyboard.isKeyDown(this.valinnat.PL2POWERSHOT)) {
                this.pl2.setShoot2();
            }
            while (Keyboard.next()) {
                if (!Keyboard.getEventKeyState()) continue;
                if (Keyboard.getEventKey() == this.valinnat.PL1CHGWEAPON && shift) {
                    this.pl1.adjustWeaponCharge();
                }
                if (Keyboard.getEventKey() == this.valinnat.PL1CHGSPEED && shift) {
                    this.pl1.adjustThrusterCharge();
                }
                if (Keyboard.getEventKey() == this.valinnat.PL1NORMALSHOT) {
                    this.pl1.setShoot();
                }
                if (Keyboard.getEventKey() == this.valinnat.PL2CHGWEAPON && shift2) {
                    this.pl1.adjustWeaponCharge();
                }
                if (Keyboard.getEventKey() == this.valinnat.PL2CHGSPEED && shift2) {
                    this.pl2.adjustThrusterCharge();
                }
                if (Keyboard.getEventKey() == this.valinnat.PL2NORMALSHOT) {
                    this.pl2.setShoot();
                }
                if (Keyboard.getEventKey() == this.valinnat.PL1MISSILE) {
                    this.pl1.setShootMissile();
                }
                if (Keyboard.getEventKey() == this.valinnat.PL2MISSILE) {
                    this.pl2.setShootMissile();
                }
                if (Keyboard.getEventKey() != this.valinnat.TOGGLEPAUSE) continue;
                this.world.togglePause();
            }
        }
    }

    private void startNewGame(String string) {
        if (string == "Campaign") {
            int[] k = new int[this.arvoBoksit.size()];
            int j = 0;
            while (j < this.arvoBoksit.size()) {
                if (j < 3) {
                    k[j] = this.arvoBoksit.get((int)j).arvoAsNumber;
                } else {
                    k[j - 1] = this.arvoBoksit.get((int)j).arvoAsNumber;
                }
                ++j;
            }
            this.maailma.createUniverse(k);
            this.current = this.maailma.getPlanets().get(0);
            this.maailma.setScenario(this.scenarios.getChosenOne());
            this.currentPlanet = 0;
            this.world.newGame(string, 0);
            this.world.setPlayer(1, this.world.createNewPlayer(1));
            this.maailma.setPlayer(this.world.createNewPlayer(1));
        }
        if (string == "Game" || string == "twoPlayer" || string == "ninjaMode") {
            this.world.newGame(string, 0);
            this.players.clear();
            this.pl1 = this.world.getPlayer(1);
            this.players.add(this.pl1);
            if (string.matches("twoPlayer")) {
                this.pl2 = this.world.getPlayer(2);
                this.players.add(this.pl2);
            } else {
                this.pl2 = this.world.getPlayer(1);
            }
            this.pl = this.pl1;
        }
    }

    private String CheckForLetters(String nimi2) {
        String palautus = new String();
        char[] cArray = nimi2.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (this.isLetter(c)) {
                palautus = String.valueOf(palautus) + c;
            }
            ++n2;
        }
        return palautus;
    }

    private boolean isLetter(char eventCharacter) {
        char[] kirjaimet;
        char[] cArray = kirjaimet = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'x', 'y', '\u00e5', '\u00e4', '\u00f6', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00c5', '\u00c4', '\u00d6'};
        int n = kirjaimet.length;
        int n2 = 0;
        while (n2 < n) {
            char f = cArray[n2];
            if (eventCharacter == f) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public Color changeTextColor(int color) {
        if (color > 80) {
            return Color.green;
        }
        if (color > 40) {
            return Color.yellow;
        }
        return Color.red;
    }

    public Color tacticalDisplayColor(Player p) {
        Color c;
        if (p == this.pl1) {
            c = Color.lightGray;
            if (p.delta % 2L != 0L) {
                c = Color.gray;
            }
        } else {
            c = Color.blue;
            if (p.delta % 2L != 0L) {
                c = Color.darkGray;
            }
        }
        return c;
    }

    public void drawText(TrueTypeFont f, float x, float y, String s, Color c) {
        f.drawString(x, y, s, c);
    }

    public void drawCenterText(TrueTypeFont f, float x, float y, String s, Color c) {
        f.drawString(x - (float)(f.getWidth(s) / 2), y - (float)(f.getHeight() / 2), s, c);
    }

    public void drawArvoBoxes(arvoBoksi b) {
        this.drawBoxes(b.arvo);
        this.drawBoxes(b.nimi);
        this.drawBoxes(b.isompi);
        this.drawBoxes(b.vielaIsompi);
        this.drawBoxes(b.pienempi);
        this.drawBoxes(b.vielaPienempi);
    }

    public void drawBoxes(Boksi b) {
        b.drawMe(this.font2);
    }

    public void drawStartUI() {
        for (Boksi b : this.boksit) {
            if (this.views != b.viewOrigin) continue;
            b.drawMe(this.font2);
        }
        for (arvoBoksi ab : this.arvoBoksit) {
            if (this.views != ab.viewOrigin) continue;
            this.drawArvoBoxes(ab);
        }
        if (this.views == "Campaign options") {
            this.scenarios.drawMe(Mouse.getX(), this.ysize - Mouse.getY(), Mouse.isButtonDown(0));
        }
    }

    public void processMouse() {
        if (Mouse.isButtonDown(0) && !this.klicka) {
            this.klicka = true;
        }
        for (Boksi b : this.boksit) {
            if (this.views != b.viewOrigin) continue;
            if (!b.noHighlight) {
                b.didItHitMe(Mouse.getX(), this.ysize - Mouse.getY());
            }
            if (b.highlight && Mouse.isButtonDown(0) && !b.isToggle) {
                this.views = b.viewDestination;
                if (this.views == "Game" || this.views == "twoPlayer" || this.views == "Campaign" || this.views == "ninjaMode") {
                    this.startNewGame(this.views);
                }
                if (this.views == "ninjaMode") {
                    this.views = "Game";
                }
                if (this.views == "Campaign options") {
                    this.prepareScenarios();
                }
            }
            if (!b.highlight || !b.isToggle || !this.klicka || Mouse.isButtonDown(0)) continue;
            b.switchToggle();
        }
        for (arvoBoksi ab : this.arvoBoksit) {
            if (this.views != ab.viewOrigin) continue;
            if (this.klicka && !Mouse.isButtonDown(0)) {
                ab.changeValue(Mouse.getX(), this.ysize - Mouse.getY(), true);
                continue;
            }
            ab.changeValue(Mouse.getX(), this.ysize - Mouse.getY(), false);
        }
        if (!Mouse.isButtonDown(0)) {
            this.klicka = false;
        }
        if (this.views == "Options1" || this.views == "Options2") {
            if (this.views == "Options1") {
                for (Optio o : this.valinnat.optiot) {
                    if (!this.changingOption) {
                        o.box.didItHitMe(Mouse.getX(), this.ysize - Mouse.getY());
                    }
                    if (!o.box.highlight || !Mouse.isButtonDown(0)) continue;
                    this.changingOption = true;
                }
            }
            if (this.views == "Options2") {
                for (Optio o : this.valinnat.twoploptiot) {
                    if (!this.changingOption) {
                        o.box.didItHitMe(Mouse.getX(), this.ysize - Mouse.getY());
                    }
                    if (!o.box.highlight || !Mouse.isButtonDown(0)) continue;
                    this.changingOption = true;
                }
            }
        }
        if (this.views == "Campaign options") {
            while (this.arvoBoksit.size() - 3 < this.numberOfEnemies.arvoAsNumber) {
                int d = this.arvoBoksit.size() - 3;
                String nimi = "Enemy Planets " + d;
                this.arvoBoksit.add(new arvoBoksi(nimi, "1", 1, -1, new Point(200, 290 + 24 * d), new Point(150, 400), "Campaign options", this.dt, this.arvoBoksit.get((int)0).frozen));
            }
            while (this.arvoBoksit.size() - 3 > this.numberOfEnemies.arvoAsNumber) {
                this.arvoBoksit.remove(this.arvoBoksit.size() - 1);
            }
        }
        if (this.views == "Campaign") {
            if (Mouse.isButtonDown(0)) {
                this.maailma.clickedCoordinates(Mouse.getX(), this.ysize - Mouse.getY(), true);
            } else if (Mouse.isButtonDown(1)) {
                this.maailma.clickedCoordinates(Mouse.getX(), this.ysize - Mouse.getY(), true);
            }
        }
        if (this.views == "Achievements") {
            int x = this.achievementX;
            int y = this.achievementY;
            this.hoveringAchievement = null;
            for (Achievement a : this.tila.getAchievements()) {
                if (Mouse.getX() > x && Mouse.getX() < x + 64 && this.ysize - Mouse.getY() > y && this.ysize - Mouse.getY() < y + 64) {
                    this.hoveringAchievement = a;
                }
                if ((x += 70) <= 330) continue;
                y += 70;
                x = 50;
            }
        }
    }

    private void openGLTest() {
    }

    public void showComponents(Player p) {
        this.drawText(this.font5, 10.0f, this.ysize - 60, p.getComponentMake(1), this.tacticalDisplayColor(p));
        this.drawText(this.font5, 10.0f, this.ysize - 50, p.getComponentMake(2), this.tacticalDisplayColor(p));
        this.drawText(this.font5, 10.0f, this.ysize - 40, p.getComponentMake(3), this.tacticalDisplayColor(p));
        this.drawText(this.font5, 10.0f, this.ysize - 30, p.getComponentMake(4), this.tacticalDisplayColor(p));
    }

    public void drawUI() {
        this.GLSetupForText();
        GL11.glEnable(3042);
        int yText = this.ysize - 14;
        for (Player p : this.players) {
            if (p.getDash()) {
                this.drawText(this.font5, 100.0f, 0.0f, "Dash activated", Color.white);
            }
            if (p.getIncidents().size() > 0) {
                int j = 0;
                while (j < p.getIncidents().size()) {
                    if (p.getIncidents().get((int)j).incidentTimer < 128) {
                        String s = p.getIncidents().get((int)j).teksti;
                        this.drawText(this.font5, this.xsize - this.font5.getWidth(s) + p.getIncidents().get((int)j).incidentTimer, 300 + j * 10, s, Color.white);
                    }
                    ++j;
                }
            }
            this.drawText(this.font2, 100.0f, this.ysize - 32, p.getMedalString(), Color.green);
            if (this.views == "twoPlayer") {
                this.drawText(this.font2, 100.0f, 16.0f, this.pl2.getMedalString(), Color.green);
            }
            this.drawText(this.font2, 100.0f, yText, p.getWeaponRechargeInText(), Color.white);
            this.drawText(this.font2, 180.0f, yText, p.getThrusterRechargeInText(), Color.white);
            this.drawText(this.font2, 260.0f, yText, p.getShieldsInText(), Color.lightGray);
            this.drawText(this.font2, 410.0f, yText, p.getShot2AmountInText(), Color.pink);
            this.drawText(this.font2, 545.0f, yText, "Score: " + p.getScore(), Color.orange);
            this.drawText(this.font2, 645.0f, yText, p.getNumberOfWarheadsinText(), Color.lightGray);
            if (this.world.getState() == "Level end") {
                int jj = 0;
                for (String s : this.world.getLevelEndInText()) {
                    this.drawJustifiedText(this.font2, this.ysize / 2 + jj, s, Color.pink);
                    jj += 20;
                }
            }
            if (p.getTacticalDisplay()) {
                if (this.componentTimer > 1) {
                    this.componentTimer /= 2;
                }
                int pmiddlex = p.middle.x * this.zoomlevel;
                int pmiddley = p.middle.y * this.zoomlevel;
                String per = "0%";
                if (p.howManyFired > 0) {
                    per = String.valueOf((int)((float)p.howManyHits / (float)p.howManyFired * 100.0f)) + "%";
                }
                this.drawText(this.font5, pmiddlex + 130, pmiddley - 20, "Accur:" + per, this.tacticalDisplayColor(p));
                this.drawText(this.font5, pmiddlex + 130, pmiddley - 10, "Shld: " + p.getShieldsInText(), this.tacticalDisplayColor(p));
                this.drawText(this.font5, pmiddlex + 130, pmiddley, "Perfect shots: " + this.world.getNumberOfMiddleShotsInPlay(), this.tacticalDisplayColor(p));
                int v = 0;
                for (Enemy e : this.world.getEnemies()) {
                    if (e.state == "Moving") {
                        int paikka = p.middle.x * this.zoomlevel + (e.middle.x - p.middle.x) / 2;
                        if (e.shields > 0 && e.middle.y < 0 && e.middle.y > -200) {
                            this.drawText(this.font5, paikka + 100, p.middle.y * this.zoomlevel + e.middle.y - 50, ".", Color.red);
                        }
                        if (e.getTargeted() > 0) {
                            float fx = e.middle.x * this.zoomlevel + 100;
                            float fy = e.middle.y * this.zoomlevel;
                            this.drawCenterText(this.font3, fx + 32.0f - (float)(e.getTargeted() / 10), fy - 4.0f, "]", this.tacticalDisplayColor(p));
                            this.drawCenterText(this.font3, fx - 30.0f + (float)(e.getTargeted() / 10), fy - 4.0f, "[", this.tacticalDisplayColor(p));
                            if (e.getTargeted() > 99) {
                                this.drawCenterText(this.font5, fx, fy - 25.0f, "TARGET LOCKED", this.tacticalDisplayColor(p));
                                ++v;
                            }
                        }
                    }
                    if (e.state != "Moving" || e.getTypeInt() != 11) continue;
                    this.drawCenterText(this.font5, e.middle.x * this.zoomlevel + 40, e.middle.y * this.zoomlevel - 10, "PRIMARY", Color.red);
                    this.drawCenterText(this.font5, e.middle.x * this.zoomlevel + 40, e.middle.y * this.zoomlevel + 5, "TARGET", Color.red);
                }
                if (v > 0) {
                    this.drawText(this.font5, pmiddlex + 130, pmiddley + 20, "Acquiring targets: " + p.getNumberOfWarheads() / 1000 + "/" + v, this.tacticalDisplayColor(p));
                }
            } else if (this.componentTimer < 128) {
                this.componentTimer *= 2;
            }
            yText = 0;
        }
        if (this.world.infoText().size() > 0) {
            int fl = this.ysize / 2;
            GL11.glDisable(3042);
            GL11.glColor3f(0.2f, 0.2f, 0.2f);
            GL11.glBegin(4);
            DrawingTools.drawRectangle(this.xsize / 2 - 120, fl - 5, this.xsize / 2 + 120, 5 + fl + this.world.infoText().size() * 15);
            GL11.glEnd();
            GL11.glEnable(3042);
            int j = 0;
            while (j < this.world.infoText().size()) {
                this.drawJustifiedText(this.font2, fl + j * 15, this.world.infoText().get(j), Color.red);
                ++j;
            }
        }
        GL11.glDisable(3042);
    }

    public void setupQuad(float[] vertices, float[] colors) {
        FloatBuffer verticesBuffer = BufferUtils.createFloatBuffer(vertices.length);
        verticesBuffer.put(vertices);
        verticesBuffer.flip();
        this.vertexCount = vertices.length;
        FloatBuffer colorsBuffer = BufferUtils.createFloatBuffer(colors.length);
        colorsBuffer.put(colors);
        colorsBuffer.flip();
        this.vboId = GL15.glGenBuffers();
        GL15.glBindBuffer(34962, this.vboId);
        GL15.glBufferData(34962, verticesBuffer, 35044);
        GL20.glVertexAttribPointer(0, 3, 5126, false, 0, 0L);
        GL15.glBindBuffer(34962, 0);
        this.vbocId = GL15.glGenBuffers();
        GL15.glBindBuffer(34962, this.vbocId);
        GL15.glBufferData(34962, colorsBuffer, 35044);
        GL20.glVertexAttribPointer(1, 3, 5126, false, 0, 0L);
        GL15.glBindBuffer(34962, 0);
        GL30.glBindVertexArray(0);
        this.GLError("Setuppi meni pieleen!");
    }

    public int loadShader(String filename, int type) {
        StringBuilder shaderSource = new StringBuilder();
        int shaderID = 0;
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(filename));
            while ((line = reader.readLine()) != null) {
                shaderSource.append(line).append("\n");
            }
            reader.close();
        }
        catch (IOException e) {
            System.err.println("Could not read file.");
            e.printStackTrace();
            System.exit(-1);
        }
        shaderID = GL20.glCreateShader(type);
        GL20.glShaderSource(shaderID, shaderSource);
        GL20.glCompileShader(shaderID);
        return shaderID;
    }

    public void GLError(String errorMessage) {
        int errorValue = GL11.glGetError();
        if (errorValue != 0) {
            String errorString = GLU.gluErrorString((int)errorValue);
            System.err.println("ERROR - " + errorMessage + ": " + errorString);
        }
    }

    public void destroyOpenGL() {
        GL20.glDisableVertexAttribArray(0);
        GL20.glDisableVertexAttribArray(1);
        GL20.glUseProgram(0);
        GL20.glDetachShader(this.pId, this.fsId);
        GL20.glDeleteShader(this.fsId);
        GL20.glDeleteProgram(this.pId);
        GL15.glBindBuffer(34962, 0);
        GL15.glBindBuffer(34962, 0);
        GL15.glDeleteBuffers(this.vboId);
        GL15.glDeleteBuffers(this.vbocId);
        GL30.glBindVertexArray(0);
        GL30.glDeleteVertexArrays(this.vaoId);
    }

    public class Optio {
        int key;
        String name;
        Boksi box;

        Optio(int k, String s, Boksi b) {
            this.key = k;
            this.name = s;
            this.box = b;
        }
    }

    public class Optiot {
        int NORMALSHOT;
        int POWERSHOT;
        int UP;
        int DOWN;
        int LEFT;
        int RIGHT;
        int TGLDISPLAY;
        int CHGSPEED;
        int CHGWEAPON;
        int TGLQUICKCHANGE;
        int MISSILE;
        int HYPERSPACE;
        int PL1NORMALSHOT;
        int PL1POWERSHOT;
        int PL1UP;
        int PL1DOWN;
        int PL1LEFT;
        int PL1RIGHT;
        int PL1TGLDISPLAY;
        int PL1CHGSPEED;
        int PL1CHGWEAPON;
        int PL1TGLQUICKCHANGE;
        int PL1MISSILE;
        int PL2NORMALSHOT;
        int PL2POWERSHOT;
        int PL2UP;
        int PL2DOWN;
        int PL2LEFT;
        int PL2RIGHT;
        int PL2TGLDISPLAY;
        int PL2CHGSPEED;
        int PL2CHGWEAPON;
        int PL2TGLQUICKCHANGE;
        int PL2MISSILE;
        int HYPERSPACE2;
        int TOGGLEPAUSE;
        int xSpacing;
        int ySpacing;
        ArrayList<Optio> optiot;
        ArrayList<Optio> twoploptiot;

        Optiot(int x, int y) {
            boolean xx = false;
            int yy = 100;
            this.xSpacing = 0;
            this.ySpacing = 0;
            this.optiot = new ArrayList();
            this.twoploptiot = new ArrayList();
            this.NORMALSHOT = 44;
            this.POWERSHOT = 45;
            this.UP = 200;
            this.DOWN = 208;
            this.LEFT = 203;
            this.RIGHT = 205;
            this.TGLDISPLAY = 29;
            this.CHGSPEED = 30;
            this.CHGWEAPON = 31;
            this.TGLQUICKCHANGE = 42;
            this.TOGGLEPAUSE = 25;
            this.MISSILE = 46;
            this.HYPERSPACE = 1;
            this.optiot.add(new Optio(this.NORMALSHOT, "Normal Shot", this.makeBoksi(this.NORMALSHOT)));
            this.optiot.add(new Optio(this.POWERSHOT, "Power Shot", this.makeBoksi(this.POWERSHOT)));
            this.optiot.add(new Optio(this.MISSILE, "Launch missile", this.makeBoksi(this.MISSILE)));
            this.optiot.add(new Optio(this.UP, "Move Up", this.makeBoksi(this.UP)));
            this.optiot.add(new Optio(this.DOWN, "Move Down", this.makeBoksi(this.DOWN)));
            this.optiot.add(new Optio(this.LEFT, "Move Left", this.makeBoksi(this.LEFT)));
            this.optiot.add(new Optio(this.RIGHT, "Move Right", this.makeBoksi(this.RIGHT)));
            this.optiot.add(new Optio(this.TGLDISPLAY, "Tactical Display", this.makeBoksi(this.TGLDISPLAY)));
            this.optiot.add(new Optio(this.CHGSPEED, "Change Speed", this.makeBoksi(this.CHGSPEED)));
            this.optiot.add(new Optio(this.CHGWEAPON, "Change Weapon", this.makeBoksi(this.CHGWEAPON)));
            this.optiot.add(new Optio(this.TGLQUICKCHANGE, "Chargings Quick change", this.makeBoksi(this.TGLQUICKCHANGE)));
            this.optiot.add(new Optio(this.TOGGLEPAUSE, "Toggle Pause", this.makeBoksi(this.TOGGLEPAUSE)));
            this.optiot.add(new Optio(this.HYPERSPACE, "Hyperspace", this.makeBoksi(this.HYPERSPACE)));
            this.PL1NORMALSHOT = 33;
            this.PL1POWERSHOT = 19;
            this.PL1MISSILE = 47;
            this.PL1UP = 17;
            this.PL1DOWN = 31;
            this.PL1LEFT = 30;
            this.PL1RIGHT = 32;
            this.PL1TGLDISPLAY = 29;
            this.PL1CHGSPEED = 16;
            this.PL1CHGWEAPON = 18;
            this.PL1TGLQUICKCHANGE = 42;
            this.PL2NORMALSHOT = 36;
            this.PL2POWERSHOT = 37;
            this.PL2MISSILE = 38;
            this.PL2UP = 200;
            this.PL2DOWN = 208;
            this.PL2LEFT = 203;
            this.PL2RIGHT = 205;
            this.PL2TGLDISPLAY = 157;
            this.PL2CHGSPEED = 23;
            this.PL2CHGWEAPON = 24;
            this.PL2TGLQUICKCHANGE = 54;
            this.ySpacing = 0;
            this.twoploptiot.add(new Optio(this.PL1NORMALSHOT, "Player 1 Normal Shot", this.makeBoksi(this.PL1NORMALSHOT)));
            this.twoploptiot.add(new Optio(this.PL1POWERSHOT, "Player 1 Power Shot", this.makeBoksi(this.PL1POWERSHOT)));
            this.twoploptiot.add(new Optio(this.PL1MISSILE, "Player 1 Missile", this.makeBoksi(this.PL1MISSILE)));
            this.twoploptiot.add(new Optio(this.PL1UP, "Player 1 Move Up", this.makeBoksi(this.PL1UP)));
            this.twoploptiot.add(new Optio(this.PL1DOWN, "Player 1 Move Down", this.makeBoksi(this.PL1DOWN)));
            this.twoploptiot.add(new Optio(this.PL1LEFT, "Player 1 Move Left", this.makeBoksi(this.PL1LEFT)));
            this.twoploptiot.add(new Optio(this.PL1RIGHT, "Player 1 Move Right", this.makeBoksi(this.PL1RIGHT)));
            this.twoploptiot.add(new Optio(this.PL1TGLDISPLAY, "Player 1 Tactical Display", this.makeBoksi(this.PL1TGLDISPLAY)));
            this.twoploptiot.add(new Optio(this.PL1CHGSPEED, "Player 1 Change Speed", this.makeBoksi(this.PL1CHGSPEED)));
            this.twoploptiot.add(new Optio(this.PL1CHGWEAPON, "Player 1 Change Weapon", this.makeBoksi(this.PL1CHGWEAPON)));
            this.twoploptiot.add(new Optio(this.PL1TGLQUICKCHANGE, "Pl1 Chargings Quick change", this.makeBoksi(this.PL1TGLQUICKCHANGE)));
            this.twoploptiot.add(new Optio(this.PL2NORMALSHOT, "Player 2 Normal Shot", this.makeBoksi(this.PL2NORMALSHOT)));
            this.twoploptiot.add(new Optio(this.PL2POWERSHOT, "Player 2 Power Shot", this.makeBoksi(this.PL2POWERSHOT)));
            this.twoploptiot.add(new Optio(this.PL2MISSILE, "Player 2 Missile", this.makeBoksi(this.PL2MISSILE)));
            this.twoploptiot.add(new Optio(this.PL2UP, "Player 2 Move Up", this.makeBoksi(this.PL2UP)));
            this.twoploptiot.add(new Optio(this.PL2DOWN, "Player 2 Move Down", this.makeBoksi(this.PL2DOWN)));
            this.twoploptiot.add(new Optio(this.PL2LEFT, "Player 2 Move Left", this.makeBoksi(this.PL2LEFT)));
            this.twoploptiot.add(new Optio(this.PL2RIGHT, "Player 2 Move Right", this.makeBoksi(this.PL2RIGHT)));
            this.twoploptiot.add(new Optio(this.PL2TGLDISPLAY, "Player 2 Tactical Display", this.makeBoksi(this.PL2TGLDISPLAY)));
            this.twoploptiot.add(new Optio(this.PL2CHGSPEED, "Player 2 Change Speed", this.makeBoksi(this.PL2CHGSPEED)));
            this.twoploptiot.add(new Optio(this.PL2CHGWEAPON, "Player 2 Change Weapon", this.makeBoksi(this.PL2CHGWEAPON)));
            this.twoploptiot.add(new Optio(this.PL2TGLQUICKCHANGE, "Pl2 Chargings Quick change", this.makeBoksi(this.PL2TGLQUICKCHANGE)));
        }

        public boolean checkCollisions(String option, int pl) {
            if (pl == 1) {
                for (Optio o : this.optiot) {
                    if (!o.box.nimi.equalsIgnoreCase(option) || o.box.highlight) continue;
                    return true;
                }
            }
            if (pl == 2) {
                for (Optio o : this.twoploptiot) {
                    if (!o.box.nimi.equalsIgnoreCase(option) || o.box.highlight) continue;
                    return true;
                }
            }
            return false;
        }

        public void changeHighlightedOption(String key) {
            for (Optio o : this.optiot) {
                if (!o.box.highlight) continue;
                if (o.key == this.NORMALSHOT) {
                    this.NORMALSHOT = Keyboard.getKeyIndex(key);
                }
                if (o.key == this.POWERSHOT) {
                    this.POWERSHOT = Keyboard.getKeyIndex(key);
                }
                if (o.key == this.UP) {
                    this.UP = Keyboard.getKeyIndex(key);
                }
                if (o.key == this.DOWN) {
                    this.DOWN = Keyboard.getKeyIndex(key);
                }
                if (o.key == this.LEFT) {
                    this.LEFT = Keyboard.getKeyIndex(key);
                }
                if (o.key == this.RIGHT) {
                    this.RIGHT = Keyboard.getKeyIndex(key);
                }
                if (o.key == this.TGLDISPLAY) {
                    this.TGLDISPLAY = Keyboard.getKeyIndex(key);
                }
                if (o.key == this.CHGSPEED) {
                    this.CHGSPEED = Keyboard.getKeyIndex(key);
                }
                if (o.key == this.CHGWEAPON) {
                    this.CHGWEAPON = Keyboard.getKeyIndex(key);
                }
                if (o.key == this.TGLQUICKCHANGE) {
                    this.TGLQUICKCHANGE = Keyboard.getKeyIndex(key);
                }
                if (o.key == this.TOGGLEPAUSE) {
                    this.TOGGLEPAUSE = Keyboard.getKeyIndex(key);
                }
                o.key = Keyboard.getKeyIndex(key);
                o.box.nimi = Keyboard.getKeyName(o.key);
                o.box.highlight = false;
                return;
            }
            for (Optio o : this.twoploptiot) {
                if (!o.box.highlight) continue;
                if (o.key == this.PL1NORMALSHOT) {
                    this.PL1NORMALSHOT = Keyboard.getKeyIndex(key);
                }
                if (o.key == this.PL1POWERSHOT) {
                    this.PL1POWERSHOT = Keyboard.getKeyIndex(key);
                }
                if (o.key == this.PL1MISSILE) {
                    this.PL1MISSILE = Keyboard.getKeyIndex(key);
                }
                if (o.key == this.PL1UP) {
                    this.PL1UP = Keyboard.getKeyIndex(key);
                }
                if (o.key == this.PL1DOWN) {
                    this.PL1DOWN = Keyboard.getKeyIndex(key);
                }
                if (o.key == this.PL1LEFT) {
                    this.PL1LEFT = Keyboard.getKeyIndex(key);
                }
                if (o.key == this.PL1RIGHT) {
                    this.PL1RIGHT = Keyboard.getKeyIndex(key);
                }
                if (o.key == this.PL1TGLDISPLAY) {
                    this.PL1TGLDISPLAY = Keyboard.getKeyIndex(key);
                }
                if (o.key == this.PL1CHGSPEED) {
                    this.PL1CHGSPEED = Keyboard.getKeyIndex(key);
                }
                if (o.key == this.PL1CHGWEAPON) {
                    this.PL1CHGWEAPON = Keyboard.getKeyIndex(key);
                }
                if (o.key == this.PL1TGLQUICKCHANGE) {
                    this.PL1TGLQUICKCHANGE = Keyboard.getKeyIndex(key);
                }
                if (o.key == this.PL2NORMALSHOT) {
                    this.PL2NORMALSHOT = Keyboard.getKeyIndex(key);
                }
                if (o.key == this.PL2POWERSHOT) {
                    this.PL2POWERSHOT = Keyboard.getKeyIndex(key);
                }
                if (o.key == this.PL2MISSILE) {
                    this.PL2MISSILE = Keyboard.getKeyIndex(key);
                }
                if (o.key == this.PL2UP) {
                    this.PL2UP = Keyboard.getKeyIndex(key);
                }
                if (o.key == this.PL2DOWN) {
                    this.PL2DOWN = Keyboard.getKeyIndex(key);
                }
                if (o.key == this.PL2LEFT) {
                    this.PL2LEFT = Keyboard.getKeyIndex(key);
                }
                if (o.key == this.PL2RIGHT) {
                    this.PL2RIGHT = Keyboard.getKeyIndex(key);
                }
                if (o.key == this.PL2TGLDISPLAY) {
                    this.PL2TGLDISPLAY = Keyboard.getKeyIndex(key);
                }
                if (o.key == this.PL2CHGSPEED) {
                    this.PL2CHGSPEED = Keyboard.getKeyIndex(key);
                }
                if (o.key == this.PL2CHGWEAPON) {
                    this.PL2CHGWEAPON = Keyboard.getKeyIndex(key);
                }
                if (o.key == this.PL2TGLQUICKCHANGE) {
                    this.PL2TGLQUICKCHANGE = Keyboard.getKeyIndex(key);
                }
                o.key = Keyboard.getKeyIndex(key);
                o.box.nimi = Keyboard.getKeyName(o.key);
                o.box.highlight = false;
                return;
            }
        }

        public Boksi makeBoksi(int key) {
            this.xSpacing = 400;
            this.ySpacing += 25;
            return new Boksi(Keyboard.getKeyName(key), new Point(this.xSpacing, this.ySpacing), new Point(this.xSpacing + 100, this.ySpacing + 20), "", "", View.this.dt);
        }
    }
}

