/*
 * Decompiled with CFR 0.152.
 */
package peli;

import java.util.ArrayList;
import java.util.Random;
import peli.Enemy;
import peli.Model;

public class Wave {
    protected ArrayList<Enemy> enemies;
    protected ArrayList<Enemy> enemyReps;
    protected ArrayList<String> enemyNames;
    protected int level;
    protected Model world;
    protected int type;
    int xborder;
    int yborder;
    protected Random r;
    protected int timeBetween;
    protected int[] enemys;
    protected int[] xDif;
    protected int[] yDif;
    protected int[] enemyParents;
    protected int minLevel;
    protected int maxLevel;
    protected int initialAmount;
    protected float increaseAmount;
    protected int skipLevelsDivisable;
    protected boolean compoundEnemy = false;

    Wave(Model w, int type) {
        this.r = new Random();
        this.world = w;
        this.type = type;
        this.enemies = new ArrayList();
        this.xborder = this.world.getXsize();
        this.yborder = this.world.getYsize();
        this.level = 1;
    }

    Wave(int[] enemys, int[] xDifferences, int[] yDifferences, int[] parents, int minLevel, int maxLevel, int initialAmount, float increaseAmount, int skipLevelsDivisable, Model w, int type) {
        this.enemies = new ArrayList();
        this.enemys = enemys;
        this.type = type;
        this.xDif = xDifferences;
        this.yDif = yDifferences;
        this.enemyParents = parents;
        this.minLevel = minLevel;
        this.maxLevel = maxLevel;
        this.initialAmount = initialAmount;
        this.increaseAmount = increaseAmount;
        this.skipLevelsDivisable = skipLevelsDivisable;
        this.world = w;
        this.xborder = this.world.getXsize();
        this.yborder = this.world.getYsize();
        this.r = new Random();
    }

    public int getEnemyAmount(int level) {
        return this.initialAmount + (int)(this.increaseAmount * (float)level);
    }

    public ArrayList<Enemy> getEnemies(int t, int time) {
        ArrayList<Enemy> palautus = new ArrayList<Enemy>();
        if (t > 0) {
            block0: while (palautus.size() < t) {
                int xpaikka = this.r.nextInt(this.xborder - 40) + 20;
                int ypaikka = -250;
                int f = 0;
                while (f < this.enemys.length) {
                    if (this.world.isEnemyAvailable(f)) {
                        if (f > 0) {
                            xpaikka += this.xDif[f - 1];
                            ypaikka += this.yDif[f - 1];
                        }
                        palautus.add(this.world.getCopyOfEnemy(this.enemys[f], xpaikka, ypaikka, palautus.size() * time * 50));
                        if (palautus.size() == t) continue block0;
                    }
                    ++f;
                }
            }
        }
        return palautus;
    }

    public void populateEnemies(int level, int timeDifference) {
        this.level = level;
        this.enemies.clear();
        int timer = 0;
        int timerAdd = 0;
        float enemyAmount = (float)this.initialAmount + this.increaseAmount * (float)level;
        if (level >= this.minLevel && (level < this.maxLevel || this.maxLevel == 0)) {
            int j = 0;
            while ((float)j < enemyAmount) {
                int xpaikka = this.r.nextInt(this.xborder / 10) * 9 + 10;
                int ypaikka = -250;
                int f = 0;
                while (f < this.enemys.length) {
                    if (this.world.isEnemyAvailable(this.enemys[f])) {
                        if (f > 0) {
                            xpaikka += this.xDif[f - 1];
                            ypaikka += this.yDif[f - 1];
                            if (this.xDif[f - 1] == 0 && this.yDif[f - 1] == 0) {
                                timerAdd += 200;
                            }
                        }
                        timer = 250 * j + timeDifference + timerAdd;
                        Enemy e = this.world.getCopyOfEnemy(this.enemys[f], xpaikka, ypaikka, timer);
                        this.enemies.add(e);
                    }
                    ++f;
                }
                ++j;
            }
            j = 0;
            int kierros = 0;
            for (Enemy e : this.enemies) {
                if (this.enemyParents[j] > 0) {
                    e.setParent(this.enemies.get(this.enemyParents[j] + kierros * this.enemyParents.length - 1));
                }
                if (++j != this.enemyParents.length) continue;
                j = 0;
                ++kierros;
            }
        }
    }
}

