/*
 * Decompiled with CFR 0.152.
 */
package peli;

import java.util.ArrayList;
import org.lwjgl.Sys;
import peli.Bullet;
import peli.Component;
import peli.Entity;
import peli.Model;

public class Weapon
extends Component {
    private ArrayList<Bullet> shots;
    private float chargeCapFactorial = 2.0f;
    private int currentChargeLevel = 2;
    private long lastTime;
    private Entity owner;
    private float quantity;

    Weapon(Entity owner, Model w, Bullet b, int quantity, int chargeCap, boolean increasePowerShots) {
        this.owner = owner;
        this.world = w;
        this.shots = new ArrayList();
        b.xUnitVector = 0.0f;
        b.yUnitVector = -1.0f;
        this.shots.add(b);
        this.shots.get((int)0).type = "Bullet1";
        this.lastTime = Sys.getTime();
        this.quantity = quantity;
        this.chargeCapFactorial = chargeCap;
    }

    public float getTotalCurrentChargeLevel() {
        return (float)this.currentChargeLevel * this.chargeCapFactorial;
    }

    public int getCurrentChargeLevel() {
        return this.currentChargeLevel;
    }

    public void updateCurrentChargeLevel(int t) {
        this.currentChargeLevel += t;
        if (this.currentChargeLevel > 3) {
            this.currentChargeLevel = 1;
        }
        if (this.currentChargeLevel < 1) {
            this.currentChargeLevel = 3;
        }
    }

    public void upgradeWeapon(String quality, int value) {
        if (quality.equals("Speed")) {
            for (Bullet b : this.shots) {
                b.speed += (float)(value / 1000);
            }
        }
        if (quality.equals("Power")) {
            for (Bullet b : this.shots) {
                b.shields += value;
            }
        }
        quality.equals("Size");
        if (quality.equals("Quantity")) {
            while (value > 0) {
                Bullet add = this.shots.get(0).copyMe();
                --value;
                this.shots.add(add);
            }
            float t = -this.shots.size() / 2 - 1;
            if (this.shots.size() % 2 == 0) {
                t += 0.5f;
            }
            for (Bullet b : this.shots) {
                b.setDestination(b.xx + (double)(t += 1.0f), b.yy - 5.0);
            }
        }
        if (quality.equals("Frequency")) {
            this.chargeCapFactorial *= (float)(value / 1000);
        }
    }

    public float getQuantity() {
        return this.quantity;
    }

    public void addToQuantity(float add) {
        this.quantity += add;
    }

    public boolean Shoot() {
        if ((float)(Sys.getTime() - this.lastTime) > 2000.0f / ((float)this.currentChargeLevel * this.chargeCapFactorial)) {
            this.lastTime = Sys.getTime();
            return this.makeShots();
        }
        return false;
    }

    private boolean makeShots() {
        if (this.quantity == 0.0f || this.quantity == 0.5f) {
            return false;
        }
        for (Bullet b : this.shots) {
            this.world.AddToAdditions(b.copyMe());
        }
        if (this.quantity > 0.0f) {
            this.quantity -= 1.0f;
        }
        return true;
    }

    public void targetting() {
    }
}

